/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectName
extends AbstractEffect {
    public static EffectName INSTANCE = new EffectName();

    private EffectName() {
        super(GlyphLib.EffectNameID, "Name");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Player player;
        ItemStack stack;
        MutableComponent newName = null;
        InventoryManager manager = spellContext.getCaster().getInvManager();
        SlotReference slotRef = manager.findItem(i -> i.m_41720_() == Items.f_42656_, InteractType.EXTRACT);
        if (slotRef.getHandler() != null) {
            ItemStack stack2 = slotRef.getHandler().getStackInSlot(slotRef.getSlot());
            newName = stack2.m_41611_().m_6879_();
        }
        if (newName == null && this.isRealPlayer((Entity)shooter) && shooter instanceof Player && (stack = StackUtil.getHeldSpellbook(player = (Player)shooter)) != ItemStack.f_41583_ && stack.m_41720_() instanceof SpellBook && stack.m_41783_() != null) {
            ISpellCaster caster = CasterUtil.getCaster(stack);
            newName = Component.m_237113_((String)caster.getSpellName());
        }
        rayTraceResult.m_82443_().m_6593_(newName);
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21530_();
        } else {
            entity = rayTraceResult.m_82443_();
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                item.m_32055_().m_41714_((Component)newName);
            }
        }
    }

    @Override
    public SpellTier getTier() {
        return SpellTier.TWO;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    public int getDefaultManaCost() {
        return 25;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Names an entity after the set Spell Name. Can be overridden with a name tag in the hotbar.";
    }
}

