/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RitualMobCapture
extends AbstractRitual {
    @Override
    protected void tick() {
        Level world = this.getWorld();
        int radius = 3;
        if (world.f_46443_) {
            BlockPos pos = this.getPos();
            ParticleUtil.spawnRitualAreaEffect(this.getPos(), this.getWorld(), this.rand, this.getCenterColor(), radius);
        }
        if (!this.getWorld().f_46443_ && world.m_46467_() % 60L == 0L) {
            boolean didWorkOnce = false;
            Level level = this.getWorld();
            BlockPos pos = this.getPos();
            block0: for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-radius, -radius, -radius), (BlockPos)pos.m_7918_(radius, radius, radius))) {
                MobJarTile tile;
                if (level.m_8055_(blockPos).m_60734_() != BlockRegistry.MOB_JAR || (tile = (MobJarTile)level.m_7702_(blockPos)) == null || tile.getEntity() != null) continue;
                for (Entity e : level.m_6249_((Entity)null, new AABB(tile.m_58899_()).m_82400_(5.0), this::canJar)) {
                    if (!tile.setEntityData(e)) continue;
                    e.m_142687_(Entity.RemovalReason.DISCARDED);
                    EntityFlyingItem followProjectile = new EntityFlyingItem(level, e.f_19825_, Vec3.m_82512_((Vec3i)tile.m_58899_()), 100, 50, 100);
                    level.m_7967_((Entity)followProjectile);
                    ParticleUtil.spawnPoof((ServerLevel)level, e.m_20097_().m_7494_());
                    didWorkOnce = true;
                    if (!(e instanceof Starbuncle)) continue block0;
                    Starbuncle starbuncle = (Starbuncle)e;
                    ANCriteriaTriggers.rewardNearbyPlayers(ANCriteriaTriggers.SHRUNK_STARBY, (ServerLevel)level, starbuncle.m_20183_(), 10);
                    continue block0;
                }
            }
            if (didWorkOnce) {
                this.setNeedsSource(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canJar(Entity e) {
        if (e.m_6095_().m_204039_(EntityTags.JAR_WHITELIST)) {
            return true;
        }
        if (e.m_6095_().m_204039_(EntityTags.JAR_BLACKLIST)) {
            return false;
        }
        if (!(e instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)e;
        if (e instanceof Player) return false;
        if (((LivingEntity)e).m_21224_()) return false;
        return true;
    }

    @Override
    public int getSourceCost() {
        return 500;
    }

    @Override
    public String getLangDescription() {
        return "Captures a nearby entity and places it into any nearby placed Containment Jars. After the first capture, this ritual requires additional source to continue. Mobs and jars must be within 3 blocks of the brazier.";
    }

    @Override
    public String getLangName() {
        return "Containment";
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("ars_nouveau", RitualLib.CONTAINMENT);
    }
}

