/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.item.ISpellHotkeyListener;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketHotkeyPressed {
    Key key;

    public PacketHotkeyPressed(Key key) {
        this.key = key;
    }

    public PacketHotkeyPressed(FriendlyByteBuf buf) {
        this.key = Key.valueOf(buf.m_130277_());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.key.name());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                InteractionHand hand = StackUtil.getHeldCasterTool((Player)player);
                if (hand == null) {
                    return;
                }
                ItemStack stack = player.m_21120_(hand);
                Item patt1279$temp = stack.m_41720_();
                if (!(patt1279$temp instanceof ISpellHotkeyListener)) {
                    return;
                }
                ISpellHotkeyListener hotkeyListener = (ISpellHotkeyListener)patt1279$temp;
                if (this.key == Key.NEXT) {
                    hotkeyListener.onNextKeyPressed(stack, player);
                } else if (this.key == Key.PREVIOUS) {
                    hotkeyListener.onPreviousKeyPressed(stack, player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Key {
        NEXT,
        PREVIOUS;

    }
}

