/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.entity.ChangeableBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyPotionBehavior;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BehaviorRegistry {
    private static final Map<ResourceLocation, CreateFromTag> REGISTRY = new HashMap<ResourceLocation, CreateFromTag>();

    public static void register(ResourceLocation name, CreateFromTag creator) {
        REGISTRY.put(name, creator);
    }

    public static ChangeableBehavior create(Entity entity, CompoundTag tag) {
        CreateFromTag create = REGISTRY.get(new ResourceLocation(tag.m_128461_("id")));
        return create == null ? null : create.create(entity, tag);
    }

    private BehaviorRegistry() {
    }

    static {
        BehaviorRegistry.register(StarbyTransportBehavior.TRANSPORT_ID, (entity, tag) -> new StarbyTransportBehavior((Starbuncle)entity, tag));
        BehaviorRegistry.register(StarbyPotionBehavior.POTION_ID, (entity, tag) -> new StarbyPotionBehavior((Starbuncle)entity, tag));
    }

    public static interface CreateFromTag {
        public ChangeableBehavior create(Entity var1, CompoundTag var2);
    }
}

