/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.common.lib.LibBlockNames;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStatesDatagen
extends BlockStateProvider {
    public BlockStatesDatagen(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerOnlyState(BlockRegistry.SOURCE_GEM_BLOCK, "source_gem_block");
        this.registerOnlyState(BlockRegistry.RED_SBED, "red_sbed");
        this.registerOnlyState(BlockRegistry.BLUE_SBED, "blue_sbed");
        this.registerOnlyState(BlockRegistry.GREEN_SBED, "green_sbed");
        this.registerOnlyState(BlockRegistry.YELLOW_SBED, "yellow_sbed");
        this.registerOnlyState(BlockRegistry.ORANGE_SBED, "orange_sbed");
        this.registerOnlyState(BlockRegistry.PURPLE_SBED, "purple_sbed");
        this.registerOnlyState(BlockRegistry.POTION_DIFFUSER, "potion_diffuser");
        this.registerDoor(BlockRegistry.ARCHWOOD_DOOR, "archwood_door");
        this.registerNormalCube(BlockRegistry.VOID_PRISM, "void_prism");
        for (String s : LibBlockNames.DECORATIVE_SOURCESTONE) {
            this.registerNormalCube((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ars_nouveau", s)), s);
        }
    }

    private void registerOnlyState(Block block, String registry) {
        this.simpleBlock(block, BlockStatesDatagen.getUncheckedModel(registry));
    }

    private void registerDoor(DoorBlock door, String reg) {
        this.doorBlock(door, reg, this.getBlockLoc(reg + "_bottom"), this.getBlockLoc(reg + "_top"));
    }

    public void signBlock(Block sign, String reg) {
        ModelBuilder signModel = ((BlockModelBuilder)this.models().withExistingParent(reg, new ResourceLocation("block/air"))).texture("particle", new ResourceLocation("ars_nouveau", "block/" + reg));
        this.getVariantBuilder(sign).forAllStates(arg_0 -> BlockStatesDatagen.lambda$signBlock$0((ModelFile)signModel, arg_0));
    }

    public void registerNormalCube(Block block, String registry) {
        this.buildNormalCube(registry);
        if (LibBlockNames.DIRECTIONAL_SOURCESTONE.contains(registry)) {
            this.horizontalBlock(block, BlockStatesDatagen.getUncheckedModel(registry));
        } else {
            this.simpleBlock(block, BlockStatesDatagen.getUncheckedModel(registry));
        }
    }

    public static ModelFile getUncheckedModel(String registry) {
        return new ModelFile.UncheckedModelFile("ars_nouveau:block/" + registry);
    }

    public void buildNormalCube(String registryName) {
        ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(registryName)).parent((ModelFile)new ModelFile.UncheckedModelFile("block/cube_all"))).texture("all", this.getBlockLoc(registryName));
    }

    public ResourceLocation getBlockLoc(String registryName) {
        return new ResourceLocation("ars_nouveau", "blocks/" + registryName);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$signBlock$0(ModelFile signModel, BlockState s) {
        return ConfiguredModel.builder().modelFile(signModel).build();
    }
}

