/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketWarpPosition;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;

public class PortalTile
extends ModdedTile
implements ITickable,
ITooltipProvider {
    public BlockPos warpPos;
    public String dimID;
    public Vec2 rotationVec;
    public String displayName;
    public boolean isHorizontal;
    public Set<Entity> entityQueue = new HashSet<Entity>();

    public PortalTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.PORTAL_TILE_TYPE, pos, state);
    }

    public void warp(Entity e) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.warpPos != null && !(this.f_58857_.m_8055_(this.warpPos).m_60734_() instanceof PortalBlock)) {
                e.m_7678_((double)this.warpPos.m_123341_() + 0.5, (double)this.warpPos.m_123342_(), (double)this.warpPos.m_123343_() + 0.5, this.rotationVec != null ? this.rotationVec.f_82471_ : e.m_146908_(), this.rotationVec != null ? this.rotationVec.f_82470_ : e.m_146909_());
                e.m_146926_(this.rotationVec != null ? this.rotationVec.f_82470_ : e.m_146909_());
                e.m_146922_(this.rotationVec != null ? this.rotationVec.f_82471_ : e.m_146908_());
                Networking.sendToNearby(this.f_58857_, e, (Object)new PacketWarpPosition(e.m_19879_(), e.m_20185_() + 0.5, e.m_20186_(), e.m_20189_() + 0.5, e.m_146909_(), e.m_146908_()));
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)this.warpPos.m_123341_(), (double)(this.warpPos.m_123342_() + 1), (double)this.warpPos.m_123343_(), 4, (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0, -this.f_58857_.f_46441_.m_188500_(), (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0, (double)0.1f);
            }
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.dimID = compound.m_128461_("dim");
        this.warpPos = NBTUtil.getBlockPos(compound, "warp");
        this.rotationVec = new Vec2(compound.m_128457_("xRot"), compound.m_128457_("yRot"));
        this.displayName = compound.m_128461_("display");
        this.isHorizontal = compound.m_128471_("horizontal");
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        if (this.warpPos != null) {
            NBTUtil.storeBlockPos(compound, "warp", this.warpPos);
        }
        compound.m_128359_("dim", this.dimID);
        if (this.rotationVec != null) {
            compound.m_128350_("xRot", this.rotationVec.f_82470_);
            compound.m_128350_("yRot", this.rotationVec.f_82471_);
        }
        if (this.displayName != null) {
            compound.m_128359_("display", this.displayName);
        }
        compound.m_128379_("horizontal", this.isHorizontal);
    }

    @Override
    public void tick() {
        Set<Entity> entities;
        if (!(this.f_58857_ == null || this.f_58857_.f_46443_ || this.warpPos == null || this.f_58857_.m_8055_(this.warpPos).m_60734_() instanceof PortalBlock || (entities = this.entityQueue).isEmpty())) {
            for (Entity e : entities) {
                if (e instanceof EntityFollowProjectile || BlockUtil.distanceFrom(e.m_20183_(), this.f_58858_) > 2.0) continue;
                this.f_58857_.m_5594_(null, this.warpPos, SoundEvents.f_12052_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                e.m_6021_((double)this.warpPos.m_123341_() + 0.5, (double)this.warpPos.m_123342_(), (double)this.warpPos.m_123343_() + 0.5);
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)this.warpPos.m_123341_(), (double)(this.warpPos.m_123342_() + 1), (double)this.warpPos.m_123343_(), 4, (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0, -this.f_58857_.f_46441_.m_188500_(), (this.f_58857_.f_46441_.m_188500_() - 0.5) * 2.0, (double)0.1f);
                if (this.rotationVec == null) continue;
                e.m_146926_(this.rotationVec.f_82470_);
                e.m_146922_(this.rotationVec.f_82471_);
                Networking.sendToNearby(e.f_19853_, e, (Object)new PacketWarpPosition(e.m_19879_(), (double)this.warpPos.m_123341_() + 0.5, this.warpPos.m_123342_(), (double)this.warpPos.m_123343_() + 0.5, e.m_146909_(), e.m_146908_()));
            }
            this.entityQueue.clear();
        }
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.displayName != null) {
            tooltip.add((Component)Component.m_237113_((String)this.displayName));
        }
    }
}

