/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup;

import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.client.particle.ModParticles;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.world.Deferred;
import com.hollingsworth.arsnouveau.common.world.biome.ModBiomes;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTrunkPlacer;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.LootRegistry;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import com.hollingsworth.arsnouveau.setup.SoundRegistry;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import software.bernie.geckolib3.GeckoLib;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;

public class ModSetup {
    public static final DeferredRegister<TrunkPlacerType<?>> TRUNK_PLACER_TYPE_DEFERRED_REGISTER = DeferredRegister.createOptional((ResourceKey)Registry.f_122849_, (String)"ars_nouveau");
    public static RegistryObject<TrunkPlacerType<MagicTrunkPlacer>> MAGIC_TRUNK_PLACER = TRUNK_PLACER_TYPE_DEFERRED_REGISTER.register("magic_trunk_placer", () -> new TrunkPlacerType(MagicTrunkPlacer.CODEC));

    public static void sendIntercoms() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.RING.getMessageBuilder().size(2).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("an_focus").size(1).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.NECKLACE.getMessageBuilder().build());
    }

    public static void initGeckolib() {
        GeckoLib.initialize();
    }

    public static void registers(IEventBus modEventBus) {
        ItemsRegistry.ITEMS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModPotions.EFFECTS.register(modEventBus);
        ModPotions.POTIONS.register(modEventBus);
        EnchantmentRegistry.ENCHANTMENTS.register(modEventBus);
        RecipeRegistry.RECIPE_SERIALIZERS.register(modEventBus);
        RecipeRegistry.RECIPE_TYPES.register(modEventBus);
        ModParticles.PARTICLES.register(modEventBus);
        PerkAttributes.ATTRIBUTES.register(modEventBus);
        TRUNK_PLACER_TYPE_DEFERRED_REGISTER.register(modEventBus);
        Deferred.FEAT_REG.register(modEventBus);
        Deferred.CONFG_REG.register(modEventBus);
        Deferred.PLACED_FEAT_REG.register(modEventBus);
        LootRegistry.GLM.register(modEventBus);
        SoundRegistry.SOUND_REG.register(modEventBus);
    }

    public static void registerEvents(RegisterEvent event) {
        IForgeRegistry registry;
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCKS)) {
            registry = Objects.requireNonNull(event.getForgeRegistry());
            BlockRegistry.onBlocksRegistry((IForgeRegistry<Block>)registry);
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
            registry = Objects.requireNonNull(event.getForgeRegistry());
            BlockRegistry.onBlockItemsRegistry((IForgeRegistry<Item>)registry);
            ItemsRegistry.onItemRegistry((IForgeRegistry<Item>)registry);
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCK_ENTITY_TYPES)) {
            registry = Objects.requireNonNull(event.getForgeRegistry());
            BlockRegistry.onTileEntityRegistry(registry);
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.SOUND_EVENTS)) {
            registry = Objects.requireNonNull(event.getForgeRegistry());
            SoundRegistry.onSoundRegistry((IForgeRegistry<SoundEvent>)registry);
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BIOMES)) {
            registry = Objects.requireNonNull(event.getForgeRegistry());
            ModBiomes.registerBiomes((IForgeRegistry<Biome>)registry);
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCK_STATE_PROVIDER_TYPES)) {
            registry = Objects.requireNonNull(event.getForgeRegistry());
            BlockRegistry.registerBlockProvider(registry);
        }
    }
}

