/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.util;

import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class SpellPartConfigUtil {
    private static final Pattern AUGMENT_LIMITS_PATTERN = Pattern.compile("([^/=]+)=(\\d+)");

    public static AugmentLimits buildAugmentLimitsConfig(ForgeConfigSpec.Builder builder, Map<ResourceLocation, Integer> defaults) {
        ForgeConfigSpec.ConfigValue configValue = builder.comment(new String[]{"Limits the number of times a given augment may be applied to a given effect", "Example entry: \"" + GlyphLib.AugmentAmplifyID + "=5\""}).defineList("augment_limits", SpellPartConfigUtil.writeConfig(defaults), SpellPartConfigUtil::validateAugmentLimits);
        return new AugmentLimits((ForgeConfigSpec.ConfigValue<List<? extends String>>)configValue);
    }

    private static List<String> writeConfig(Map<ResourceLocation, Integer> augmentLimits) {
        return augmentLimits.entrySet().stream().map(e -> ((ResourceLocation)e.getKey()).toString() + "=" + ((Integer)e.getValue()).toString()).collect(Collectors.toList());
    }

    private static boolean validateAugmentLimits(Object rawConfig) {
        if (rawConfig instanceof CharSequence) {
            return AUGMENT_LIMITS_PATTERN.matcher((CharSequence)rawConfig).matches();
        }
        return false;
    }

    public static class AugmentLimits {
        private Map<ResourceLocation, Integer> limits = null;
        private ForgeConfigSpec.ConfigValue<List<? extends String>> configValue;

        private AugmentLimits(ForgeConfigSpec.ConfigValue<List<? extends String>> configValue) {
            this.configValue = configValue;
        }

        public int getAugmentLimit(ResourceLocation augmentTag) {
            this.limits = this.parseAugmentLimits();
            return this.limits.getOrDefault(augmentTag, Integer.MAX_VALUE);
        }

        private Map<ResourceLocation, Integer> parseAugmentLimits() {
            return ((List)this.configValue.get()).stream().map(AUGMENT_LIMITS_PATTERN::matcher).filter(Matcher::matches).collect(Collectors.toMap(m -> new ResourceLocation(m.group(1)), m -> Integer.valueOf(m.group(2))));
        }
    }
}

