/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.potion.PotionData;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.PotionFlask;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectInfuse
extends AbstractEffect {
    public static EffectInfuse INSTANCE = new EffectInfuse(GlyphLib.EffectInfuseID, "Infuse");

    public EffectInfuse(String tag, String description) {
        super(tag, description);
    }

    public EffectInfuse(ResourceLocation tag, String description) {
        super(tag, description);
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            InventoryManager manager = spellContext.getCaster().getInvManager();
            ExtractedStack extractedFlask = manager.extractItem(i -> {
                PotionFlask.FlaskData data = new PotionFlask.FlaskData((ItemStack)i);
                return !data.getPotion().isEmpty() && data.getCount() > 0;
            }, 1);
            if (!extractedFlask.isEmpty()) {
                PotionFlask.FlaskData data = new PotionFlask.FlaskData(extractedFlask.getStack());
                data.getPotion().applyEffects((Entity)shooter, (Entity)shooter, livingEntity);
                data.setCount(data.getCount() - 1);
                extractedFlask.returnOrDrop(world, shooter.m_20097_());
            } else {
                ExtractedStack potion = manager.extractItem(i -> i.m_41720_() instanceof PotionItem, 1);
                if (!potion.isEmpty()) {
                    ItemStack stack = potion.getStack();
                    PotionData potionData = new PotionData(stack);
                    potionData.applyEffects((Entity)shooter, (Entity)shooter, livingEntity);
                    stack.m_41774_(1);
                    potion.replaceAndReturnOrDrop(new ItemStack((ItemLike)Items.f_42590_), world, shooter.m_20097_());
                }
            }
        }
    }

    @Override
    public int getDefaultManaCost() {
        return 30;
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(new AbstractAugment[0]);
    }

    @Override
    public SpellTier getTier() {
        return SpellTier.TWO;
    }

    @Override
    public String getBookDescription() {
        return "Infuses a target with a potion from your flask or held potions. Consumes the potion.";
    }
}

