/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.entity.EntityChimera;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;

public class RitualWildenSummoning
extends AbstractRitual {
    @Override
    protected void tick() {
        EntityChimera.spawnPhaseParticles(this.getPos().m_7494_(), this.getWorld(), 1);
        if (this.getWorld().m_46467_() % 20L == 0L) {
            this.incrementProgress();
        }
        if (this.getWorld().m_46467_() % 60L == 0L && !this.getWorld().f_46443_) {
            if (!this.isBossSpawn()) {
                int wild = this.rand.m_188503_(3);
                BlockPos summonPos = this.getPos().m_7494_().m_122030_(this.rand.m_188503_(3) - this.rand.m_188503_(6)).m_122013_(this.rand.m_188503_(3) - this.rand.m_188503_(6));
                Monster mobEntity = switch (wild) {
                    case 0 -> new WildenStalker(this.getWorld());
                    case 1 -> new WildenGuardian(this.getWorld());
                    default -> new WildenHunter(this.getWorld());
                };
                this.summon((Mob)mobEntity, summonPos);
                if (this.getProgress() >= 15) {
                    this.setFinished();
                }
            } else if (this.getProgress() >= 8) {
                BlockPos.m_121990_((BlockPos)this.getPos().m_122030_(5).m_122013_(5).m_7494_(), (BlockPos)this.getPos().m_122025_(5).m_122020_(5).m_6630_(5)).forEach(p -> BlockUtil.destroyBlockSafelyWithoutSound(this.getWorld(), p, true));
                EntityChimera chimera = new EntityChimera(this.getWorld());
                this.summon((Mob)chimera, this.getPos().m_7494_());
                this.setFinished();
            }
        }
    }

    public boolean isBossSpawn() {
        return this.didConsumeItem(ItemsRegistry.WILDEN_HORN) && this.didConsumeItem(ItemsRegistry.WILDEN_WING) && this.didConsumeItem(ItemsRegistry.WILDEN_SPIKE);
    }

    public void summon(Mob mob, BlockPos pos) {
        mob.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        mob.f_19853_.m_7967_((Entity)mob);
    }

    @Override
    public String getLangName() {
        return "Summon Wilden";
    }

    @Override
    public String getLangDescription() {
        return "Without augments, this ritual will summon a random variety of Wilden monsters for a short duration. When augmented with a Wilden Spike, Wilden Horn, and a Wilden Wing, this ritual will summon the Wilden Chimera, a challenging and destructive monster. Note: If summoning the chimera, this ritual will destroy blocks around the brazier.";
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return stack.m_204117_(ItemTagProvider.WILDEN_DROP_TAG);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("ars_nouveau", RitualLib.WILDEN_SUMMON);
    }
}

