/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateBookGUI;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PacketUpdateCaster {
    Spell spellRecipe;
    int cast_slot;
    String spellName;

    public PacketUpdateCaster() {
    }

    public PacketUpdateCaster(Spell spellRecipe, int cast_slot, String spellName) {
        this.spellRecipe = spellRecipe;
        this.cast_slot = cast_slot;
        this.spellName = spellName;
    }

    public PacketUpdateCaster(FriendlyByteBuf buf) {
        this.spellRecipe = Spell.fromTag(buf.m_130260_());
        this.cast_slot = buf.readInt();
        this.spellName = buf.m_130136_(Short.MAX_VALUE);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.spellRecipe.serialize());
        buf.writeInt(this.cast_slot);
        buf.m_130070_(this.spellName);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getSender() != null) {
                InteractionHand hand = StackUtil.getHeldCasterTool((Player)((NetworkEvent.Context)ctx.get()).getSender());
                if (hand == null) {
                    return;
                }
                ItemStack stack = ((NetworkEvent.Context)ctx.get()).getSender().m_21120_(hand);
                if (this.spellRecipe != null) {
                    ISpellCaster caster = CasterUtil.getCaster(stack);
                    caster.setCurrentSlot(this.cast_slot);
                    Spell spell = caster.getSpell(this.cast_slot).setRecipe(this.spellRecipe.recipe);
                    caster.setSpell(spell, this.cast_slot);
                    caster.setSpellName(this.spellName, this.cast_slot);
                    Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> PacketUpdateCaster.lambda$handle$0((Supplier)ctx)), (Object)new PacketUpdateBookGUI(stack));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ ServerPlayer lambda$handle$0(Supplier ctx) {
        return ((NetworkEvent.Context)ctx.get()).getSender();
    }
}

