/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ForageManaBerries
extends Goal {
    private final Starbuncle entity;
    private final Level world;
    int timeSpent;
    BlockPos pos;
    StarbyTransportBehavior behavior;

    public ForageManaBerries(Starbuncle starbuncle, StarbyTransportBehavior transportBehavior) {
        this.entity = starbuncle;
        this.world = this.entity.f_19853_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.behavior = transportBehavior;
    }

    public void m_8056_() {
        super.m_8056_();
        this.timeSpent = 0;
        this.entity.goalState = Starbuncle.StarbuncleGoalState.FORAGING;
    }

    public void m_8041_() {
        super.m_8041_();
        this.timeSpent = 0;
        this.entity.goalState = Starbuncle.StarbuncleGoalState.NONE;
    }

    public boolean m_8036_() {
        if (this.behavior.isPickupDisabled() || !this.entity.getHeldStack().m_41619_() || this.world.f_46441_.m_188500_() > 0.05 || this.behavior.getValidStorePos(new ItemStack((ItemLike)BlockRegistry.SOURCEBERRY_BUSH)) == null) {
            return false;
        }
        this.pos = this.getNearbyManaBerry();
        if (this.pos == null) {
            this.entity.addGoalDebug(this, new DebugEvent("NoBerries", "No Berries Nearby"));
        }
        return this.pos != null;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        super.m_8037_();
        ++this.timeSpent;
        if (this.pos == null) {
            return;
        }
        if (BlockUtil.distanceFrom(this.entity.f_19825_, this.pos) >= 2.0) {
            this.entity.getNavigation().tryMoveToBlockPos(this.pos, 1.2);
            this.entity.addGoalDebug(this, new DebugEvent("PathTo", "Moving to berry " + this.pos.toString()));
        } else if (this.world.m_8055_(this.pos).m_60734_() instanceof SourceBerryBush) {
            int i = (Integer)this.world.m_8055_(this.pos).m_61143_((Property)SourceBerryBush.AGE);
            boolean flag = i == 3;
            this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_()));
            int j = 1 + this.world.f_46441_.m_188503_(2);
            SourceBerryBush.m_49840_((Level)this.world, (BlockPos)this.pos, (ItemStack)new ItemStack((ItemLike)BlockRegistry.SOURCEBERRY_BUSH, j + (flag ? 1 : 0)));
            this.world.m_5594_(null, this.pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + this.world.f_46441_.m_188501_() * 0.4f);
            this.world.m_7731_(this.pos, (BlockState)this.world.m_8055_(this.pos).m_61124_((Property)SourceBerryBush.AGE, (Comparable)Integer.valueOf(1)), 2);
            this.entity.addGoalDebug(this, new DebugEvent("PickedBerry", "Popped berries at " + this.pos.m_123341_() + "," + this.pos.m_123342_() + "," + this.pos.m_123343_()));
            this.pos = null;
        }
    }

    public boolean m_8045_() {
        if (this.pos == null || this.behavior.isPickupDisabled()) {
            return false;
        }
        return this.timeSpent <= 300 && this.world.m_8055_(this.pos).m_60734_() instanceof SourceBerryBush && (Integer)this.world.m_8055_(this.pos).m_61143_((Property)SourceBerryBush.AGE) > 1;
    }

    public BlockPos getNearbyManaBerry() {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (BlockPos blockpos : BlockPos.m_121925_((BlockPos)this.entity.m_20183_(), (int)10, (int)3, (int)10)) {
            if (!(this.world.m_8055_(blockpos).m_60734_() instanceof SourceBerryBush) || (Integer)this.world.m_8055_(blockpos).m_61143_((Property)SourceBerryBush.AGE) <= 1) continue;
            posList.add(blockpos.m_7949_());
        }
        return posList.isEmpty() ? null : (BlockPos)posList.get(this.world.f_46441_.m_188503_(posList.size()));
    }
}

