/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.familiar;

import com.hollingsworth.arsnouveau.api.client.IVariantTextureProvider;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.Whirlisprig;
import com.hollingsworth.arsnouveau.common.entity.familiar.FlyingFamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class FamiliarWhirlisprig
extends FlyingFamiliarEntity
implements ISpellCastListener,
IVariantTextureProvider {
    public FamiliarWhirlisprig(EntityType<? extends PathfinderMob> ent, Level world) {
        super(ent, world);
    }

    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND || pPlayer.m_20193_().f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = pPlayer.m_21120_(hand);
        String color = Whirlisprig.getColorFromStack(stack);
        if (color != null && !this.getColor().equals(color)) {
            this.setColor(color);
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(pPlayer, pVec, hand);
    }

    @Override
    public void onCast(SpellCastEvent event) {
        if (!this.m_6084_()) {
            return;
        }
        if (this.getOwner() != null && this.getOwner().equals((Object)event.getEntity())) {
            int discount = 0;
            for (AbstractSpellPart part : event.spell.recipe) {
                if (!SpellSchools.ELEMENTAL_EARTH.isPartOfSchool(part)) continue;
                discount = (int)((double)discount + (double)part.getCastingCost() * 0.5);
            }
            event.spell.addDiscount(discount);
        }
    }

    public void eatEvent(LivingEntityUseItemEvent.Finish event) {
        if (!this.m_6084_()) {
            return;
        }
        if (!event.getEntity().f_19853_.f_46443_ && this.getOwner() != null && this.getOwner().equals((Object)event.getEntity()) && event.getItem().m_41720_().m_41473_() != null && event.getItem().m_41720_().m_41472_()) {
            FoodProperties food = event.getItem().m_41720_().m_41473_();
            float saturationModifier = food.m_38745_();
            int nutrition = food.m_38744_();
            float satAmount = (float)nutrition * saturationModifier * 2.0f;
            if (event.getEntity() instanceof Player) {
                FoodData stats = ((Player)event.getEntity()).m_36324_();
                stats.f_38697_ += satAmount * 0.4f;
            }
        }
    }

    @Override
    public PlayState walkPredicate(AnimationEvent event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("fly"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        }
        return PlayState.CONTINUE;
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.ENTITY_FAMILIAR_SYLPH.get();
    }

    @Override
    public ResourceLocation getTexture(LivingEntity entity) {
        return new ResourceLocation("ars_nouveau", "textures/entity/sylph_" + (this.getColor().isEmpty() ? "summer" : this.getColor()) + ".png");
    }
}

