/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.client.IVariantColorProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.WhirlisprigTile;
import com.hollingsworth.arsnouveau.common.entity.AbstractFlyingCreature;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig.BonemealGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig.FollowMobGoalBackoff;
import com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig.FollowPlayerGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig.InspectPlantGoal;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Whirlisprig
extends AbstractFlyingCreature
implements IAnimatable,
ITooltipProvider,
IDispellable,
IVariantColorProvider {
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    public int timeSinceBonemeal = 0;
    public static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(Whirlisprig.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int tamingTime = 0;
    public boolean droppingShards;
    public static final EntityDataAccessor<Integer> MOOD_SCORE = SynchedEntityData.m_135353_(Whirlisprig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.m_135353_(Whirlisprig.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public List<ItemStack> ignoreItems;
    public int diversityScore;
    public BlockPos flowerPos;
    public int timeSinceGen;
    private boolean setBehaviors;

    private <E extends Entity> PlayState idlePredicate(AnimationEvent event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("fly"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "idleController", 20.0f, this::idlePredicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    public int m_213860_() {
        return 0;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_20193_().f_46443_) {
            return super.m_6071_(player, hand);
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == ItemsRegistry.DENY_ITEM_SCROLL.m_5456_()) {
            ItemScroll.ItemScrollData scrollData = new ItemScroll.ItemScrollData(stack);
            this.ignoreItems = new ArrayList<ItemStack>(scrollData.getItems());
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.whirlisprig.ignore"));
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public String getColor() {
        return (String)this.f_19804_.m_135370_(COLOR);
    }

    @Override
    public void setColor(String color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public static String getColorFromStack(ItemStack stack) {
        if (stack.m_204117_(Tags.Items.DYES)) {
            if (stack.m_204117_(Tags.Items.DYES_GREEN)) {
                return "summer";
            }
            if (stack.m_204117_(Tags.Items.DYES_ORANGE)) {
                return "autumn";
            }
            if (stack.m_204117_(Tags.Items.DYES_YELLOW)) {
                return "spring";
            }
            if (stack.m_204117_(Tags.Items.DYES_WHITE)) {
                return "winter";
            }
        }
        return null;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND || player.m_20193_().f_46443_ || !((Boolean)this.f_19804_.m_135370_(TAMED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        String color = Whirlisprig.getColorFromStack(stack);
        if (color != null && !this.getColor().equals(color)) {
            this.f_19804_.m_135381_(COLOR, (Object)color);
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41619_()) {
            int moodScore = (Integer)this.f_19804_.m_135370_(MOOD_SCORE);
            if (moodScore < 250) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.unhappy"));
            } else if (moodScore <= 500) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.content"));
            } else if (moodScore <= 750) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.happy"));
            } else if (moodScore < 1000) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.very_happy"));
            } else {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.extremely_happy"));
            }
            int numDrops = this.diversityScore / 2;
            if (numDrops <= 5) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.okay_diversity"));
            } else if (numDrops <= 10) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.diverse_enough"));
            } else if (numDrops <= 20) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.very_diverse"));
            } else {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.extremely_diverse"));
            }
            if (this.ignoreItems != null && !this.ignoreItems.isEmpty()) {
                StringBuilder status = new StringBuilder();
                status.append(Component.m_237115_((String)"ars_nouveau.whirlisprig.ignore_list").getString());
                for (ItemStack i : this.ignoreItems) {
                    status.append(i.m_41786_().getString()).append(" ");
                }
                PortUtil.sendMessage((Entity)player, status.toString());
            }
            return InteractionResult.SUCCESS;
        }
        if (!(stack.m_41720_() instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
        int score = WhirlisprigTile.getScore(state);
        if (score > 0 && this.getTile() != null && this.getTile().scoreMap != null && this.getTile().scoreMap.get(state) != null && this.getTile().scoreMap.get(state) >= 50) {
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.toomuch"));
            return InteractionResult.SUCCESS;
        }
        if (score == 0) {
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.notinterested"));
        }
        if (score == 1) {
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.likes"));
        }
        if (score == 2) {
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"whirlisprig.excited"));
        }
        return InteractionResult.SUCCESS;
    }

    public Whirlisprig(EntityType<? extends AbstractFlyingCreature> type, Level worldIn) {
        super(type, worldIn);
        if (!this.f_19853_.f_46443_) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.addGoalsAfterConstructor();
    }

    public Whirlisprig(Level world, boolean isTamed, BlockPos pos) {
        super((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.WHIRLISPRIG_TYPE.get()), world);
        if (!this.f_19853_.f_46443_) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.f_19804_.m_135381_(TAMED, (Object)isTamed);
        this.flowerPos = pos;
        this.addGoalsAfterConstructor();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.f_19853_.m_46467_() % 20L == 0L && this.m_20183_().m_123342_() < this.f_19853_.m_141937_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            ++this.timeSinceBonemeal;
            ++this.timeSinceGen;
            if (this.f_19853_.m_46467_() % 20L == 0L && this.flowerPos != null && this.isTamed() && this.getTile() != null) {
                this.f_19804_.m_135381_(MOOD_SCORE, (Object)this.getTile().moodScore);
                this.diversityScore = this.getTile().diversityScore;
            }
        }
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46467_() % 60L == 0L && this.isTamed() && this.flowerPos != null && !(this.f_19853_.m_7702_(this.flowerPos) instanceof WhirlisprigTile)) {
            this.m_6469_(DamageSource.m_19344_((Player)ANFakePlayer.getPlayer((ServerLevel)this.f_19853_)), 99.0f);
            return;
        }
        if (this.droppingShards) {
            ++this.tamingTime;
            if (this.tamingTime % 20 == 0 && !this.f_19853_.m_5776_()) {
                Networking.sendToNearby(this.f_19853_, (Entity)this, (Object)new PacketANEffect(PacketANEffect.EffectType.TIMED_HELIX, this.m_20183_(), new int[0]));
            }
            if (this.tamingTime > 60 && !this.f_19853_.f_46443_) {
                ItemStack stack = new ItemStack(ItemsRegistry.WHIRLISPRIG_SHARDS, 1 + this.f_19853_.f_46441_.m_188503_(1));
                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), stack));
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12052_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else if (this.tamingTime > 55 && this.f_19853_.f_46443_) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = this.m_20185_();
                    double d1 = this.m_20186_() + 0.1;
                    double d2 = this.m_20189_();
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, d0, d1, d2, ((double)(this.f_19853_.f_46441_.m_188501_() * 1.0f) - 0.5) / 3.0, ((double)(this.f_19853_.f_46441_.m_188501_() * 1.0f) - 0.5) / 3.0, ((double)(this.f_19853_.f_46441_.m_188501_() * 1.0f) - 0.5) / 3.0);
                }
            }
        }
    }

    protected void addGoalsAfterConstructor() {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        for (WrappedGoal goal : this.getGoals()) {
            this.f_21345_.m_25352_(goal.m_26012_(), goal.m_26015_());
        }
    }

    public List<WrappedGoal> getGoals() {
        return (Boolean)this.f_19804_.m_135370_(TAMED) != false ? this.getTamedGoals() : this.getUntamedGoals();
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19314_ || source == DamageSource.f_19325_ || source == DamageSource.f_19312_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_ && this.isTamed()) {
            ItemStack stack = new ItemStack(ItemsRegistry.WHIRLISPRIG_CHARM);
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
        }
        super.m_6667_(source);
    }

    public List<WrappedGoal> getTamedGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(3, (Goal)new RandomLookAroundGoal((Mob)this)));
        list.add(new WrappedGoal(2, (Goal)new BonemealGoal(this, () -> this.flowerPos, 10)));
        list.add(new WrappedGoal(2, (Goal)new InspectPlantGoal(this, () -> this.flowerPos, 15)));
        list.add(new WrappedGoal(1, (Goal)new GoBackHomeGoal((Mob)this, () -> this.flowerPos, 20)));
        list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        return list;
    }

    public List<WrappedGoal> getUntamedGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(3, (Goal)new FollowMobGoalBackoff((Mob)this, 1.0, 3.0f, 7.0f, 0.5f)));
        list.add(new WrappedGoal(5, (Goal)new FollowPlayerGoal((Mob)this, 1.0, 3.0f, 7.0f)));
        list.add(new WrappedGoal(2, (Goal)new RandomLookAroundGoal((Mob)this)));
        list.add(new WrappedGoal(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0)));
        list.add(new WrappedGoal(1, (Goal)new BonemealGoal(this)));
        list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        return list;
    }

    public WhirlisprigTile getTile() {
        if (this.flowerPos == null || !(this.f_19853_.m_7702_(this.flowerPos) instanceof WhirlisprigTile)) {
            return null;
        }
        return (WhirlisprigTile)this.f_19853_.m_7702_(this.flowerPos);
    }

    @SubscribeEvent
    public void treeGrow(SaplingGrowTreeEvent event) {
        if (!((Boolean)this.f_19804_.m_135370_(TAMED)).booleanValue() && BlockUtil.distanceFrom(this.m_20183_(), event.getPos()) <= 10.0) {
            this.droppingShards = true;
        }
    }

    protected void m_8099_() {
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (!((Boolean)this.f_19804_.m_135370_(TAMED)).booleanValue()) {
            return;
        }
        int mood = (Integer)this.f_19804_.m_135370_(MOOD_SCORE);
        String moodStr = Component.m_237115_((String)"ars_nouveau.whirlisprig.tooltip_unhappy").getString();
        if (mood >= 1000) {
            moodStr = Component.m_237115_((String)"ars_nouveau.whirlisprig.tooltip_extremely_happy").getString();
        } else if (mood >= 750) {
            moodStr = Component.m_237115_((String)"ars_nouveau.whirlisprig.tooltip_very_happy").getString();
        } else if (mood >= 500) {
            moodStr = Component.m_237115_((String)"ars_nouveau.whirlisprig.tooltip_happy").getString();
        } else if (mood >= 250) {
            moodStr = Component.m_237115_((String)"ars_nouveau.whirlisprig.tooltip_content").getString();
        }
        tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"ars_nouveau.whirlisprig.tooltip_mood").getString() + moodStr)));
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22280_, Attributes.f_22280_.m_22082_()).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    @NotNull
    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, world);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("summoner_x")) {
            this.flowerPos = new BlockPos(tag.m_128451_("summoner_x"), tag.m_128451_("summoner_y"), tag.m_128451_("summoner_z"));
        }
        this.timeSinceBonemeal = tag.m_128451_("bonemeal");
        this.f_19804_.m_135381_(TAMED, (Object)tag.m_128471_("tamed"));
        this.f_19804_.m_135381_(MOOD_SCORE, (Object)tag.m_128451_("score"));
        if (!this.setBehaviors) {
            this.tryResetGoals();
            this.setBehaviors = true;
        }
        this.ignoreItems = NBTUtil.readItems(tag, "ignored_");
        this.f_19804_.m_135381_(COLOR, (Object)tag.m_128461_("color"));
        this.timeSinceGen = tag.m_128451_("genTime");
    }

    public void tryResetGoals() {
        this.f_21345_.f_25345_ = new LinkedHashSet();
        this.addGoalsAfterConstructor();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.flowerPos != null) {
            tag.m_128405_("summoner_x", this.flowerPos.m_123341_());
            tag.m_128405_("summoner_y", this.flowerPos.m_123342_());
            tag.m_128405_("summoner_z", this.flowerPos.m_123343_());
        }
        tag.m_128405_("bonemeal", this.timeSinceBonemeal);
        tag.m_128379_("tamed", ((Boolean)this.f_19804_.m_135370_(TAMED)).booleanValue());
        tag.m_128405_("score", ((Integer)this.f_19804_.m_135370_(MOOD_SCORE)).intValue());
        tag.m_128359_("color", (String)this.f_19804_.m_135370_(COLOR));
        tag.m_128405_("genTime", this.timeSinceGen);
        if (this.ignoreItems != null && !this.ignoreItems.isEmpty()) {
            NBTUtil.writeItems(tag, "ignored_", this.ignoreItems);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOOD_SCORE, (Object)0);
        this.f_19804_.m_135372_(TAMED, (Object)false);
        this.f_19804_.m_135372_(COLOR, (Object)"summer");
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.m_213877_()) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.isTamed()) {
            ItemStack stack = new ItemStack(ItemsRegistry.WHIRLISPRIG_CHARM);
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
            ParticleUtil.spawnPoof((ServerLevel)this.f_19853_, this.m_20183_());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return this.isTamed();
    }

    @Override
    public ResourceLocation getTexture(LivingEntity entity) {
        return new ResourceLocation("ars_nouveau", "textures/entity/sylph_" + (this.getColor().isEmpty() ? "summer" : this.getColor()) + ".png");
    }
}

