/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.IVariantColorProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.AbstractFlyingCreature;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.wixie.CompleteCraftingGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wixie.FindNextItemGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wixie.FindPotionGoal;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityWixie
extends AbstractFlyingCreature
implements IAnimatable,
IAnimationListener,
IDispellable,
IVariantColorProvider {
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    public static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(EntityWixie.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.m_135353_(EntityWixie.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public BlockPos cauldronPos;
    public int inventoryBackoff;
    AnimationController<?> summonController;
    AnimationController<?> castController;
    public static String[] COLORS = new String[]{"white", "green", "blue", "black", "red"};

    private <P extends IAnimatable> PlayState idlePredicate(AnimationEvent<P> event) {
        if (this.m_21573_().m_26572_()) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState castPredicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState summonPredicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    public int m_213860_() {
        return 0;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "idleController", 20.0f, this::idlePredicate));
        this.castController = new AnimationController((IAnimatable)this, "castController", 1.0f, this::castPredicate);
        this.summonController = new AnimationController((IAnimatable)this, "summonController", 1.0f, this::summonPredicate);
        animationData.addAnimationController(this.castController);
        animationData.addAnimationController(this.summonController);
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    protected EntityWixie(EntityType<? extends AbstractFlyingCreature> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.addGoalsAfterConstructor();
    }

    public EntityWixie(Level world, boolean isTamed, BlockPos pos) {
        super((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.ENTITY_WIXIE_TYPE.get()), world);
        this.cauldronPos = pos;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.f_19804_.m_135381_(TAMED, (Object)isTamed);
        this.addGoalsAfterConstructor();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.f_19853_.f_46443_ || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_21205_().m_204117_(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.f_19804_.m_135370_(COLOR)).equals(color.m_41065_()) || !Arrays.asList(COLORS).contains(color.m_41065_())) {
                return InteractionResult.SUCCESS;
            }
            this.f_19804_.m_135381_(COLOR, (Object)color.m_41065_());
            player.m_21205_().m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!(this.f_19853_.f_46443_ || this.cauldronPos != null && this.f_19853_.m_7702_(this.cauldronPos) instanceof WixieCauldronTile)) {
            this.m_6469_(DamageSource.m_19344_((Player)ANFakePlayer.getPlayer((ServerLevel)this.f_19853_)), 99.0f);
        }
        if (!this.f_19853_.f_46443_ && this.inventoryBackoff > 0) {
            --this.inventoryBackoff;
        }
    }

    public List<WrappedGoal> getTamedGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(3, (Goal)new RandomLookAroundGoal((Mob)this)));
        list.add(new WrappedGoal(2, (Goal)new FindNextItemGoal(this)));
        list.add(new WrappedGoal(2, (Goal)new FindPotionGoal(this)));
        list.add(new WrappedGoal(1, (Goal)new CompleteCraftingGoal(this)));
        return list;
    }

    public List<WrappedGoal> getUntamedGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(3, (Goal)new RandomLookAroundGoal((Mob)this)));
        list.add(new WrappedGoal(2, (Goal)new FindNextItemGoal(this)));
        list.add(new WrappedGoal(2, (Goal)new FindPotionGoal(this)));
        list.add(new WrappedGoal(1, (Goal)new CompleteCraftingGoal(this)));
        return list;
    }

    protected void addGoalsAfterConstructor() {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        for (WrappedGoal goal : this.getGoals()) {
            this.f_21345_.m_25352_(goal.m_26012_(), goal.m_26015_());
        }
    }

    public List<WrappedGoal> getGoals() {
        return (Boolean)this.f_19804_.m_135370_(TAMED) != false ? this.getTamedGoals() : this.getUntamedGoals();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TAMED, (Object)false);
        this.f_19804_.m_135372_(COLOR, (Object)"blue");
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, world);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22280_, Attributes.f_22280_.m_22082_()).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("summoner_x")) {
            this.cauldronPos = new BlockPos(tag.m_128451_("summoner_x"), tag.m_128451_("summoner_y"), tag.m_128451_("summoner_z"));
        }
        this.f_19804_.m_135381_(TAMED, (Object)tag.m_128471_("tamed"));
        if (tag.m_128441_("color")) {
            this.f_19804_.m_135381_(COLOR, (Object)tag.m_128461_("color"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.cauldronPos != null) {
            tag.m_128405_("summoner_x", this.cauldronPos.m_123341_());
            tag.m_128405_("summoner_y", this.cauldronPos.m_123342_());
            tag.m_128405_("summoner_z", this.cauldronPos.m_123343_());
        }
        tag.m_128379_("tamed", ((Boolean)this.f_19804_.m_135370_(TAMED)).booleanValue());
        tag.m_128359_("color", (String)this.f_19804_.m_135370_(COLOR));
    }

    @Override
    public void startAnimation(int arg) {
        if (arg == Animations.CAST.ordinal() && this.castController != null) {
            this.castController.markNeedsReload();
            this.castController.setAnimation(new AnimationBuilder().addAnimation("cast", Boolean.valueOf(false)));
        } else if (arg == Animations.SUMMON_ITEM.ordinal() && this.summonController != null) {
            this.summonController.markNeedsReload();
            this.summonController.setAnimation(new AnimationBuilder().addAnimation("summon_item", Boolean.valueOf(false)));
        }
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_) {
            ItemStack stack = new ItemStack(ItemsRegistry.WIXIE_CHARM);
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
        }
        super.m_6667_(source);
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.m_213877_()) {
            return false;
        }
        if (!this.f_19853_.f_46443_) {
            ItemStack stack = new ItemStack(ItemsRegistry.WIXIE_CHARM);
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack.m_41777_()));
            ParticleUtil.spawnPoof((ServerLevel)this.f_19853_, this.m_20183_());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    @Override
    public ResourceLocation getTexture(LivingEntity entity) {
        String color = this.getColor().toLowerCase();
        if (color.isEmpty()) {
            color = "blue";
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/wixie_" + color + ".png");
    }

    @Override
    public String getColor() {
        return (String)this.m_20088_().m_135370_(COLOR);
    }

    @Override
    public void setColor(String color) {
        this.m_20088_().m_135381_(COLOR, (Object)color);
    }

    public static enum Animations {
        CAST,
        SUMMON_ITEM;

    }
}

