/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.client.IVariantColorProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.BookwyrmLecternTile;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityBookwyrm
extends FlyingMob
implements IDispellable,
ITooltipProvider,
IWandable,
IAnimatable,
IVariantColorProvider<EntityBookwyrm> {
    public static final EntityDataAccessor<String> SPELL_STRING = SynchedEntityData.m_135353_(EntityBookwyrm.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<ItemStack> HELD_ITEM = SynchedEntityData.m_135353_(EntityBookwyrm.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Boolean> STRICT_MODE = SynchedEntityData.m_135353_(EntityBookwyrm.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.m_135353_(EntityBookwyrm.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public BlockPos lecternPos;
    public int ticksSinceLastSpell;
    public Spell spellRecipe;
    private int backoffTicks;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public static String[] COLORS = new String[]{"purple", "green", "blue", "black", "red", "white"};

    protected EntityBookwyrm(EntityType<? extends FlyingMob> p_i48568_1_, Level p_i48568_2_) {
        super(p_i48568_1_, p_i48568_2_);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    public EntityBookwyrm setRecipe(Spell spell) {
        this.spellRecipe = spell;
        return this;
    }

    public EntityBookwyrm(Level p_i50190_2_) {
        super((EntityType)ModEntities.ENTITY_BOOKWYRM_TYPE.get(), p_i50190_2_);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.f_19804_.m_135381_(STRICT_MODE, (Object)((Boolean)this.f_19804_.m_135370_(STRICT_MODE) == false ? 1 : 0));
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237110_((String)"ars_nouveau.bookwyrm.strict_mode", (Object[])new Object[]{this.f_19804_.m_135370_(STRICT_MODE)}));
    }

    public EntityBookwyrm(Level world, BlockPos lecternPos) {
        this(world);
        this.lecternPos = lecternPos;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_ == null || this.f_20890_ || this.lecternPos == null) {
            return;
        }
        ++this.ticksSinceLastSpell;
        if (!this.f_19853_.f_46443_ && this.backoffTicks >= 0) {
            --this.backoffTicks;
        }
        if (this.f_19853_.m_46467_() % 20L == 0L && !(this.f_19853_.m_7702_(this.lecternPos) instanceof BookwyrmLecternTile) && !this.f_19853_.f_46443_) {
            this.m_6469_(DamageSource.m_19344_((Player)ANFakePlayer.getPlayer((ServerLevel)this.f_19853_)), 99.0f);
        }
    }

    public boolean m_6469_(@Nonnull DamageSource source, float p_70097_2_) {
        if (source == DamageSource.f_19312_ || source == DamageSource.f_19310_ || source == DamageSource.f_19325_ || source == DamageSource.f_19314_) {
            return false;
        }
        return super.m_6469_(source, p_70097_2_);
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, world);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.m_213877_()) {
            return false;
        }
        if (!this.f_19853_.f_46443_) {
            ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.BOOKWYRM_CHARM.get());
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
            ParticleUtil.spawnPoof((ServerLevel)this.f_19853_, this.m_20183_());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.ENTITY_BOOKWYRM_TYPE.get();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.lecternPos != null) {
            tag.m_128405_("summoner_x", this.lecternPos.m_123341_());
            tag.m_128405_("summoner_y", this.lecternPos.m_123342_());
            tag.m_128405_("summoner_z", this.lecternPos.m_123343_());
        }
        tag.m_128405_("last_spell", this.ticksSinceLastSpell);
        if (!this.getHeldStack().m_41619_()) {
            CompoundTag itemTag = new CompoundTag();
            this.getHeldStack().m_41739_(itemTag);
            tag.m_128365_("held", (Tag)itemTag);
        }
        tag.m_128405_("backoff", this.backoffTicks);
        tag.m_128379_("strict", ((Boolean)this.f_19804_.m_135370_(STRICT_MODE)).booleanValue());
        tag.m_128359_("color", (String)this.f_19804_.m_135370_(COLOR));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("summoner_x")) {
            this.lecternPos = new BlockPos(tag.m_128451_("summoner_x"), tag.m_128451_("summoner_y"), tag.m_128451_("summoner_z"));
        }
        this.ticksSinceLastSpell = tag.m_128451_("last_spell");
        if (tag.m_128441_("held")) {
            this.setHeldStack(ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_("held"))));
        }
        this.f_19804_.m_135381_(STRICT_MODE, (Object)tag.m_128471_("strict"));
        this.backoffTicks = tag.m_128451_("backoff");
        if (tag.m_128441_("color")) {
            this.f_19804_.m_135381_(COLOR, (Object)tag.m_128461_("color"));
        }
    }

    @Nullable
    public BookwyrmLecternTile getTile() {
        return this.lecternPos == null || !(this.f_19853_.m_7702_(this.lecternPos) instanceof BookwyrmLecternTile) ? null : (BookwyrmLecternTile)this.f_19853_.m_7702_(this.lecternPos);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "walkController", 1.0f, this::idle));
    }

    public PlayState idle(AnimationEvent event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int m_213860_() {
        return 0;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    @Nonnull
    public ItemStack getHeldStack() {
        return (ItemStack)this.f_19804_.m_135370_(HELD_ITEM);
    }

    public void setHeldStack(ItemStack stack) {
        this.f_19804_.m_135381_(HELD_ITEM, (Object)stack);
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_) {
            ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.BOOKWYRM_CHARM.get());
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
        }
        super.m_6667_(source);
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22280_, Attributes.f_22280_.m_22082_()).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HELD_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(SPELL_STRING, (Object)"");
        this.f_19804_.m_135372_(STRICT_MODE, (Object)true);
        this.f_19804_.m_135372_(COLOR, (Object)"blue");
    }

    @Override
    public ResourceLocation getTexture(EntityBookwyrm entity) {
        String color = this.getColor().toLowerCase();
        if (color.isEmpty()) {
            color = "blue";
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/book_wyrm_" + color + ".png");
    }

    @Override
    public String getColor() {
        return (String)this.m_20088_().m_135370_(COLOR);
    }

    @Override
    public void setColor(String color) {
        this.m_20088_().m_135381_(COLOR, (Object)color);
    }
}

