/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MageBlockTile
extends ModdedTile
implements ITickable,
IAnimatable {
    int age;
    public boolean isPermanent;
    public double lengthModifier;
    public ParticleColor color = ParticleColor.defaultParticleColor();
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public MageBlockTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.MAGE_BLOCK_TILE, pos, state);
    }

    @Override
    public void tick() {
        if (this.isPermanent) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            ++this.age;
            if ((double)this.age > 300.0 + 100.0 * this.lengthModifier) {
                this.f_58857_.m_46961_(this.m_58899_(), false);
                this.f_58857_.m_46747_(this.m_58899_());
            }
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.age = compound.m_128451_("age");
        this.color = ParticleColor.deserialize(compound.m_128469_("lightColor"));
        this.isPermanent = compound.m_128471_("permanent");
        this.lengthModifier = compound.m_128459_("modifier");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("age", (Tag)IntTag.m_128679_((int)this.age));
        tag.m_128365_("lightColor", (Tag)this.color.serialize());
        tag.m_128379_("permanent", this.isPermanent);
        tag.m_128347_("modifier", this.lengthModifier);
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

