/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.SingleItemTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EnchantingApparatusTile
extends SingleItemTile
implements Container,
ITickable,
IAnimatable,
IAnimationListener {
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    private int counter;
    public boolean isCrafting;
    public static final int craftingLength = 210;
    AnimationController craftController;
    AnimationController idleController;
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);

    public EnchantingApparatusTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.ENCHANTING_APP_TILE, pos, state);
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            if (this.isCrafting) {
                Level world = this.m_58904_();
                BlockPos pos = this.m_58899_().m_7637_(0.0, 0.5, 0.0);
                RandomSource rand = world.m_213780_();
                Vec3 particlePos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.5, 0.0, 0.5);
                particlePos = particlePos.m_82549_(ParticleUtil.pointInSphere());
                world.m_7106_(ParticleLineData.createData(new ParticleColor(rand.m_188503_(255), rand.m_188503_(255), rand.m_188503_(255))), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
                for (BlockPos p : this.pedestalList()) {
                    ArcanePedestalTile pedestalTile;
                    BlockEntity blockEntity = this.f_58857_.m_7702_(p);
                    if (!(blockEntity instanceof ArcanePedestalTile) || (pedestalTile = (ArcanePedestalTile)blockEntity).getStack() == null || pedestalTile.getStack().m_41619_()) continue;
                    this.m_58904_().m_7106_(GlowParticleData.createData(new ParticleColor(rand.m_188503_(255), rand.m_188503_(255), rand.m_188503_(255))), (double)p.m_123341_() + 0.5 + ParticleUtil.inRange(-0.2, 0.2), (double)p.m_123342_() + 1.5 + ParticleUtil.inRange(-0.3, 0.3), (double)p.m_123343_() + 0.5 + ParticleUtil.inRange(-0.2, 0.2), 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        if (this.isCrafting) {
            if (this.getRecipe(this.stack, null) == null) {
                this.isCrafting = false;
                this.m_6596_();
            }
            ++this.counter;
        }
        if (this.counter > 210) {
            this.counter = 0;
            if (this.isCrafting) {
                IEnchantingRecipe recipe = this.getRecipe(this.stack, null);
                List<ItemStack> pedestalItems = this.getPedestalItems();
                if (recipe != null) {
                    pedestalItems.forEach(i -> {
                        i = null;
                    });
                    this.stack = recipe.getResult(pedestalItems, this.stack, this);
                    this.clearItems();
                    this.m_6596_();
                    ParticleUtil.spawnPoof((ServerLevel)this.f_58857_, this.f_58858_);
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundRegistry.APPARATUS_FINISH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.isCrafting = false;
                this.m_6596_();
            }
            this.updateBlock();
        }
    }

    public void clearItems() {
        for (BlockPos blockPos : this.pedestalList()) {
            ArcanePedestalTile tile;
            BlockEntity blockEntity = this.f_58857_.m_7702_(blockPos);
            if (!(blockEntity instanceof ArcanePedestalTile) || (tile = (ArcanePedestalTile)blockEntity).getStack() == null) continue;
            tile.setStack(tile.getStack().getCraftingRemainingItem());
            BlockState state = this.f_58857_.m_8055_(blockPos);
            this.f_58857_.m_7260_(blockPos, state, state, 3);
            tile.m_6596_();
        }
    }

    public List<BlockPos> pedestalList() {
        int offset = 3;
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (BlockPos b : BlockPos.m_121940_((BlockPos)this.m_58899_().m_7918_(offset, -offset, offset), (BlockPos)this.m_58899_().m_7918_(-offset, offset, -offset))) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(b);
            if (!(blockEntity instanceof ArcanePedestalTile)) continue;
            ArcanePedestalTile tile = (ArcanePedestalTile)blockEntity;
            posList.add(b.m_7949_());
        }
        return posList;
    }

    public List<ItemStack> getPedestalItems() {
        ArrayList<ItemStack> pedestalItems = new ArrayList<ItemStack>();
        for (BlockPos blockPos : this.pedestalList()) {
            ArcanePedestalTile tile;
            BlockEntity blockEntity = this.f_58857_.m_7702_(blockPos);
            if (!(blockEntity instanceof ArcanePedestalTile) || (tile = (ArcanePedestalTile)blockEntity).getStack() == null || tile.getStack().m_41619_()) continue;
            pedestalItems.add(tile.getStack());
        }
        return pedestalItems;
    }

    public IEnchantingRecipe getRecipe(ItemStack stack, @Nullable Player playerEntity) {
        List<ItemStack> pedestalItems = this.getPedestalItems();
        return ArsNouveauAPI.getInstance().getEnchantingApparatusRecipes(this.f_58857_).stream().filter(r -> r.isMatch(pedestalItems, stack, this, playerEntity)).findFirst().orElse(null);
    }

    public boolean attemptCraft(ItemStack catalyst, @Nullable Player playerEntity) {
        if (this.isCrafting) {
            return false;
        }
        if (!this.craftingPossible(catalyst, playerEntity)) {
            return false;
        }
        IEnchantingRecipe recipe = this.getRecipe(catalyst, playerEntity);
        if (recipe.consumesSource()) {
            SourceUtil.takeSourceNearbyWithParticles(this.f_58858_, this.f_58857_, 10, recipe.getSourceCost());
        }
        this.isCrafting = true;
        this.updateBlock();
        Networking.sendToNearby(this.f_58857_, this.f_58858_, (Object)new PacketOneShotAnimation(this.f_58858_));
        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundRegistry.APPARATUS_CHANNEL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public boolean craftingPossible(ItemStack stack, Player playerEntity) {
        if (this.isCrafting || stack.m_41619_()) {
            return false;
        }
        IEnchantingRecipe recipe = this.getRecipe(stack, playerEntity);
        return recipe != null && (!recipe.consumesSource() || recipe.consumesSource() && SourceUtil.hasSourceNearby(this.f_58858_, this.f_58857_, 10, recipe.getSourceCost()));
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.isCrafting = compound.m_128471_("is_crafting");
        this.counter = compound.m_128451_("counter");
        super.m_142466_(compound);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("is_crafting", this.isCrafting);
        tag.m_128405_("counter", this.counter);
    }

    @Override
    public ItemStack m_8020_(int index) {
        if (this.isCrafting) {
            return ItemStack.f_41583_;
        }
        return super.m_8020_(index);
    }

    @Override
    public boolean m_7013_(int slot, ItemStack newStack) {
        if (this.isCrafting || newStack.m_41619_()) {
            return false;
        }
        return this.stack.m_41619_() && this.craftingPossible(newStack, null);
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        if (this.isCrafting) {
            return ItemStack.f_41583_;
        }
        return super.m_7407_(index, count);
    }

    @Override
    public ItemStack m_8016_(int index) {
        if (this.isCrafting) {
            return ItemStack.f_41583_;
        }
        return super.m_8016_(index);
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        if (this.isCrafting) {
            return;
        }
        super.m_6836_(index, stack);
        this.attemptCraft(stack, null);
    }

    public void registerControllers(AnimationData animationData) {
        this.idleController = new AnimationController((IAnimatable)this, "controller", 0.0f, this::idlePredicate);
        animationData.addAnimationController(this.idleController);
        this.craftController = new AnimationController((IAnimatable)this, "craft_controller", 0.0f, this::craftPredicate);
        animationData.addAnimationController(this.craftController);
        animationData.setResetSpeedInTicks(0.0);
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    private <E extends BlockEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("floating", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends BlockEntity> PlayState craftPredicate(AnimationEvent<E> event) {
        if (!this.isCrafting) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void startAnimation(int arg) {
        try {
            if (this.craftController != null) {
                this.craftController.markNeedsReload();
                this.craftController.setAnimation(new AnimationBuilder().addAnimation("enchanting", Boolean.valueOf(false)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

