/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.block.AlterationTable;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class AlterationTile
extends ModdedTile
implements IAnimatable,
ITickable {
    public ItemStack armorStack = ItemStack.f_41583_;
    public ItemEntity renderEntity;
    public List<ItemStack> perkList = new ArrayList<ItemStack>();
    public int newPerkTimer = 0;
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public AlterationTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public AlterationTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.ARMOR_TILE, pos, state);
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Nullable
    public AlterationTile getLogicTile() {
        AlterationTile tile = this;
        if (!this.isMasterTile()) {
            AlterationTile alterationTile;
            BlockEntity tileEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(AlterationTable.getConnectedDirection(this.m_58900_())));
            tile = tileEntity instanceof AlterationTile ? (alterationTile = (AlterationTile)tileEntity) : null;
        }
        return tile;
    }

    public boolean isMasterTile() {
        return this.m_58900_().m_61143_((Property)AlterationTable.PART) == ThreePartBlock.HEAD;
    }

    public void setArmorStack(ItemStack stack, Player player) {
        IPerkHolder<ItemStack> holder = PerkUtil.getPerkHolder(stack);
        if (holder instanceof ArmorPerkHolder) {
            ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)holder;
            this.perkList = new ArrayList<ItemStack>(PerkUtil.getPerksAsItems(stack).stream().map(Item::m_7968_).toList());
            armorPerkHolder.setPerks(new ArrayList<IPerk>());
            this.armorStack = stack.m_41777_();
            stack.m_41774_(1);
            this.newPerkTimer = 0;
            this.updateBlock();
        }
    }

    public void removePerk(Player player) {
        if (!this.perkList.isEmpty()) {
            ItemStack stack = this.perkList.get(0);
            if (!player.m_36356_(stack.m_41777_())) {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), stack.m_41777_()));
            }
            this.perkList.remove(0);
        }
        this.updateBlock();
    }

    public void removeArmorStack(Player player) {
        IPerkHolder<ItemStack> perkHolder = PerkUtil.getPerkHolder(this.armorStack);
        if (perkHolder instanceof ArmorPerkHolder) {
            ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)perkHolder;
            armorPerkHolder.setPerks(this.perkList.stream().map(i -> {
                Item patt4132$temp = i.m_41720_();
                if (patt4132$temp instanceof PerkItem) {
                    PerkItem perkItem = (PerkItem)patt4132$temp;
                    return perkItem.perk;
                }
                return null;
            }).filter(Objects::nonNull).toList());
        }
        if (!player.m_36356_(this.armorStack.m_41777_())) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), this.armorStack.m_41777_()));
        }
        this.armorStack = ItemStack.f_41583_;
        this.perkList = new ArrayList<ItemStack>();
        this.updateBlock();
    }

    public void addPerkStack(ItemStack stack, Player player) {
        IPerkHolder<ItemStack> perkHolder = PerkUtil.getPerkHolder(this.armorStack);
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.perk.set_armor"));
            return;
        }
        ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)perkHolder;
        if (this.perkList.size() >= 3 || this.perkList.size() >= armorPerkHolder.getSlotsForTier().size()) {
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.perk.max_perks"));
            return;
        }
        PerkSlot foundSlot = this.getAvailableSlot(perkHolder);
        Item item = stack.m_41720_();
        if (item instanceof PerkItem) {
            PerkItem perkItem = (PerkItem)item;
            IPerk perk = perkItem.perk;
            if (foundSlot != null && perk.validForSlot(foundSlot, stack, player)) {
                this.perkList.add(stack.m_41620_(1));
                if (this.newPerkTimer <= 0) {
                    this.newPerkTimer = 40;
                }
                this.updateBlock();
            }
        }
    }

    private PerkSlot getAvailableSlot(IPerkHolder<ItemStack> perkHolder) {
        if (this.perkList.size() >= perkHolder.getSlotsForTier().size()) {
            return null;
        }
        return perkHolder.getSlotsForTier().get(this.perkList.size());
    }

    public void dropItems() {
        if (!this.armorStack.m_41619_()) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), this.armorStack.m_41777_()));
        }
        for (ItemStack stack : this.perkList) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), stack.m_41777_()));
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag armorTag = new CompoundTag();
        this.armorStack.m_41739_(armorTag);
        tag.m_128365_("armorStack", (Tag)armorTag);
        tag.m_128405_("numPerks", this.perkList.size());
        int count = 0;
        for (ItemStack i : this.perkList) {
            CompoundTag perkTag = new CompoundTag();
            i.m_41739_(perkTag);
            tag.m_128365_("perk" + count, (Tag)perkTag);
            ++count;
        }
        tag.m_128405_("newPerkTimer", this.newPerkTimer);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.armorStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("armorStack"));
        int count = compound.m_128451_("numPerks");
        this.perkList = new ArrayList<ItemStack>();
        for (int i = 0; i < count; ++i) {
            CompoundTag perkTag = compound.m_128469_("perk" + i);
            ItemStack perk = ItemStack.m_41712_((CompoundTag)perkTag);
            this.perkList.add(perk);
        }
        this.newPerkTimer = compound.m_128451_("newPerkTimer");
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(2.0);
    }

    @Override
    public void tick(Level level, BlockState state, BlockPos pos) {
        if (level.f_46443_ && this.newPerkTimer >= 0) {
            --this.newPerkTimer;
        }
    }
}

