/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.armor;

import com.hollingsworth.arsnouveau.api.client.IVariantColorProvider;
import com.hollingsworth.arsnouveau.api.mana.IManaEquipment;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.armor.MagicArmor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;

public class AnimatedMagicArmor
extends MagicArmor
implements IManaEquipment,
IAnimatable,
IVariantColorProvider<ItemStack> {
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public AnimatedMagicArmor(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public void registerControllers(AnimationData data) {
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return GeoArmorRenderer.getRenderer(AnimatedMagicArmor.this.getClass(), (Entity)livingEntity).applyEntityStats(original).applySlot(equipmentSlot).setCurrentItem(livingEntity, itemStack, equipmentSlot);
            }
        });
    }

    @Nullable
    public final String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        Class<?> clazz = this.getClass();
        GeoArmorRenderer renderer = GeoArmorRenderer.getRenderer(clazz, (Entity)entity);
        return renderer.getTextureLocation((ArmorItem)stack.m_41720_()).toString();
    }

    @Override
    public void setColor(String color) {
    }

    @Override
    public String getColor(ItemStack object) {
        IPerkHolder<ItemStack> perkHolder = PerkUtil.getPerkHolder(object);
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            return "purple";
        }
        ArmorPerkHolder data = (ArmorPerkHolder)perkHolder;
        return data.getColor() == null || data.getColor().isEmpty() ? "purple" : data.getColor();
    }
}

