/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class WildenStalkerModel
extends AnimatedGeoModel<WildenStalker> {
    public void setLivingAnimations(WildenStalker entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        if (entity.isFlying()) {
            return;
        }
        IBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
        head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        IBone frontLeftLeg = this.getAnimationProcessor().getBone("left_leg");
        IBone frontRightLeg = this.getAnimationProcessor().getBone("right_leg");
        IBone frontLeftArm = this.getAnimationProcessor().getBone("left_arm");
        IBone frontRightArm = this.getAnimationProcessor().getBone("right_arm");
        frontLeftLeg.setRotationX(Mth.m_14089_((float)(entity.f_20925_ * 0.6662f)) * 1.4f * entity.f_20924_);
        frontRightLeg.setRotationX(Mth.m_14089_((float)(entity.f_20925_ * 0.6662f + (float)Math.PI)) * 1.4f * entity.f_20924_);
    }

    public ResourceLocation getModelResource(WildenStalker wildenStalker) {
        return wildenStalker.isFlying() ? new ResourceLocation("ars_nouveau", "geo/stalker_flying.geo.json") : new ResourceLocation("ars_nouveau", "geo/stalker_standing.geo.json");
    }

    public ResourceLocation getTextureResource(WildenStalker wildenStalker) {
        return new ResourceLocation("ars_nouveau", "textures/entity/stalker_angry.png");
    }

    public ResourceLocation getAnimationResource(WildenStalker wildenStalker) {
        return new ResourceLocation("ars_nouveau", "animations/wilden_stalker_standing.geo.json");
    }
}

