/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.client.jei.JEIArsNouveauPlugin;
import com.hollingsworth.arsnouveau.client.jei.JEIConstants;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCrush;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;

public class CrushRecipeCategory
implements IRecipeCategory<CrushRecipe> {
    public IDrawable background;
    public IDrawable icon;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public CrushRecipeCategory(final IGuiHelper helper) {
        this.background = helper.createBlankDrawable(120, 56);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)ArsNouveauAPI.getInstance().getGlyphItem(EffectCrush.INSTANCE).m_7968_());
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(JEIConstants.RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public RecipeType<CrushRecipe> getRecipeType() {
        return JEIArsNouveauPlugin.CRUSH_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"ars_nouveau.crush_recipe");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CrushRecipe recipe, @Nonnull IRecipeSlotsView slotsView, @Nonnull PoseStack matrixStack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)40);
        arrow.draw(matrixStack, 30, 6);
        Font renderer = Minecraft.m_91087_().f_91062_;
        for (int i = 0; i < recipe.outputs.size(); ++i) {
            renderer.m_92883_(matrixStack, Math.round(100.0f * recipe.outputs.get((int)i).chance - 0.5f) + "%", 85.0f, 11.0f + 17.0f * (float)i, 10);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrushRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 5).addIngredients(recipe.input);
        for (int i = 0; i < recipe.outputs.size(); ++i) {
            CrushRecipe.CrushOutput output = recipe.outputs.get(i);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 60, 5 + 16 * i).addItemStack(output.stack);
        }
    }
}

