/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class InvUtil {
    public static List<FilterableItemHandler> adjacentInventories(Level level, BlockPos pos) {
        ArrayList<FilterableItemHandler> inventories = new ArrayList<FilterableItemHandler>();
        for (Direction d : Direction.values()) {
            BlockEntity adjacentInvTile = level.m_7702_(pos.m_121945_(d));
            if (adjacentInvTile == null) continue;
            adjacentInvTile.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
                ArrayList<Function<ItemStack, ItemScroll.SortPref>> filters = new ArrayList<Function<ItemStack, ItemScroll.SortPref>>();
                for (ItemFrame i : adjacentInvTile.m_58904_().m_45976_(ItemFrame.class, new AABB(adjacentInvTile.m_58899_()).m_82400_(1.0))) {
                    BlockEntity tileOnFrame = adjacentInvTile.m_58904_().m_7702_(i.m_20183_().m_121945_(i.m_6350_().m_122424_()));
                    ItemStack stackInFrame = i.m_31822_();
                    if (tileOnFrame == null || !tileOnFrame.equals(adjacentInvTile) || i.m_31822_().m_41619_() || stackInFrame.m_41619_()) continue;
                    Item patt2054$temp = stackInFrame.m_41720_();
                    if (patt2054$temp instanceof ItemScroll) {
                        ItemScroll scrollItem = (ItemScroll)patt2054$temp;
                        filters.add(stackToStore -> scrollItem.getSortPref((ItemStack)stackToStore, stackInFrame, (IItemHandler)inv));
                        continue;
                    }
                    filters.add(stackToStore -> stackToStore.m_41720_() == stackInFrame.m_41720_() ? ItemScroll.SortPref.HIGHEST : ItemScroll.SortPref.INVALID);
                }
                inventories.add(new FilterableItemHandler((IItemHandler)inv, (List<Function<ItemStack, ItemScroll.SortPref>>)filters));
            });
        }
        return inventories;
    }

    public static List<FilterableItemHandler> fromPlayer(Player player) {
        ArrayList<FilterableItemHandler> list = new ArrayList<FilterableItemHandler>();
        list.add(new FilterableItemHandler((IItemHandler)new PlayerMainInvWrapper(player.f_36093_), new ArrayList<Function<ItemStack, ItemScroll.SortPref>>()));
        return list;
    }
}

