/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public interface ISpellCaster {
    @Nonnull
    public Spell getSpell();

    @Nonnull
    public Spell getSpell(int var1);

    public int getMaxSlots();

    public int getCurrentSlot();

    public void setCurrentSlot(int var1);

    default public void setNextSlot() {
        int slot = this.getCurrentSlot() + 1;
        if (slot >= this.getMaxSlots()) {
            slot = 0;
        }
        this.setCurrentSlot(slot);
    }

    default public void setPreviousSlot() {
        int slot = this.getCurrentSlot() - 1;
        if (slot < 0) {
            slot = this.getMaxSlots() - 1;
        }
        this.setCurrentSlot(slot);
    }

    public void setSpell(Spell var1, int var2);

    public void setSpell(Spell var1);

    public void setSpellRecipe(List<AbstractSpellPart> var1, int var2);

    @Nonnull
    public ParticleColor getColor(int var1);

    @Nonnull
    public ParticleColor getColor();

    public void setColor(ParticleColor var1);

    public void setColor(ParticleColor var1, int var2);

    @Nonnull
    public ConfiguredSpellSound getSound(int var1);

    public void setSound(ConfiguredSpellSound var1, int var2);

    default public ConfiguredSpellSound getCurrentSound() {
        return this.getSound(this.getCurrentSlot());
    }

    public void setFlavorText(String var1);

    public String getSpellName(int var1);

    public String getSpellName();

    public void setSpellName(String var1);

    public void setSpellName(String var1, int var2);

    public String getFlavorText();

    public Map<Integer, Spell> getSpells();

    @Nonnull
    default public Spell getSpell(Level world, Player playerEntity, InteractionHand hand, ISpellCaster caster) {
        return caster.getSpell();
    }

    default public Spell modifySpellBeforeCasting(Level worldIn, @Nullable Entity playerIn, @Nullable InteractionHand handIn, Spell spell) {
        return spell;
    }

    default public InteractionResultHolder<ItemStack> castSpell(Level worldIn, Player playerIn, InteractionHand handIn, @Nullable Component invalidMessage, @Nonnull Spell spell) {
        EntityHitResult entityHitResult;
        ItemStack stack = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)playerIn.m_21120_(handIn));
        }
        if (!(spell = this.modifySpellBeforeCasting(worldIn, (Entity)playerIn, handIn, spell)).isValid() && invalidMessage != null) {
            PortUtil.sendMessageNoSpam((Entity)playerIn, invalidMessage);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        SpellResolver resolver = this.getSpellResolver(new SpellContext(worldIn, spell, (LivingEntity)playerIn, new LivingCaster((LivingEntity)playerIn)), worldIn, playerIn, handIn);
        boolean isSensitive = resolver.spell.getBuffsAtIndex(0, (LivingEntity)playerIn, AugmentSensitive.INSTANCE) > 0;
        HitResult result = SpellUtil.rayTrace((Entity)playerIn, 5.0, 0.0f, isSensitive);
        if (result instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)result;
            BlockEntity tile = worldIn.m_7702_(blockHit.m_82425_());
            if (tile instanceof ScribesTile) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            if (!playerIn.m_6144_() && tile != null && !worldIn.m_8055_(blockHit.m_82425_()).m_204336_(BlockTagProvider.IGNORE_TILE)) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        if (result instanceof EntityHitResult && (entityHitResult = (EntityHitResult)result).m_82443_() instanceof LivingEntity) {
            if (resolver.onCastOnEntity(stack, entityHitResult.m_82443_(), handIn)) {
                this.playSound(playerIn.m_20097_(), worldIn, playerIn, this.getCurrentSound(), SoundSource.PLAYERS);
            }
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        if (result instanceof BlockHitResult && (result.m_6662_() == HitResult.Type.BLOCK || isSensitive)) {
            UseOnContext context = new UseOnContext(playerIn, handIn, (BlockHitResult)result);
            if (resolver.onCastOnBlock(context)) {
                this.playSound(playerIn.m_20097_(), worldIn, playerIn, this.getCurrentSound(), SoundSource.PLAYERS);
            }
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        if (resolver.onCast(stack, worldIn)) {
            this.playSound(playerIn.m_20097_(), worldIn, playerIn, this.getCurrentSound(), SoundSource.PLAYERS);
        }
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
    }

    default public InteractionResultHolder<ItemStack> castSpell(Level worldIn, Player playerIn, InteractionHand handIn, Component invalidMessage) {
        return this.castSpell(worldIn, playerIn, handIn, invalidMessage, this.getSpell(worldIn, playerIn, handIn, this));
    }

    default public void copyFromCaster(ISpellCaster other) {
        for (int i = 0; i < this.getMaxSlots() && i < other.getMaxSlots(); ++i) {
            this.setSpell(other.getSpell(i), i);
            this.setFlavorText(other.getFlavorText());
        }
    }

    default public SpellResolver getSpellResolver(SpellContext context, Level worldIn, Player playerIn, InteractionHand handIn) {
        return new SpellResolver(context);
    }

    default public void playSound(BlockPos pos, Level worldIn, @Nullable Player playerIn, ConfiguredSpellSound configuredSound, SoundSource source) {
        if (configuredSound == null || configuredSound.sound == null || configuredSound.sound.getSoundEvent() == null || configuredSound.equals(ConfiguredSpellSound.EMPTY)) {
            return;
        }
        worldIn.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, configuredSound.sound.getSoundEvent(), source, configuredSound.volume, configuredSound.pitch);
    }

    public ResourceLocation getTagID();
}

