/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.util.SpellPartConfigUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class AbstractSpellPart
implements Comparable<AbstractSpellPart> {
    private final ResourceLocation registryName;
    public String name;
    public Glyph glyphItem;
    public List<SpellSchool> spellSchools = new CopyOnWriteArrayList<SpellSchool>();
    public Set<AbstractAugment> compatibleAugments = ConcurrentHashMap.newKeySet();
    @Nullable
    public ForgeConfigSpec CONFIG;
    @Nullable
    public ForgeConfigSpec.IntValue COST;
    @Nullable
    public ForgeConfigSpec.BooleanValue ENABLED;
    @Nullable
    public ForgeConfigSpec.BooleanValue STARTER_SPELL;
    @Nullable
    public ForgeConfigSpec.IntValue PER_SPELL_LIMIT;
    public SpellPartConfigUtil.AugmentLimits augmentLimits;

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public AbstractSpellPart(String registryName, String name) {
        this(new ResourceLocation("ars_nouveau", registryName), name);
    }

    public AbstractSpellPart(ResourceLocation registryName, String name) {
        this.registryName = registryName;
        this.name = name;
        for (SpellSchool spellSchool : this.getSchools()) {
            spellSchool.addSpellPart(this);
            this.spellSchools.add(spellSchool);
        }
        this.compatibleAugments.addAll(this.getCompatibleAugments());
    }

    public abstract int getDefaultManaCost();

    public int getCastingCost() {
        return this.COST == null ? this.getDefaultManaCost() : ((Integer)this.COST.get()).intValue();
    }

    public String getName() {
        return this.name;
    }

    public SpellTier getTier() {
        return SpellTier.ONE;
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this);
        }
        return this.glyphItem;
    }

    @Nonnull
    protected abstract Set<AbstractAugment> getCompatibleAugments();

    protected Set<AbstractAugment> augmentSetOf(AbstractAugment ... augments) {
        return this.setOf(augments);
    }

    @Nonnull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[0]);
    }

    protected <T> Set<T> setOf(T ... list) {
        return Set.of(list);
    }

    @Override
    public int compareTo(AbstractSpellPart o) {
        return this.getTier().value - o.getTier().value;
    }

    public Component getBookDescLang() {
        return Component.m_237115_((String)(this.getRegistryName().m_135827_() + ".glyph_desc." + this.getRegistryName().m_135815_()));
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("General settings").push("general");
        this.ENABLED = builder.comment("Is Enabled?").define("enabled", true);
        this.COST = builder.comment("Cost").defineInRange("cost", this.getDefaultManaCost(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.STARTER_SPELL = builder.comment("Is Starter Glyph?").define("starter", this.defaultedStarterGlyph());
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
    }

    public int getAugmentLimit(ResourceLocation augmentTag) {
        if (this.augmentLimits == null) {
            return Integer.MAX_VALUE;
        }
        return this.augmentLimits.getAugmentLimit(augmentTag);
    }

    protected void buildAugmentLimitsConfig(ForgeConfigSpec.Builder builder, Map<ResourceLocation, Integer> defaults) {
        this.augmentLimits = SpellPartConfigUtil.buildAugmentLimitsConfig(builder, defaults);
    }

    protected Map<ResourceLocation, Integer> getDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        this.addDefaultAugmentLimits(defaults);
        return defaults;
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
    }

    public boolean defaultedStarterGlyph() {
        return false;
    }

    public String getBookDescription() {
        return "";
    }

    public String getLocalizationKey() {
        return this.registryName.m_135827_() + ".glyph_name." + this.registryName.m_135815_();
    }

    public String getLocaleName() {
        return Component.m_237115_((String)this.getLocalizationKey()).getString();
    }
}

