/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.perk;

import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.util.RomanNumber;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public interface IPerkHolder<T> {
    default public List<PerkInstance> getPerkInstances() {
        ArrayList<PerkInstance> perkInstances = new ArrayList<PerkInstance>();
        ArrayList<PerkSlot> slots = new ArrayList<PerkSlot>(this.getSlotsForTier());
        List<IPerk> perks = this.getPerks();
        for (int i = 0; i < slots.size(); ++i) {
            if (i >= perks.size()) continue;
            perkInstances.add(new PerkInstance((PerkSlot)slots.get(i), perks.get(i)));
        }
        return perkInstances;
    }

    public List<IPerk> getPerks();

    public void setPerks(List<IPerk> var1);

    public List<PerkSlot> getSlotsForTier();

    default public boolean isEmpty() {
        return this.getPerks().isEmpty();
    }

    default public void appendPerkTooltip(List<Component> tooltip, T obj) {
        for (PerkInstance perkInstance : this.getPerkInstances()) {
            IPerk perk = perkInstance.getPerk();
            ResourceLocation location = perk.getRegistryName();
            tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)("item." + location.m_135827_() + "." + location.m_135815_())).getString() + " " + RomanNumber.toRoman(perkInstance.getSlot().value))));
        }
        int missing = this.getSlotsForTier().size() - this.getPerkInstances().size();
        for (int i = 0; i < missing; ++i) {
            PerkSlot slot = new ArrayList<PerkSlot>(this.getSlotsForTier()).subList(this.getPerkInstances().size(), this.getSlotsForTier().size()).get(i);
            tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"Empty").getString() + " " + RomanNumber.toRoman(slot.value))).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        }
    }

    public int getTier();

    public void setTier(int var1);

    @Nullable
    public CompoundTag getTagForPerk(IPerk var1);

    public void setTagForPerk(IPerk var1, CompoundTag var2);
}

