/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.RangeRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateFlight;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;

public class RitualFlight
extends RangeRitual {
    @Override
    public int getSourceCost() {
        return 200;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("ars_nouveau", RitualLib.FLIGHT);
    }

    @Override
    public String getLangDescription() {
        return "Grants nearby players the Flight effect when they jump, allowing them to creatively fly for a short time. If the player is nearby, this ritual will refresh their flight buff. Each time this ritual grants or refreshes flight, it will expend source from nearby jars.";
    }

    @Override
    public String getLangName() {
        return "Flight";
    }

    public boolean refreshFlightEvent(ServerPlayer player) {
        if (!player.f_19853_.f_46443_ && !this.needsSourceNow() && BlockUtil.distanceFrom(this.getPos(), player.m_20183_()) <= 60.0 && player.f_36077_.f_35935_) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModPotions.FLIGHT_EFFECT.get(), 1200));
            player.f_36077_.f_35936_ = true;
            player.f_36077_.f_35935_ = true;
            Networking.sendToPlayerClient(new PacketUpdateFlight(true, true), player);
            this.setNeedsSource(true);
            return true;
        }
        return false;
    }

    public boolean onJumpEvent(LivingEvent.LivingJumpEvent event) {
        Player entity;
        LivingEntity livingEntity;
        if (!this.needsSourceNow() && (livingEntity = event.getEntity()) instanceof Player && (entity = (Player)livingEntity).m_21124_((MobEffect)ModPotions.FLIGHT_EFFECT.get()) == null && BlockUtil.distanceFrom(this.getPos(), entity.m_20183_()) <= 60.0) {
            this.setNeedsSource(true);
            entity.m_7292_(new MobEffectInstance((MobEffect)ModPotions.FLIGHT_EFFECT.get(), 1800));
            return true;
        }
        return false;
    }
}

