/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.nbt.ItemstackData;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.client.renderer.item.ScryCasterRenderer;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.ScryerCrystal;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.ScryerScroll;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;
import software.bernie.ars_nouveau.geckolib3.util.GeckoLibUtil;

public class ScryCaster
extends ModItem
implements ICasterTool,
IAnimatable {
    AnimationFactory factory = GeckoLibUtil.createFactory(this);

    public ScryCaster(Item.Properties properties) {
        super(properties);
    }

    public ScryCaster() {
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        BlockPos pos = pContext.m_8083_();
        ItemStack stack = pContext.m_43722_();
        Data data = new Data(stack);
        if (pContext.m_43725_().m_8055_(pos).m_60734_() instanceof ScryerCrystal) {
            if (!pContext.m_43725_().f_46443_) {
                data.setScryPos(pos);
                PortUtil.sendMessage((Entity)pContext.m_43723_(), (Component)Component.m_237115_((String)"ars_nouveau.dominion_wand.position_set"));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        ISpellCaster caster = this.getSpellCaster(stack);
        return caster.castSpell(pLevel, (LivingEntity)pPlayer, pUsedHand, (Component)Component.m_237115_((String)"ars_nouveau.invalid_spell"));
    }

    @Override
    public ISpellCaster getSpellCaster(CompoundTag tag) {
        return new ScryCasterType(tag);
    }

    @Override
    @NotNull
    public ISpellCaster getSpellCaster(ItemStack stack) {
        return new ScryCasterType(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        this.getInformation(stack, worldIn, tooltip2, flagIn);
        Data data = new Data(stack);
        if (data.scryPos == null) {
            tooltip2.add((Component)Component.m_237115_((String)"ars_nouveau.scry_caster.no_pos"));
        } else {
            tooltip2.add((Component)Component.m_237110_((String)"ars_nouveau.scryer_scroll.bound", (Object[])new Object[]{data.getScryPos().m_123341_() + ", " + data.getScryPos().m_123342_() + ", " + data.getScryPos().m_123343_()}));
        }
        super.m_7373_(stack, worldIn, tooltip2, flagIn);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new ScryCasterRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    @Override
    public void registerControllers(AnimationData data) {
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static class Data
    extends ItemstackData {
        private BlockPos scryPos;

        public Data(ItemStack stack) {
            super(stack);
            CompoundTag tag1 = this.getItemTag(stack);
            if (tag1 == null || tag1.m_128456_()) {
                return;
            }
            if (tag1.m_128441_("scryPos")) {
                this.scryPos = BlockPos.m_122022_((long)tag1.m_128454_("scryPos"));
            }
        }

        public void setScryPos(BlockPos pos) {
            this.scryPos = pos;
            this.writeItem();
        }

        @javax.annotation.Nullable
        public BlockPos getScryPos() {
            return this.scryPos;
        }

        @Override
        public String getTagString() {
            return "an_scry_data";
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            if (this.scryPos != null) {
                tag.m_128356_("scryPos", this.scryPos.m_121878_());
            }
        }
    }

    public static class ScryCasterType
    extends SpellCaster {
        public ScryCasterType(ItemStack stack) {
            super(stack);
        }

        public ScryCasterType(CompoundTag itemTag) {
            super(itemTag);
        }

        @Override
        public InteractionResultHolder<ItemStack> castSpell(Level worldIn, LivingEntity entity, InteractionHand handIn, @Nullable Component invalidMessage, @NotNull Spell spell) {
            BlockPos scryPos;
            LivingCaster livingCaster;
            ANFakePlayer player;
            ItemStack stack = entity.m_21120_(handIn);
            if (worldIn.f_46443_) {
                return InteractionResultHolder.m_19098_((Object)entity.m_21120_(handIn));
            }
            if (!(spell = this.modifySpellBeforeCasting(worldIn, (Entity)entity, handIn, spell)).isValid() && invalidMessage != null) {
                PortUtil.sendMessageNoSpam((Entity)entity, invalidMessage);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            if (entity instanceof Player) {
                Player thisPlayer = (Player)entity;
                v0 = thisPlayer;
            } else {
                v0 = player = ANFakePlayer.getPlayer((ServerLevel)worldIn);
            }
            if (entity instanceof Player) {
                Player pCaster = (Player)entity;
                livingCaster = new PlayerCaster(pCaster);
            } else {
                livingCaster = new LivingCaster(entity);
            }
            LivingCaster wrappedCaster = livingCaster;
            SpellResolver resolver = this.getSpellResolver(new SpellContext(worldIn, spell, entity, wrappedCaster, stack), worldIn, (LivingEntity)player, handIn);
            ITurretBehavior behavior = BasicSpellTurret.TURRET_BEHAVIOR_MAP.get(spell.getCastMethod());
            if (behavior == null) {
                PortUtil.sendMessage((Entity)entity, (Component)Component.m_237115_((String)"ars_nouveau.scry_caster.invalid_behavior"));
                return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
            }
            Data data = new Data(stack);
            boolean playerHoldingScroll = entity.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ScryerScroll;
            BlockPos blockPos = scryPos = playerHoldingScroll ? new ScryerScroll.ScryerScrollData((ItemStack)player.m_21120_((InteractionHand)InteractionHand.OFF_HAND)).pos : data.getScryPos();
            if (scryPos == null) {
                PortUtil.sendMessage((Entity)entity, (Component)Component.m_237115_((String)"ars_nouveau.scry_caster.no_pos"));
                return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
            }
            if (!worldIn.m_46749_(scryPos)) {
                PortUtil.sendMessage((Entity)entity, (Component)Component.m_237115_((String)"ars_nouveau.camera.not_loaded"));
                return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
            }
            BlockState castingAtState = worldIn.m_8055_(scryPos);
            if (!(castingAtState.m_60734_() instanceof ScryerCrystal)) {
                PortUtil.sendMessage((Entity)entity, (Component)Component.m_237115_((String)"ars_nouveau.scry_caster.not_crystal"));
                return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
            }
            BlockSourceImpl blockSource = new BlockSourceImpl((ServerLevel)worldIn, scryPos);
            Direction direction = (Direction)castingAtState.m_61143_((Property)ScryerCrystal.FACING);
            Position position = spell.getCastMethod() instanceof MethodTouch ? BasicSpellTurret.getDispensePosition((BlockSource)blockSource) : ScryerCrystal.getDispensePosition((BlockSource)new BlockSourceImpl((ServerLevel)worldIn, scryPos), direction);
            behavior.onCast(resolver, (ServerLevel)worldIn, scryPos, (Player)player, position, direction);
            resolver.expendMana();
            this.playSound(entity.m_20097_(), worldIn, (Entity)entity, this.getCurrentSound(), SoundSource.PLAYERS);
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
    }
}

