/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.common.block.AlterationTable;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.lib.LibBlockNames;
import com.hollingsworth.arsnouveau.common.util.RegistryWrapper;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DefaultTableProvider
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(BlockLootTable::new, (Object)LootContextParamSets.f_81421_));

    public DefaultTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((p_218436_2_, p_218436_3_) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
    }

    public static class BlockLootTable
    extends BlockLoot {
        public List<Block> list = new ArrayList<Block>();

        protected void addTables() {
            this.registerDropSelf(BlockRegistry.ENCHANTED_SPELL_TURRET);
            this.registerDropSelf((Block)BlockRegistry.BLAZING_LOG);
            this.registerDropSelf((Block)BlockRegistry.VEXING_LOG);
            this.registerDropSelf((Block)BlockRegistry.CASCADING_LOG);
            this.registerDropSelf((Block)BlockRegistry.FLOURISHING_LOG);
            this.registerDropSelf((Block)BlockRegistry.BLAZING_SAPLING);
            this.registerDropSelf((Block)BlockRegistry.VEXING_SAPLING);
            this.registerDropSelf((Block)BlockRegistry.CASCADING_SAPLING);
            this.registerDropSelf((Block)BlockRegistry.FLOURISHING_SAPLING);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_PLANK);
            this.registerDrop(BlockRegistry.WIXIE_CAULDRON, (ItemLike)Items.f_42544_);
            for (FlowerPotBlock pot : BlockRegistry.flowerPots.values()) {
                this.list.add((Block)pot);
                this.m_124252_((Block)pot);
            }
            this.registerLeavesAndSticks((Block)BlockRegistry.BLAZING_LEAVES, (Block)BlockRegistry.BLAZING_SAPLING);
            this.registerLeavesAndSticks((Block)BlockRegistry.CASCADING_LEAVE, (Block)BlockRegistry.CASCADING_SAPLING);
            this.registerLeavesAndSticks((Block)BlockRegistry.FLOURISHING_LEAVES, (Block)BlockRegistry.FLOURISHING_SAPLING);
            this.registerLeavesAndSticks((Block)BlockRegistry.VEXING_LEAVES, (Block)BlockRegistry.VEXING_SAPLING);
            this.registerDropSelf((Block)BlockRegistry.BLAZING_WOOD);
            this.registerDropSelf((Block)BlockRegistry.VEXING_WOOD);
            this.registerDropSelf((Block)BlockRegistry.CASCADING_WOOD);
            this.registerDropSelf((Block)BlockRegistry.FLOURISHING_WOOD);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_BUTTON);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_STAIRS);
            this.registerSlabItemTable((Block)BlockRegistry.ARCHWOOD_SLABS);
            this.registerDropSelf(BlockRegistry.MAGELIGHT_TORCH);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_FENCE_GATE);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_TRAPDOOR);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_PPlate);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_FENCE);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWLOG_BLUE);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWWOOD_BLUE);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWLOG_GREEN);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWWOOD_GREEN);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWLOG_RED);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWWOOD_RED);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWLOG_PURPLE);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWWOOD_PURPLE);
            this.registerDropDoor((Block)BlockRegistry.ARCHWOOD_DOOR);
            this.registerDropSelf(BlockRegistry.SOURCE_GEM_BLOCK);
            this.registerDropSelf(BlockRegistry.POTION_MELDER);
            this.registerDropSelf(BlockRegistry.RITUAL_BLOCK);
            this.registerDropSelf(BlockRegistry.SCONCE_BLOCK);
            this.registerBedCondition(BlockRegistry.SCRIBES_BLOCK, (Property)ScribesBlock.PART, (Comparable<T> & StringRepresentable)ThreePartBlock.HEAD);
            this.registerDrop(BlockRegistry.DRYGMY_BLOCK, (ItemLike)Items.f_41998_);
            this.registerDropSelf(BlockRegistry.VITALIC_BLOCK);
            this.registerDropSelf(BlockRegistry.ALCHEMICAL_BLOCK);
            this.registerDropSelf(BlockRegistry.MYCELIAL_BLOCK);
            this.registerDropSelf(BlockRegistry.TIMER_SPELL_TURRET);
            this.registerDropSelf(BlockRegistry.BASIC_SPELL_TURRET);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_CHEST);
            this.registerDropSelf(BlockRegistry.SPELL_PRISM);
            this.registerDropSelf((Block)BlockRegistry.LAVA_LILY);
            this.registerDropSelf(BlockRegistry.AGRONOMIC_SOURCELINK);
            this.registerDropSelf(BlockRegistry.ENCHANTING_APP_BLOCK);
            this.registerDropSelf(BlockRegistry.ARCANE_PEDESTAL);
            this.registerDropSelf(BlockRegistry.ARCANE_PLATFORM);
            this.registerDropSelf(BlockRegistry.RELAY);
            this.registerDropSelf(BlockRegistry.RELAY_SPLITTER);
            this.registerDropSelf(BlockRegistry.ARCANE_CORE_BLOCK);
            this.registerDropSelf(BlockRegistry.IMBUEMENT_BLOCK);
            this.registerDropSelf(BlockRegistry.VOLCANIC_BLOCK);
            this.registerDropSelf((Block)BlockRegistry.LAVA_LILY);
            this.registerDropSelf(BlockRegistry.BRAZIER_RELAY);
            this.registerDropSelf(BlockRegistry.RELAY_WARP);
            this.registerDropSelf(BlockRegistry.RELAY_DEPOSIT);
            this.registerDropSelf(BlockRegistry.RELAY_COLLECTOR);
            this.registerDropSelf(BlockRegistry.CRAFTING_LECTERN.get());
            this.registerDropSelf(BlockRegistry.RED_SBED);
            this.registerDropSelf(BlockRegistry.YELLOW_SBED);
            this.registerDropSelf(BlockRegistry.GREEN_SBED);
            this.registerDropSelf(BlockRegistry.PURPLE_SBED);
            this.registerDropSelf(BlockRegistry.BLUE_SBED);
            this.registerDropSelf(BlockRegistry.ORANGE_SBED);
            this.registerDropSelf(BlockRegistry.SCRYERS_CRYSTAL);
            this.registerDropSelf(BlockRegistry.SCRYERS_OCULUS);
            this.registerDropSelf(BlockRegistry.POTION_DIFFUSER);
            for (String s : LibBlockNames.DECORATIVE_SOURCESTONE) {
                this.registerDropSelf(BlockRegistry.getBlock(s));
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ars_nouveau", s + "_stairs"));
                this.registerDropSelf(block);
                Block slab = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ars_nouveau", s + "_slab"));
                this.registerDropSelf(slab);
            }
            this.registerBedCondition(BlockRegistry.ALTERATION_TABLE, (Property)AlterationTable.PART, (Comparable<T> & StringRepresentable)ThreePartBlock.HEAD);
            this.registerDropSelf(BlockRegistry.VOID_PRISM);
            this.registerDropSelf(BlockRegistry.MAGEBLOOM_BLOCK);
            this.registerDropSelf(BlockRegistry.GHOST_WEAVE);
            this.registerDropSelf(BlockRegistry.FALSE_WEAVE);
            this.registerDropSelf(BlockRegistry.MIRROR_WEAVE);
            this.registerDropSelf(BlockRegistry.ITEM_DETECTOR);
            this.registerDropSelf(BlockRegistry.SKY_WEAVE);
            this.registerDropSelf(BlockRegistry.ROTATING_TURRET);
            this.registerDropSelf(BlockRegistry.SPELL_SENSOR);
        }

        protected void registerSlabItemTable(Block p_124291_) {
            this.list.add(p_124291_);
            this.m_124165_(p_124291_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootTable.m_236221_((ItemLike)p_124291_, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)p_124291_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124291_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))))))));
        }

        protected <T extends Comparable<T> & StringRepresentable> void registerBedCondition(Block block, Property<T> prop, T isValue) {
            this.list.add(block);
            this.m_124165_(block, LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLootTable.m_236224_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(prop, isValue)))))));
        }

        public void registerLeavesAndSticks(Block leaves, Block sapling) {
            this.list.add(leaves);
            this.m_124175_(leaves, l_state -> BlockLootTable.m_124157_((Block)l_state, (Block)sapling, (float[])DEFAULT_SAPLING_DROP_RATES));
        }

        public void registerDropDoor(Block block) {
            this.list.add(block);
            this.m_124175_(block, BlockLoot::m_124137_);
        }

        public void registerDropSelf(RegistryWrapper block) {
            this.list.add((Block)block.get());
            this.m_124288_((Block)block.get());
        }

        public void registerDropSelf(Block block) {
            this.list.add(block);
            this.m_124288_(block);
        }

        public void registerDropSelf(RegistryObject<Block> block) {
            this.list.add((Block)block.get());
            this.m_124288_((Block)block.get());
        }

        public void registerDrop(Block input, ItemLike output) {
            this.list.add(input);
            this.m_124147_(input, output);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.list;
        }
    }
}

