/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.keybindings;

import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.item.ISpellHotkeyListener;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.keybindings.ModKeyBindings;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketGenericClientMessage;
import com.hollingsworth.arsnouveau.common.network.PacketHotkeyPressed;
import com.hollingsworth.arsnouveau.common.network.PacketQuickCast;
import com.hollingsworth.arsnouveau.common.network.PacketToggleFamiliar;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class KeyHandler {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    public static KeyMapping[] CURIO_MAPPINGS = new KeyMapping[]{ModKeyBindings.HEAD_CURIO_HOTKEY};

    public static void checkKeysPressed(int key) {
        KeyHandler.checkCurioHotkey(key);
        if (key == ModKeyBindings.FAMILIAR_TOGGLE.getKey().m_84873_() && !ModKeyBindings.FAMILIAR_TOGGLE.m_90862_()) {
            Networking.sendToServer(new PacketToggleFamiliar());
        }
        if (key == ModKeyBindings.OPEN_RADIAL_HUD.getKey().m_84873_() && !ModKeyBindings.OPEN_RADIAL_HUD.m_90862_() && KeyHandler.MINECRAFT.f_91080_ instanceof GuiRadialMenu) {
            KeyHandler.MINECRAFT.f_91074_.m_6915_();
            return;
        }
        KeyHandler.checkCasterKeys(key);
    }

    public static void checkCasterKeys(int key) {
        int slot;
        InteractionHand hand;
        if (key == -1) {
            return;
        }
        LocalPlayer player = KeyHandler.MINECRAFT.f_91074_;
        ItemStack radialStack = StackUtil.getHeldRadial((Player)player);
        Item item = radialStack.m_41720_();
        if (item instanceof IRadialProvider) {
            IRadialProvider radialProvider = (IRadialProvider)item;
            if (key == ((IRadialProvider)radialStack.m_41720_()).forKey()) {
                if (KeyHandler.MINECRAFT.f_91080_ == null) {
                    radialProvider.onRadialKeyPressed(radialStack, (Player)player);
                    return;
                }
                if (KeyHandler.MINECRAFT.f_91080_ instanceof GuiRadialMenu) {
                    KeyHandler.MINECRAFT.f_91074_.m_6915_();
                    return;
                }
            }
        }
        if ((hand = StackUtil.getHeldCasterTool((Player)player)) == null) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            return;
        }
        Item item2 = stack.m_41720_();
        if (!(item2 instanceof ISpellHotkeyListener)) {
            return;
        }
        ISpellHotkeyListener hotkeyListener = (ISpellHotkeyListener)item2;
        if (key == ModKeyBindings.NEXT_SLOT.getKey().m_84873_()) {
            KeyHandler.sendHotkeyPacket(PacketHotkeyPressed.Key.NEXT);
            return;
        }
        if (key == ModKeyBindings.PREVIOUS_SLOT.getKey().m_84873_()) {
            KeyHandler.sendHotkeyPacket(PacketHotkeyPressed.Key.PREVIOUS);
            return;
        }
        if (key == ModKeyBindings.OPEN_BOOK.getKey().m_84873_()) {
            if (KeyHandler.MINECRAFT.f_91080_ instanceof GuiSpellBook && !((GuiSpellBook)KeyHandler.MINECRAFT.f_91080_).spell_name.m_93696_()) {
                KeyHandler.MINECRAFT.f_91074_.m_6915_();
                return;
            }
            if (KeyHandler.MINECRAFT.f_91080_ == null) {
                if (stack.m_41720_() instanceof SpellBook) {
                    hotkeyListener.onOpenBookMenuKeyPressed(stack, (Player)player);
                } else {
                    InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
                    ItemStack otherStack = player.m_21120_(otherHand);
                    Item item3 = otherStack.m_41720_();
                    if (item3 instanceof ISpellHotkeyListener) {
                        ISpellHotkeyListener offhandListener = (ISpellHotkeyListener)item3;
                        offhandListener.onOpenBookMenuKeyPressed(otherStack, (Player)player);
                    }
                }
            }
        }
        if ((slot = ModKeyBindings.usedQuickSlot(key)) != -1) {
            Networking.INSTANCE.sendToServer((Object)new PacketQuickCast(slot));
        }
    }

    public static void checkCurioHotkey(int keyMapping) {
        for (KeyMapping mapping : CURIO_MAPPINGS) {
            if (mapping.getKey().m_84873_() != keyMapping) continue;
            LazyOptional<IItemHandlerModifiable> stacks = CuriosUtil.getAllWornItems((LivingEntity)KeyHandler.MINECRAFT.f_91074_);
            if (!stacks.isPresent()) {
                return;
            }
            IItemHandlerModifiable handler = (IItemHandlerModifiable)stacks.orElse(null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                Item item = stack.m_41720_();
                if (!(item instanceof IRadialProvider)) continue;
                IRadialProvider radialProvider = (IRadialProvider)item;
                if (KeyHandler.MINECRAFT.f_91080_ instanceof GuiRadialMenu) {
                    KeyHandler.MINECRAFT.f_91074_.m_6915_();
                    continue;
                }
                radialProvider.onRadialKeyPressed(stack, (Player)KeyHandler.MINECRAFT.f_91074_);
            }
            return;
        }
    }

    @SubscribeEvent
    public static void mouseEvent(InputEvent.MouseButton.Post event) {
        if (KeyHandler.MINECRAFT.f_91074_ == null || event.getAction() != 1) {
            return;
        }
        if (KeyHandler.MINECRAFT.f_91080_ == null || KeyHandler.MINECRAFT.f_91080_ instanceof GuiRadialMenu) {
            KeyHandler.checkKeysPressed(event.getButton());
        }
    }

    @SubscribeEvent
    public static void keyEvent(InputEvent.Key event) {
        if (KeyHandler.MINECRAFT.f_91074_ == null || event.getAction() != 1) {
            return;
        }
        if (KeyHandler.MINECRAFT.f_91080_ == null || KeyHandler.MINECRAFT.f_91080_ instanceof GuiRadialMenu) {
            KeyHandler.checkKeysPressed(event.getKey());
        }
        if (event.getKey() == Minecraft.m_91087_().f_91066_.f_92089_.getKey().m_84873_() && Minecraft.m_91087_().f_91074_ != null && !Minecraft.m_91087_().f_91074_.m_20096_() && CuriosUtil.hasItem((LivingEntity)Minecraft.m_91087_().f_91074_, ItemsRegistry.JUMP_RING.get())) {
            Networking.INSTANCE.sendToServer((Object)new PacketGenericClientMessage(PacketGenericClientMessage.Action.JUMP_RING));
        }
    }

    public static void sendHotkeyPacket(PacketHotkeyPressed.Key key) {
        Networking.INSTANCE.sendToServer((Object)new PacketHotkeyPressed(key));
    }
}

