/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.enchanting_apparatus;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.ITextOutput;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class ArmorUpgradeRecipe
extends EnchantingApparatusRecipe
implements ITextOutput {
    public int tier;

    public ArmorUpgradeRecipe(List<Ingredient> pedestalItems, int cost, int tier) {
        this(new ResourceLocation("ars_nouveau", "upgrade_" + tier), pedestalItems, cost, tier);
    }

    public ArmorUpgradeRecipe(ResourceLocation id, List<Ingredient> pedestalItems, int cost, int tier) {
        this.pedestalItems = pedestalItems;
        this.id = id;
        this.sourceCost = cost;
        this.tier = tier;
    }

    @Override
    public boolean excludeJei() {
        return true;
    }

    @Override
    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:armor_upgrade");
        jsonobject.addProperty("sourceCost", (Number)this.getSourceCost());
        JsonArray pedestalArr = new JsonArray();
        for (Ingredient i : this.pedestalItems) {
            JsonObject object = new JsonObject();
            object.add("item", i.m_43942_());
            pedestalArr.add((JsonElement)object);
        }
        jsonobject.add("pedestalItems", (JsonElement)pedestalArr);
        jsonobject.addProperty("tier", (Number)this.tier);
        return jsonobject;
    }

    @Override
    public boolean doesReagentMatch(ItemStack reag) {
        return true;
    }

    @Override
    public boolean isMatch(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile, @Nullable Player player) {
        IPerkHolder<ItemStack> perkHolder = PerkUtil.getPerkHolder(reagent);
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            return false;
        }
        ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)perkHolder;
        return armorPerkHolder.getTier() == this.tier - 1 && super.isMatch(pedestalItems, reagent, enchantingApparatusTile, player);
    }

    @Override
    public ItemStack getResult(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile) {
        IPerkHolder<ItemStack> perkHolder = PerkUtil.getPerkHolder(reagent);
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            return reagent.m_41777_();
        }
        ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)perkHolder;
        armorPerkHolder.setTier(this.tier);
        return reagent.m_41777_();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.ARMOR_UPGRADE_TYPE.get();
    }

    @Override
    public Component getOutputComponent() {
        return Component.m_237110_((String)"ars_nouveau.armor_upgrade.book_desc", (Object[])new Object[]{this.tier});
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.ARMOR_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<ArmorUpgradeRecipe> {
        public ArmorUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int cost = json.has("sourceCost") ? GsonHelper.m_13927_((JsonObject)json, (String)"sourceCost") : 0;
            int tier = json.has("tier") ? GsonHelper.m_13927_((JsonObject)json, (String)"tier") : 0;
            JsonArray pedestalItems = GsonHelper.m_13933_((JsonObject)json, (String)"pedestalItems");
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (JsonElement e : pedestalItems) {
                JsonObject obj = e.getAsJsonObject();
                Ingredient input = null;
                input = GsonHelper.m_13885_((JsonObject)obj, (String)"item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)obj, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)obj, (String)"item"));
                stacks.add(input);
            }
            return new ArmorUpgradeRecipe(recipeId, stacks, cost, tier);
        }

        @Nullable
        public ArmorUpgradeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int length = buffer.readInt();
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            int cost = buffer.readInt();
            int tier = buffer.readInt();
            return new ArmorUpgradeRecipe(recipeId, stacks, cost, tier);
        }

        public void toNetwork(FriendlyByteBuf buf, ArmorUpgradeRecipe recipe) {
            buf.writeInt(recipe.pedestalItems.size());
            for (Ingredient i : recipe.pedestalItems) {
                i.m_43923_(buf);
            }
            buf.writeInt(recipe.sourceCost);
            buf.writeInt(recipe.tier);
        }
    }
}

