package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.lib.LibBlockNames;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;

import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;

public class LangDatagen extends LanguageProvider {
    public LangDatagen(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
    }
    private final Map<String, String> data = new TreeMap<>();
    @Override
    protected void addTranslations() {
        ArsNouveauAPI arsNouveauAPI = ArsNouveauAPI.getInstance();
        for (Supplier<Glyph> supplier : arsNouveauAPI.getGlyphItemMap().values()) {
            Glyph i = supplier.get();
            if(supplier.get().spellPart.getRegistryName().getNamespace().equals(ArsNouveau.MODID)) {
                add("ars_nouveau.glyph_desc." + i.spellPart.getRegistryName().getPath(), i.spellPart.getBookDescription());
                add("ars_nouveau.glyph_name." + i.spellPart.getRegistryName().getPath(), i.spellPart.getName());
            }
        }
        for (FamiliarScript i : arsNouveauAPI.getFamiliarScriptMap().values()) {
            if (i.familiar.getRegistryName().getNamespace().equals(ArsNouveau.MODID)){
                add("ars_nouveau.familiar_desc." + i.familiar.getRegistryName().getPath(), i.familiar.getBookDescription());
                add("ars_nouveau.familiar_name." + i.familiar.getRegistryName().getPath(), i.familiar.getBookName());
                add("item.ars_nouveau." + i.familiar.getRegistryName().getPath(), i.familiar.getBookName());
            }
        }
        for (RitualTablet i : arsNouveauAPI.getRitualItemMap().values()) {
            if(i.ritual.getRegistryName().getNamespace().equals(ArsNouveau.MODID)) {
                add("ars_nouveau.ritual_desc." + i.ritual.getRegistryName().getPath(), i.ritual.getLangDescription());
                add("item.ars_nouveau." + i.ritual.getRegistryName().getPath(), i.ritual.getLangName());
            }
        }

        for (PerkItem i : arsNouveauAPI.getPerkItemMap().values()) {
            if(i.perk.getRegistryName().getNamespace().equals(ArsNouveau.MODID) && !i.perk.getRegistryName().getPath().equals("blank_thread")) {
                add("ars_nouveau.perk_desc." + i.perk.getRegistryName().getPath(), i.perk.getLangDescription());
                add("item.ars_nouveau." + i.perk.getRegistryName().getPath(), i.perk.getLangName());
            }
        }
        add("key.category.ars_nouveau.general", "Ars Nouveau");
        add("key.ars_nouveau.previous_slot", "(Spell Book) Previous Slot");
        add("key.ars_nouveau.next_slot", "(Spell Book) Next Slot");
        add("key.ars_nouveau.open_book", "(Spell Book) Open Book");
        add("key.ars_nouveau.selection_hud", "Toggle Selection HUD");
        add("itemGroup.ars_nouveau", "Ars Nouveau");
        add("itemGroup.ars_glyphs", "Ars Nouveau Glyphs");
        add("item.ars_nouveau.novice_spell_book", "Novice Spell Book");
        add("item.ars_nouveau.apprentice_spell_book", "Mage's Spell Book");
        add("item.ars_nouveau.archmage_spell_book", "Archmage Spell Book");
        add("enchantment.ars_nouveau.mana_regen.desc", "Increases the mana regeneration of the player.");
        add("enchantment.ars_nouveau.mana_boost.desc", "Increases the maximum mana of the player.");
        add("enchantment.ars_nouveau.reactive.desc", "Has a chance to cast the inscribed spell on tool use or player hurt.");
        add("attribute.name.ars_nouveau.mana_regen", "Mana Regeneration");
        add("attribute.name.ars_nouveau.max_mana", "Max Mana");
        add("entity.ars_nouveau.bookwyrm", "Bookwyrm");
        add("entity.ars_nouveau.starbuncle", "Starbuncle");
        add("item.ars_nouveau.archmage_robes", "Battlemage's Gambeson");
        add("item.ars_nouveau.archmage_leggings", "Battlemage's Legguards");
        add("item.ars_nouveau.archmage_boots", "Battlemage's Boots");
        add("item.ars_nouveau.archmage_hood", "Battlemage's Hood");
        add("item.ars_nouveau.novice_boots", "Sorceror's Footpads");
        add("item.ars_nouveau.novice_leggings", "Sorceror's Leggings");
        add("item.ars_nouveau.novice_robes", "Sorceror's Wrap");
        add("item.ars_nouveau.novice_hood", "Sorceror's Collar");
        add("item.ars_nouveau.apprentice_robes", "Arcanist's Robes");
        add("item.ars_nouveau.apprentice_leggings", "Arcanist's Pants");
        add("item.ars_nouveau.apprentice_boots", "Arcanist's Treads");
        add("item.ars_nouveau.apprentice_hood", "Arcanist's Hat");
        add("item.ars_nouveau.ring_of_amplify", "Ring of Amplify");
        add("item.ars_nouveau.lesser_discount_ring", "Ring of Lesser Discount");
        add("item.ars_nouveau.greater_discount_ring", "Ring of Greater Discount");
        add("item.ars_nouveau.belt_of_levitation", "Belt of Levitation");
        add("item.ars_nouveau.belt_of_unstable_gifts", "Belt of Unstable Gifts");
        add("item.ars_nouveau.mundane_belt", "Mundane Belt");
        add("item.ars_nouveau.ring_of_potential", "Ring of Potential");
        add("item.ars_nouveau.jar_of_light", "Jar of Light");
        add("item.ars_nouveau.bookwyrm_charm", "Bookwyrm Charm");
        add("item.ars_nouveau.starbuncle_charm", "Starbuncle Charm");
        add("item.ars_nouveau.starbuncle_shards", "Starbuncle Shards");
        add("item.ars_nouveau.creative_spell_book", "Creative Spell Book");
        add("item.ars_nouveau.dull_trinket", "Dull Trinket");
        add("item.ars_nouveau.amulet_of_mana_boost", "Amulet of Mana Boost");
        add("item.ars_nouveau.amulet_of_mana_regen", "Amulet of Mana Regen");
        add("item.ars_nouveau.dominion_wand", "Dominion Wand");
        add("block.ars_nouveau.scribes_table", "Scribe's Table");
        add("block.ars_nouveau.light_block", "Magelight");
        add("block.ars_nouveau.temporary_light_block", "Temporary Magelight");
        add("block.ars_nouveau.mage_block", "Mage Block");
        add("block.ars_nouveau.agronomic_sourcelink", "Agronomic Sourcelink");
        add("block.ars_nouveau.source_jar", "Source Jar");
        add("block.ars_nouveau.rune", "Rune");
        add("block.ars_nouveau.warding_stone", "Warding Stone");
        add("block.ars_nouveau.arcane_pedestal", "Arcane Pedestal");
        add("block.ars_nouveau.enchanting_apparatus", "Enchanting Apparatus");
        add("block.ars_nouveau.portal", "Warp Portal");
        add("block.ars_nouveau.arcane_core", "Arcane Core");
        add("block.ars_nouveau.imbuement_chamber", "Imbuement Chamber");
        add("ars_nouveau.page.jar_of_light", "Summons a light that will follow the user as they move. Can be summoned and dismissed at any time.");
        add("ars_nouveau.page.amulet_of_mana_boost", "Increases max mana by a moderate amount.");
        add("ars_nouveau.page.amulet_of_mana_regen", "Increases mana regeneration by a moderate amount.");
        add("ars_nouveau.page.magebloom_crop", "A magically infused flower, Mageblooms provide additional source to nearby Agronomic Sourcelinks as they grow and provide a source of Magebloom Fiber. Mageblooms can also be used in crafting Potions of Spell Damage, increasing the damage of your spells.");
        add("ars_nouveau.page.belt_of_levitation", "A belt that allows the user levitate a moderate distance above the ground. Useful for climbing mountains! Simply sneak in the air while falling (or jumping) to rise. Reduces a small amount of fall damage while worn.");
        add("ars_nouveau.page.ring_of_lesser_discount", "In addition to providing a small bonus to maximum mana and mana regen, Rings of Discount reduce the total cost to cast a spell.");
        add("ars_nouveau.page.ring_of_greater_discount", "Provides a slightly larger discount over the Lesser Ring of Discount.");
        add("ars_nouveau.page.belt_of_unstable_gifts", "Occasionally grants a random positive potion effect for a short duration. These effects can vary in strength.");
        add("ars_nouveau.page.reactive", "Reactive is an enchantment that can be applied to ANY item and can be applied and upgraded by the Enchanting Apparatus. Tools and armor with the Reactive enchantment have a chance to automatically cast a spell on use or when the player is hurt. The spell that the enchantment will cast is dependent on the spell inscribed in the first crafting phase, and the user must have enough mana to cast the spell.");
        add("ars_nouveau.page.reactive2", "To enchant an item with Reactive, place any item or armor in the apparatus. The spell parchment placed on the pedestal must be inscribed with a valid spell. See the Scribes Table for additional information. Reactive Enchantment also requires jars of source near the Enchanting Apparatus. The first level enchantment requires approximately one third of a jar.");
        add("ars_nouveau.page.reactive3", "To upgrade the enchantment, replace the reagent with any item that has an existing Reactive enchantment. The Tier 2 reactive enchantment requires an item with Reactive I, and the Tier 3 Reactive enchantment requires an item with Reactive II. Higher levels will require a significantly higher amount of source nearby.");
        add("ars_nouveau.page.reactive4", "The spell that Reactive gear casts can be changed by placing an enchanted piece of gear into the apparatus with a new inscribed spell parchment. ");
        add("enchantment.ars_nouveau.mana_boost", "Mana Boost");
        add("enchantment.ars_nouveau.reactive", "Reactive");
        add("enchantment.ars_nouveau.mana_regen", "Mana Regen");
        add("item.ars_nouveau.bucket_of_source", "Source Bucket");
        add("item.ars_nouveau.magic_clay", "Magic Clay");
        add("item.ars_nouveau.marvelous_clay", "Marvelous Clay");
        add("item.ars_nouveau.mythical_clay", "Mythical Clay");
        add("item.ars_nouveau.runic_chalk", "Runic Chalk");
        add("item.ars_nouveau.magebloom", "Magebloom");
        add("item.ars_nouveau.magebloom_fiber", "Magebloom Fiber");
        add("item.ars_nouveau.blaze_fiber", "Blaze Fiber");
        add("item.ars_nouveau.end_fiber", "End Fiber");
        add("block.ars_nouveau.magebloom_crop", "Magebloom Seed");
        add("item.ars_nouveau.source_gem", "Source Gem");
        add("item.ars_nouveau.blank_glyph", "Blank Glyph");
        add("item.ars_nouveau.worn_notebook", "Worn Notebook");
        add("item.ars_nouveau.warp_scroll", "Warp Scroll");
        add("item.ars_nouveau.spell_parchment", "Spell Parchment");
        add("item.ars_nouveau.ring_of_greater_discount", "Ring of Greater Discount");
        add("item.ars_nouveau.ring_of_lesser_discount", "Ring of Lesser Discount");
        add("effect.ars_nouveau.shield", "Magic Shield");
        add("alert.core", "An Arcane Core must be placed beneath this block.");
        add("whirlisprig.unhappy", "The Whirlisprig seems very unhappy in her home. Try sprucing it up!");
        add("whirlisprig.content", "The Whirlisprig seems content, but could be better.");
        add("whirlisprig.happy", "The Whirlisprig appears happy enough.");
        add("whirlisprig.very_happy", "The Whirlisprig is very happy!");
        add("whirlisprig.extremely_happy", "The Whirlisprig is extremely happy! It doesn't seem like it wants anything else.");
        add("whirlisprig.okay_diversity", "There does not appear to be much diversity.");
        add("whirlisprig.diverse_enough", "There is some diversity, but could be better.");
        add("whirlisprig.very_diverse", "The Whirlisprig thinks her home is very diverse.");
        add("whirlisprig.extremely_diverse", "The home is extremely diverse, but Whirlisprig will never turn down a new addition to their home!");
        add("whirlisprig.notinterested", "The Whirlisprig does not seem interested in this item.");
        add("whirlisprig.likes", "The Whirlisprig likes this block!");
        add("whirlisprig.excited", "The Whirlisprig would be excited to have this in their home!");
        add("whirlisprig.toomuch", "The Whirlisprig likes this item, but has enough of it already.");
        add("item.ars_nouveau.whirlisprig_charm", "Whirlisprig Charm");
        add("item.ars_nouveau.whirlisprig_shards", "Whirlisprig Shards");
        add("entity.ars_nouveau.whirlisprig", "Whirlisprig");
        add("ars_nouveau.page.crystallizer1", "The crystallizer provides a renewable source of Source Gems by condensing source over time. The Crystallizer can work passively at a very slow rate, or it may be given source from adjacent jars and create Source Gems as a much faster rate. The Crystallizer may also be accessed by Hoppers and Starbuncles.");
        add("tooltip.source_gem", "Obtained by placing lapis or amethyst in an Imbuement Chamber.");
        add("tooltip.magebloom", "Crafted using the Enchanting Apparatus");
        add("ars_nouveau.alert.turret_type", "Selected form cannot be used by a turret.");
        add("ars_nouveau.alert.spell_set", "Spell set.");
        add("ars_nouveau.alert.duplicate_method", "No duplicate cast methods are allowed.");
        add("ars_nouveau.relay.no_to", "No send location set.");
        add("ars_nouveau.relay.one_to", "Sending to %d location(s).");
        add("ars_nouveau.relay.no_from", "No take location set.");
        add("ars_nouveau.relay.one_from", "Taking from %d location(s).");
        add("ars_nouveau.rune.touch", "Runes must have Touch as their first glyph.");
        add("ars_nouveau.bookwyrm.strict_mode", "Strict mode set to %s");
        add("item.ars_nouveau.allow_scroll", "Item Scroll: Allow");
        add("item.ars_nouveau.deny_scroll", "Item Scroll: Deny");
        add("item.ars_nouveau.wixie_shards", "Wixie Shards");
        add("item.ars_nouveau.wixie_charm", "Wixie Charm");
        add("block.ars_nouveau.wixie_cauldron", "Wixie Cauldron");
        add("ars_nouveau.rune.error", "Rune threw an error. Please report this! Bye rune!");
        add("item.ars_nouveau.blank_parchment", "Blank Parchment");
        add("ars_nouveau.scribe.item_added", "Item added.");
        add("ars_nouveau.scribe.item_removed", "Item removed.");
        add("ars_nouveau.allow_set", "Starbuncle will only take these items.");
        add("ars_nouveau.ignore_set", "Starbuncle will ignore these items.");
        add("block.ars_nouveau.lava_lily", "Lava Lily");
        add("block.ars_nouveau.volcanic_sourcelink", "Volcanic Sourcelink");
        add("ars_nouveau.spell.disabled", "This spell has been disabled in the config.");
        add("block.ars_nouveau.sourceberry_bush", "Sourceberry");
        add("ars_nouveau.connections.cleared", "Connections cleared.");
        add("ars_nouveau.connections.take", "Relay set to take from %s");
        add("ars_nouveau.connections.send", "Relay set to send to %s");
        add("item.minecraft.splash_potion.effect.mana_regen_potion_strong", "Splash Potion of Mana Regeneration");
        add("item.minecraft.splash_potion.effect.mana_regen_potion", "Splash Potion of Mana Regeneration");
        add("item.minecraft.splash_potion.effect.mana_regen_potion_long", "Splash Potion of Mana Regeneration");
        add("item.minecraft.potion.effect.mana_regen_potion_strong", "Potion of Mana Regeneration");
        add("item.minecraft.potion.effect.mana_regen_potion", "Potion of Mana Regeneration");
        add("item.minecraft.potion.effect.mana_regen_potion_long", "Potion of Mana Regeneration");
        add("item.minecraft.lingering_potion.effect.mana_regen_potion_strong", "Lingering Potion of Mana Regeneration");
        add("item.minecraft.lingering_potion.effect.mana_regen_potion", "Lingering Potion of Mana Regeneration");
        add("item.minecraft.lingering_potion.effect.mana_regen_potion_long", "Lingering Potion of Mana Regeneration");
        add("item.minecraft.tipped_arrow.effect.mana_regen_potion_strong", "Arrow of Mana Regeneration");
        add("item.minecraft.tipped_arrow.effect.mana_regen_potion", "Arrow of Mana Regeneration");
        add("item.minecraft.tipped_arrow.effect.mana_regen_potion_long", "Arrow of Mana Regeneration");
        add("effect.ars_nouveau.mana_regen", "Mana Regeneration");
        add("ars_nouveau.on", "Active: Yes");
        add("ars_nouveau.off", "Active: No");
        add("item.ars_nouveau.void_jar", "Jar of Voiding");
        add("ars_nouveau.rune.setperm", "This rune is now permanent.");
        add("ars_nouveau.page.void_jar", "A jar that can destroy items on pickup and grants a small amount of mana in return. To turn the jar on and off, use the jar while sneaking. To add or remove an item to be destroyed by the jar, use the jar with an item in the off hand, or use an item on the Scribes Table with the jar placed on it. The jar must be in your hotbar to function.");
        add("ars_nouveau.page.runic_chalk", "Runic chalk can be used to place permanent Runes on the ground that will cast spells on entities that walk over them. To give a rune a spell, inscribe spell parchment using the scribes table. Once the rune has cast the spell, it will become uncharged. An uncharged rune will charge itself from nearby source jars. Using Runic Chalk on a temporary rune will convert it to a permanent one.");
        add("ars_nouveau.wand.invalid", "Invalid spell. Wands accept Effects and Augments only.");
        add("item.ars_nouveau.wand", "Enchanter's Wand");
        add("ars_nouveau.wixie.has_wixie", "This cauldron already has a wixie.");
        add("ars_nouveau.wixie.no_recipe", "No recipes found.");
        add("ars_nouveau.wixie.recipe_set", "Recipe set.");
        add("tooltip.wixie_shard", "Obtained by using Dispel on a witch while it is less than half health.");
        add("tooltip.starbuncle_shard", "Obtained by giving a wild Starbuncle a Gold Nugget.");
        add("tooltip.whirlisprig_shard", "Obtained by growing a tree near a wild Whirlisprig.");
        add("entity.ars_nouveau.wixie", "Wixie");
        add("block.ars_nouveau.creative_source_jar", "Creative Source Jar");
        add("block.ars_nouveau.purple_archwood_log", "Vexing Archwood Log");
        add("block.ars_nouveau.blue_archwood_log", "Cascading Archwood Log");
        add("block.ars_nouveau.green_archwood_log", "Flourishing Archwood Log");
        add("block.ars_nouveau.red_archwood_log", "Blazing Archwood Log");
        add("block.ars_nouveau.purple_archwood_sapling", "Vexing Archwood Sapling");
        add("block.ars_nouveau.blue_archwood_sapling", "Cascading Archwood Sapling");
        add("block.ars_nouveau.green_archwood_sapling", "Flourishing Archwood Sapling");
        add("block.ars_nouveau.red_archwood_sapling", "Blazing Archwood Sapling");
        add("block.ars_nouveau.purple_archwood_leaves", "Vexing Archwood Leaves");
        add("block.ars_nouveau.blue_archwood_leaves", "Cascading Archwood Leaves");
        add("block.ars_nouveau.green_archwood_leaves", "Flourishing Archwood Leaves");
        add("block.ars_nouveau.red_archwood_leaves", "Blazing Archwood Leaves");
        add("block.ars_nouveau.archwood_planks", "Archwood Planks");
        add("ars_nouveau.page.wand", "Wands accept only a single spell, and are inscribed using the Scribes Table. A Wand always starts with Projectile -> Accelerate, and MUST be inscribed with a spell that does not have another method. This allows you to cast spells beyond the 10 spell cap. If you want a wand that casts Break, inscribe the wand with JUST break, and your result will be a wand with Projectile -> Acclerate -> Break.");
        add("ars_nouveau.starbuncle.cleared", "Tasks cleared.");
        add("block.ars_nouveau.red_archwood_wood", "Blazing Archwood Wood");
        add("block.ars_nouveau.green_archwood_wood", "Flourishing Archwood Wood");
        add("block.ars_nouveau.purple_archwood_wood", "Vexing Archwood Wood");
        add("block.ars_nouveau.blue_archwood_wood", "Cascading Archwood Wood");
        add("ars_nouveau.connections.fail", "Too far away.");
        add("block.ars_nouveau.archwood_slab", "Archwood Slab");
        add("block.ars_nouveau.archwood_fence", "Archwood Fence");
        add("block.ars_nouveau.archwood_fence_gate", "Archwood Fence Gate");
        add("block.ars_nouveau.archwood_trapdoor", "Archwood Trapdoor");
        add("block.ars_nouveau.archwood_pressure_plate", "Archwood Pressure Plate");
        add("block.ars_nouveau.archwood_door", "Archwood Door");
        add("block.ars_nouveau.stripped_blue_archwood_log", "Stripped Cascading Archwood Log");
        add("block.ars_nouveau.stripped_blue_archwood_wood", "Stripped Cascading Archwood Wood");
        add("block.ars_nouveau.stripped_red_archwood_log", "Stripped Blazing Archwood Log");
        add("block.ars_nouveau.stripped_red_archwood_wood", "Stripped Blazing Archwood Wood");
        add("block.ars_nouveau.stripped_green_archwood_log", "Stripped Flourishing Archwood Log");
        add("block.ars_nouveau.stripped_green_archwood_wood", "Stripped Flourishing Archwood Wood");
        add("block.ars_nouveau.stripped_purple_archwood_log", "Stripped Vexing Archwood Log");
        add("block.ars_nouveau.stripped_purple_archwood_wood", "Stripped Vexing Archwood Wood");
        add("block.ars_nouveau.archwood_stairs", "Archwood Stairs");
        add("block.ars_nouveau.archwood_button", "Archwood Button");
        add("block.ars_nouveau.source_gem_block", "Source Gem Block");
        add("item.ars_nouveau.spell_bow", "Enchanter's Bow");
        add("item.ars_nouveau.split_arrow", "Augment Arrow: Split");
        add("item.ars_nouveau.amplify_arrow", "Augment Arrow: Amplify");
        add("item.ars_nouveau.pierce_arrow", "Augment Arrow: Pierce");
        add("ars_nouveau.page1.spell_bow", "A bow that can be inscribed with a spell using the Scribes Table. If the player has enough mana, arrows will become Spell Arrows and will apply the spell on their target. If no arrows are in the inventory, a spell arrow that deals 0 damage will be cast. If there is not enough mana, regular arrows will be fired. Enchanter's Bows may use special Augment Arrows for empowering the inscribed spell.");
        add("ars_nouveau.page.amplify_arrow", "Adds two amplifies to the end of the inscribed spell when used. Each recipe makes 32.");
        add("ars_nouveau.page.pierce_arrow", "Adds two pierce to the beginning of the chain. Each recipe makes 32.");
        add("ars_nouveau.page.split_arrow", "Adds two split to the beginning of the chain. If a spell arrow will deal damage, each split arrow will as well. Each recipe makes 32.");
        add("ars_nouveau.bow.invalid", "This tool may only accept spells that do not contain a form.");
        add("ars_nouveau.norecipe", "No recipe found.");
        add("ars_nouveau.apparatus.nomana", "Not enough source nearby.");
        add("ars_nouveau.reset.cleared", "Progress cleared.");
        add("effect.ars_nouveau.summoning_sickness", "Summoning Sickness");
        add("entity.ars_nouveau.wilden_guardian", "Wilden Defender");
        add("entity.ars_nouveau.wilden_stalker", "Wilden Stalker");
        add("entity.ars_nouveau.wilden_hunter", "Wilden Hunter");
        add("item.ars_nouveau.wilden_spike", "Wilden Spike");
        add("item.ars_nouveau.wilden_horn", "Wilden Horn");
        add("item.ars_nouveau.wilden_wing", "Wilden Wing");
        add("tooltip.wilden_spike", "Drops from Wilden Defenders, found in Wilden Dens in cold biomes, or by using a Tablet of Summon Wilden.");
        add("tooltip.wilden_wing", "Drops from Wilden Stalkers found in Wilden Dens, or by using a Tablet of Summon Wilden.");
        add("tooltip.wilden_horn", "Drops from Wilden Pack Hunters found in Wilden Dens, or by using a Tablet of Summon Wilden.");
        add("entity.ars_nouveau.summon_wolf", "Summoned Wolf");
        add("tooltip.worn_notebook", "Documentation for Ars Nouveau");
        add("effect.ars_nouveau.shocked", "Shocked");
        add("ars_nouveau.flask.charges", "Charges: %d");
        add("item.ars_nouveau.potion_flask", "Potion Flask");
        add("ars_nouveau.glyph_of", "Glyph of %s");
        add("ars_nouveau.thread_of", "Thread of %s");
        add("ars_nouveau.book.name", "Worn Notebook");
        add("ars_nouveau.book.landing_text", "Ars Nouveau provides spell crafting, magical devices, powerful trinkets, and magical entity automation. To help  development or report issues, join the community: https://discord.gg/y7TMXZu Thank you for playing.");
        add("ars_nouveau.spell_tier.1", "ONE");
        add("ars_nouveau.spell_tier.2", "TWO");
        add("ars_nouveau.spell_tier.3", "THREE");
        add("ars_nouveau.mana_cost.none", "None");
        add("ars_nouveau.mana_cost.low", "Low");
        add("ars_nouveau.mana_cost.medium", "Medium");
        add("ars_nouveau.mana_cost.high", "High");
        add("ars_nouveau.spell_book.copied", "Copied %d new glyphs to the book.");
        add("ars_nouveau.spell_book.create_mode", "Create Mode");
        add("ars_nouveau.spell_book.select", "Press %s to quick select");
        add("ars_nouveau.spell_book.craft", "Press %s to quick craft");
        add("ars_nouveau.spell_book_gui.spell_name", "Spell Name");
        add("ars_nouveau.spell_book_gui.search", "Search");
        add("ars_nouveau.spell_book_gui.form", "Form");
        add("ars_nouveau.spell_book_gui.effect", "Effect");
        add("ars_nouveau.spell_book_gui.augment", "Augment");
        add("ars_nouveau.spell_book_gui.create", "Create");
        add("ars_nouveau.spell_book_gui.clear", "Clear");
        add("ars_nouveau.color_gui.red_slider", "Red: ");
        add("ars_nouveau.color_gui.green_slider", "Green: ");
        add("ars_nouveau.color_gui.blue_slider", "Blue: ");
        add("ars_nouveau.color_gui.title", "Spell Color");
        add("ars_nouveau.color_gui.presets", "Presets");
        add("ars_nouveau.color_gui.default", "Default");
        add("ars_nouveau.color_gui.purple", "Purple");
        add("ars_nouveau.color_gui.blue", "Blue");
        add("ars_nouveau.color_gui.red", "Red");
        add("ars_nouveau.color_gui.green", "Green");
        add("ars_nouveau.color_gui.yellow", "Yellow");
        add("ars_nouveau.color_gui.white", "White");
        add("ars_nouveau.color_gui.orange", "Orange");
        add("ars_nouveau.color_gui.cyan", "Cyan");
        add("ars_nouveau.color_gui.save", "Save");
        add("ars_nouveau.dominion_wand.stored_entity", "Stored entity");
        add("ars_nouveau.dominion_wand.position_set", "Position set.");
        add("ars_nouveau.dominion_wand.no_entity", "No entity set");
        add("ars_nouveau.dominion_wand.entity_stored", "Entity stored.");
        add("ars_nouveau.dominion_wand.no_location", "No location set.");
        add("ars_nouveau.dominion_wand.position_stored", "Stored: %s");
        add("ars_nouveau.position", "X: %1$d Y: %2$d Z: %3$d");
        add("ars_nouveau.spell_arrow.desc", "Augments spells when used with an Enchanter's Bow.");
        add("ars_nouveau.spell_parchment.no_spell", "Set your spell book to a spell.");
        add("ars_nouveau.spell_parchment.inscribed", "Spell inscribed.");
        add("ars_nouveau.warp_scroll.wrong_dim", "Using this scroll from a different dimension would be a bad idea.");
        add("ars_nouveau.warp_scroll.inv_full", "There is no room in your inventory.");
        add("ars_nouveau.warp_scroll.recorded", "You record your location to your Warp Scroll.");
        add("ars_nouveau.warp_scroll.no_location", "Use while sneaking to set a location.");
        add("ars_nouveau.wand.spell_invalid", "Invalid Spell.");
        add("ars_nouveau.starbuncle.store", "Starbuncle will store items here.");
        add("ars_nouveau.starbuncle.take", "Starbuncle take from this inventory.");
        add("ars_nouveau.starbuncle.whitelist", "Whitelisted: ");
        add("ars_nouveau.starbuncle.blacklist", "Ignoring: ");
        add("ars_nouveau.starbuncle.storing", "Storing items at %d locations");
        add("ars_nouveau.starbuncle.taking", "Taking items from %d locations");
        add("ars_nouveau.whirlisprig.ignore", "Whirlisprig will ignore these items");
        add("ars_nouveau.whirlisprig.ignore_list", "Ignoring: ");
        add("ars_nouveau.whirlisprig.tooltip_extremely_happy", "Extremely happy");
        add("ars_nouveau.whirlisprig.tooltip_very_happy", "Very happy");
        add("ars_nouveau.whirlisprig.tooltip_happy", "Happy");
        add("ars_nouveau.whirlisprig.tooltip_content", "Content");
        add("ars_nouveau.whirlisprig.tooltip_unhappy", "Very unhappy");
        add("ars_nouveau.whirlisprig.tooltip_mood", "Mood: ");
        add("ars_nouveau.source_jar.fullness", "%d%% full");
        add("ars_nouveau.spell_turret.casting", "Casting: ");
        add("ars_nouveau.wixie.crafting", "Crafting: ");
        add("ars_nouveau.wixie.need_mana", "Source needed.");
        add("ars_nouveau.wixie.needs", "Needs: ");
        add("ars_nouveau.wixie.needs_storage", "Needs: Storage for potion.");
        add("ars_nouveau.true", "true");
        add("ars_nouveau.false", "false");
        add("ars_nouveau.spell_hud.crafting_mode", "Crafting Mode");
        add("ars_nouveau.spell.validation.crafting.invalid", "There are problems with this spell.");
        add("ars_nouveau.spell.validation.crafting.invalid_glyphs", "One or more glyphs in this spell are invalid.");
        add("ars_nouveau.spell.validation.exists._comment", "__ These messages appear when reporting on an existing spell that is invalid. __");
        add("ars_nouveau.spell.validation.exists.non_empty_spell", "The spell may not be empty.");
        add("ars_nouveau.spell.validation.exists.max_one_cast_method", "The spell has an extra form glyph: %s");
        add("ars_nouveau.spell.validation.exists.starting_cast_method", "The spell does not start with a form glyph.");
        add("ars_nouveau.spell.validation.exists.action_augmentation_policy", "%s was augmented by %s too many times.");
        add("ars_nouveau.spell.validation.exists.action_augmentation_policy.zero", "%s may not be augmented by %s.");
        add("ars_nouveau.spell.validation.exists.glyph_occurrences_policy", "%s appears too many times.");
        add("ars_nouveau.spell.validation.exists.augment_compatibility", "%s cannot be augmented by %s");
        add("ars_nouveau.spell.validation.exists.glyph_tier", "%s is too powerful for your current spell book.");
        add("ars_nouveau.spell.validation.exists.invalid_combination_policy", "%s cannot be used with %s");
        add("ars_nouveau.spell.validation.adding._comment", "__ These messages appear when attempting to add a glyph that would make a spell invalid. __");
        add("ars_nouveau.spell.validation.adding.non_empty_spell", "The spell may not be empty.");
        add("ars_nouveau.spell.validation.adding.max_one_cast_method", "The spell already has a form glyph.");
        add("ars_nouveau.spell.validation.adding.starting_cast_method", "The spell must start with a form glyph.");
        add("ars_nouveau.spell.validation.adding.action_augmentation_policy", "%s is already augmented to the limit by %s.");
        add("ars_nouveau.spell.validation.adding.action_augmentation_policy.zero", "%s may not be augmented by %s.");
        add("ars_nouveau.spell.validation.adding.glyph_occurrences_policy", "%s has appeared its maximum number of times.");
        add("ars_nouveau.spell.validation.adding.augment_compatibility", "%s cannot be augmented by %s");
        add("ars_nouveau.spell.validation.adding.invalid_combination_policy", "%s cannot be used with %s");
        add("ars_nouveau.spell.validation.adding.glyph_tier", "%s is too powerful for your current spell book.");
        add("ars_nouveau.spell.no_mana", "Not enough Mana.");
        add("block.ars_nouveau.potion_jar", "Potion Jar");
        add("block.ars_nouveau.potion_melder", "Potion Melder");
        add("item.ars_nouveau.potion_flask_extend_time", "Enchanted Potion Flask: Extend Time");
        add("item.ars_nouveau.potion_flask_amplify", "Enchanted Potion Flask: Amplify");
        add("tooltip.potion_flask_extend_time", "Increases the duration of potions by 50%.");
        add("tooltip.potion_flask_amplify", "Increases the level of potions, but reduces their duration.");
        add("tooltip.potion_flask", "Holds 8 charges of potion.");
        add("tooltip.discount_item", "Reduce the cost of all spells by %d.");
        add("ars_nouveau.locked", "Locked");
        add("ars_nouveau.unlocked", "Unlocked");
        add("ars_nouveau.page5.wixie_charm", "Wixies will autocraft potions using nearby Potion Jars and items. Potions that require Water will be supplied by the Wixie. Potions that require another potion as a base will be taken from nearby Potion Jars. A Wixie will output 3 doses of a Potion into a nearby Potion Jar when complete. To begin, place down an empty Potion Jar, right click the cauldron with an Awkward Potion, and supply Nether Wart from a nearby chest.");
        add("ars_nouveau.page6.wixie_charm", "When using multiple Wixies, you may wish to lock a jar to a specific potion. Wixies will only output potion to jars that contain the same potion, or an unlocked empty potion. Each craft costs Source. See the section on the Potion Jar for more information.");
        add("entity.ars_nouveau.summon_horse", "Summoned Horse");
        add("block.ars_nouveau.sconce", "Magelight Sconce");
        add("block.ars_nouveau.ritual_brazier", "Ritual Brazier");
        add("ars_nouveau.tooltip.consumed", "Items Consumed:");
        add("ars_nouveau.tooltip.waiting", "Awaiting Activation");
        add("ars_nouveau.tooltip.running", "Running");
        add("ars_nouveau.tooltip.conditions_unmet", "Conditions Unmet");
        add("ars_nouveau.tooltip.exp_gem", "Grants experience on use. Sneak to consume the entire stack.");
        add("item.ars_nouveau.experience_gem", "Experience Gem");
        add("item.ars_nouveau.greater_experience_gem", "Greater Experience Gem");
        add("effect.ars_nouveau.hex", "Hex");
        add("ars_nouveau.set_spell", "Set spell.");
        add("ars_nouveau.invalid_spell", "Invalid Spell");
        add("effect.ars_nouveau.scrying", "Scrying");
        add("ars_nouveau.tooltip.magebloom", "Grown from seeds crafted using the Enchanting Apparatus.");
        add("ars_nouveau.tooltip.dull", "A dull trinket, cannot be worn. Used for crafting.");
        add("ars_nouveau.sword.invalid", "Invalid spell. Swords accept Effects and Augments only, such as Freeze -> Extend Time.");
        add("item.ars_nouveau.enchanters_sword", "Enchanter's Sword");
        add("item.ars_nouveau.enchanters_shield", "Enchanter's Shield");
        add("ars_nouveau.page.enchanters_sword", "Applies a Touch spell before damaging an entity. Additionally, all spells gain one additional Amplify augment on the last effect in the spell. Apply a spell at the Scribes Table that does NOT contain a form, such as Ignite -> Extend Time.");
        add("ars_nouveau.page.enchanters_shield", "Upon blocking damage, the user will gain a short duration of Mana Regeneration and Spell Damage. Additionally, this shield will repair over time using the wearers mana.");
        add("ars_nouveau.tooltip.can_inscribe", "Can be inscribed with a spell at the Scribes Table.");
        add("biome.ars_nouveau.archwood_forest", "Archwood Forest");
        add("ars_nouveau.tooltip.turned_off", "Turned off");
        add("effect.ars_nouveau.glide", "Glide");
        add("effect.ars_nouveau.snared", "Snared");
        add("item.ars_nouveau.starbuncle_se", "Starbuncle Spawn Egg");
        add("item.ars_nouveau.drygmy_se", "Drygmy Spawn Egg");
        add("item.ars_nouveau.whirlisprig_se", "Whirlisprig Spawn Egg");
        add("item.ars_nouveau.wilden_hunter_se", "Wilden Hunter Spawn Egg");
        add("item.ars_nouveau.wilden_guardian_se", "Wilden Guardian Spawn Egg");
        add("item.ars_nouveau.wilden_stalker_se", "Wilden Stalker Spawn Egg");
        add("tooltip.ars_nouveau.caster_tome", "Casts a spell at half the cost or the users entire mana bar, whichever is smaller.");
        add("item.ars_nouveau.caster_tome", "Caster Tome");
        add("tooltip.ars_nouveau.glyph_disabled", "Disabled. Cannot be used.");
        add("tooltip.ars_nouveau.glyph_level", "A tier %s glyph.");
        add("tooltip.ars_nouveau.caster_level", "Can cast tier %s glyphs or lower.");
        add("tooltip.ars_nouveau.hold_shift", "Hold %s for more info.");
        add("item.ars_nouveau.drygmy_shard", "Drygmy Shards");
        add("item.ars_nouveau.drygmy_charm", "Drygmy Charm");
        add("block.ars_nouveau.drygmy_stone", "Drygmy Henge");
        add("tooltip.ars_nouveau.drygmy_shard", "Obtained by giving a Drygmy a Wilden Horn.");
        add("entity.ars_nouveau.drygmy", "Drygmy");
        add("effect.ars_nouveau.flight", "Flight");
        add("effect.ars_nouveau.gravity", "Gravity");
        add("tooltip.ars_nouveau.tablet", "A tablet used for rituals. Consumed on use.");
        add("ars_nouveau.enchanting.bad_level", "This item must have the previous level of enchantment.");
        add("ars_nouveau.enchanting.incompatible", "This enchantment is incompatible with this item.");
        add("entity.ars_nouveau.wilden_boss", "Wilden Chimera");
        add("ars_nouveau.chimera.rage", "The chimera begins raging.");
        add("entity.ars_nouveau.spike", "Chimera Spike");
        add("tooltip.ars_nouveau.wilden_tribute", "Obtained by defeating the Wilden Chimera. See Ritual of Summon Wilden.");
        add("item.ars_nouveau.wilden_tribute", "Wilden Tribute");
        add("item.ars_nouveau.mimic_scroll", "Mimic Scroll");
        add("tooltip.ars_nouveau.spell_damage", "Spell Damage: %s");
        add("tooltip.ars_nouveau.duration_modifier", "Duration Modifier: %s");
        add("tooltip.ars_nouveau.amp_modifier", "Amplification Modifier: %s");
        add("item.ars_nouveau.summon_focus", "Focus of Summoning");
        add("tooltip.ars_nouveau.summon_focus", "Increases the duration and power of your summons.");
        add("curios.identifier.an_focus", "Spell Focus");
        add("ars_nouveau.school.manipulation", "Manipulation");
        add("ars_nouveau.school.abjuration", "Abjuration");
        add("ars_nouveau.school.conjuration", "Conjuration");
        add("ars_nouveau.school.air", "Elemental Air");
        add("ars_nouveau.school.earth", "Elemental Earth");
        add("ars_nouveau.school.fire", "Elemental Fire");
        add("ars_nouveau.school.water", "Elemental Water");
        add("ars_nouveau.spell_set", "Spell set.");
        add("block.ars_nouveau.vitalic_sourcelink", "Vitalic Sourcelink");
        add("block.ars_nouveau.alchemical_sourcelink", "Alchemical Sourcelink");
        add("ars_nouveau.page1.armor", "Magical robes will increase the wearers mana regen and can be upgraded with special abilities using Threads. The Sorceror's set provides the lowest defence, but provides the most powerful set of slots for Threads. The Arcanist's and Battlemage's sets provide increasingly more defence, but fewer and less powerful Thread Slots. For more information on Threads, see the section on Armor and Perks.");
        add("ars_nouveau.page.potion_jar", "A jar that stores up to 100 potions. Potion can be removed by using an Empty Bottle, Potion Flask, or Arrows on the jar. Wixies will use these jars during Potion Autocrafting. The jar may be locked by using a Dominion Wand while sneaking. Locked Jars will only receive the potion it is locked to from Wixies. Can be used with a Comparator.");
        add("ars_nouveau.glyph_crafting", "Glyph Crafting");
        add("ars_nouveau.page1.scribes_table", "To craft new glyphs, use a spell book on the table to open the codex. Each glyph requires a set of items and experience points to unlock. Select a glyph by clicking on it in the menu, and hit select. Throw the items onto the table as rendered above, and the table will scribe a new glyph. The table will also pull items from nearby inventories. Using the dominion wand on the table will disable auto-pull.");
        add("ars_nouveau.page2.scribes_table", "You may also inscribe a spell onto Spell Parchment or Enchanters Items. To do this, place a Blank Parchment on the table. Then, with your spell book in hand, change your spell book to your desired spell as if you were going to cast it. Then, use the book on the table while sneaking. Your item will now contain that spell. Using Manipulation Essence will permanently hide the scribed spell.");
        add("ars_nouveau.page1.lava_lily", "A decorative block that can be placed on any liquid or block. The texture of this block varies if it is placed on Lava, a Magma Block, or any other block.");
        add("ars_nouveau.page1.wilden", "Wilden are hostile creatures that can be commonly found at night around Wilden Dens. While Wilden Defenders may only be found in cold biomes, Stalker and Hunter Dens can be found in any forest biome.");
        add("ars_nouveau.page3.wilden", "An aggressive and fast hunter that can summon allied wolves.");
        add("ars_nouveau.page4.wilden", "Generally spawning in small groups, Stalkers have ground and aerial attacks.");
        add("ars_nouveau.page5.wilden", "Found in cold biomes, a Defender is a slow moving heavy hitter with a ranged attack.");
        add("ars_nouveau.page6.wilden", "Summoned with a Ritual of Wilden Tribute, the chimera is a powerful and destructive mid-level boss.");
        add("ars_nouveau.page7.wilden", "The Chimera is a worthy fight for a caster with Tier 2 spells and equipment. The Chimera resists cold damage, and a variety of spells including buffs, dispel, and mobility are suggested.");
        add("ars_nouveau.page1.allow_scroll", "Provides a list of items to automation related entities. To inscribe an item, place on the Scribes Table and use blocks and items on the table while sneaking. When given to a Starbuncle, the Starbuncle will only pickup and take items on the scroll.");
        add("ars_nouveau.page1.deny_scroll", "Provides a list of items to automation related entities. To inscribe an item, place on the Scribes Table and use blocks and items on the table while sneaking. When given to a Starbuncle, the Starbuncle will pickup and take any item that is NOT on this scroll.");
        add("ars_nouveau.page1.mimic_scroll", "Provides a list of items to automation related entities. When this scroll is attached to an inventory, entities will only insert items that already exist in the inventory. To attach the scroll, place an item frame on the inventory, and place a Mimic Scroll in it.");
        add("block.ars_nouveau.mycelial_sourcelink", "Mycelial Sourcelink");
        add("item.ars_nouveau.source_berry_pie", "Source Berry Pie");
        add("item.ars_nouveau.source_berry_roll", "Source Berry Roll");
        add("tooltip.ars_nouveau.source_food", "Grants mana regeneration when consumed.");
        add("block.ars_nouveau.relay_warp", "Source Relay: Warper");
        add("block.ars_nouveau.relay_deposit", "Source Relay: Depositor");
        add("ars_nouveau.page.relay_deposit", "Operates similar to the Source Relay, but will deposit to jars it is not linked to within 5 blocks. See the instructions on the Source Relay for use.");
        add("ars_nouveau.page.relay_warp", "Operates similar to the Source Relay: Splitter but can teleport source an endless distance between other Warp relays. For distances beyond 30 blocks, there is a chance that some source will be lost during warp.");
        add("item.minecraft.splash_potion.effect.spell_damage_potion_strong", "Splash Potion of Spell Damage");
        add("item.minecraft.splash_potion.effect.spell_damage_potion", "Splash Potion of Spell Damage");
        add("item.minecraft.splash_potion.effect.spell_damage_potion_long", "Splash Potion of Spell Damage");
        add("item.minecraft.potion.effect.spell_damage_potion_strong", "Potion of Spell Damage");
        add("item.minecraft.potion.effect.spell_damage_potion", "Potion of Spell Damage");
        add("item.minecraft.potion.effect.spell_damage_potion_long", "Potion of Spell Damage");
        add("item.minecraft.lingering_potion.effect.spell_damage_potion_strong", "Lingering Potion of Spell Damage");
        add("item.minecraft.lingering_potion.effect.spell_damage_potion", "Lingering Potion of Spell Damage");
        add("item.minecraft.lingering_potion.effect.spell_damage_potion_long", "Lingering Potion of Spell Damage");
        add("item.minecraft.tipped_arrow.effect.spell_damage_potion_strong", "Arrow of Spell Damage");
        add("item.minecraft.tipped_arrow.effect.spell_damage_potion", "Arrow of Spell Damage");
        add("item.minecraft.tipped_arrow.effect.spell_damage_potion_long", "Arrow of Spell Damage");
        add("effect.ars_nouveau.spell_damage", "Spell Damage");
        add("ars_nouveau.spell_book_gui.familiar", "Familiars");
        add("ars_nouveau.spell_book_gui.close", "Close");
        add("effect.ars_nouveau.familiar_sickness", "Familiar Sickness");
        add("ars_nouveau.familiar.sickness", "You must wait before summoning another familiar.");
        add("ars_nouveau.gui.notebook", "Documentation");
        add("ars_nouveau.gui.color", "Color Picker");
        add("ars_nouveau.gui.familiar", "Familiars");
        add("ars_nouveau.category.familiars", "Familiars can provide passive buffs and assistance in combat. For more information, see the section on Summoning a Familiar.");
        add("ars_nouveau.familiar.owned", "You already own this familiar.");
        add("ars_nouveau.familiar.unlocked", "Familiar unlocked.");
        add("ars_nouveau.familiar.script", "Used for obtaining familiars. Obtained from the Ritual of Binding.");
        add("ars_nouveau.schools", "Schools: ");
        add("entity.ars_nouveau.familiar_bookwyrm", "Bookwyrm Familiar");
        add("entity.ars_nouveau.familiar_starbuncle", "Starbuncle Familiar");
        add("entity.ars_nouveau.familiar_whirlisprig", "Whirlisprig Familiar");
        add("entity.ars_nouveau.familiar_wixie", "Wixie Familiar");
        add("entity.ars_nouveau.familiar_drygmy", "Drygmy Familiar");
        add("entity.ars_nouveau.familiar_amethyst_golem", "Amethyst Golem Familiar");
        add("ars_nouveau.mirror.invalid", "Invalid spell. Mirrors accept Effects and Augments only.");
        add("item.ars_nouveau.enchanters_mirror", "Enchanter's Mirror");
        add("ars_nouveau.page.enchanters_mirror", "Applies a self spell to the user. Spells cast with this mirror are discounted and gain additional bonus duration to all glyphs. Apply a spell at the Scribe's table that DOES NOT contain a form such as Heal -> Heal.");
        add("block.ars_nouveau.bookwyrm_lectern", "Bookwyrm Lectern");
        add("ars_nouveau.seconds", "%s seconds");
        add("block.ars_nouveau.basic_spell_turret", "Basic Spell Turret");
        add("block.ars_nouveau.spell_turret", "Enchanted Spell Turret");
        add("block.ars_nouveau.timer_spell_turret", "Timer Spell Turret");
        add("block.ars_nouveau.rotating_spell_turret", "Adjustable Spell Turret");
        add("effect.ars_nouveau.bounce", "Bounce");
        add("ars_nouveau.starbuncle.path", "Starbuncle will prefer to path on this block if it is on their way.");
        add("ars_nouveau.starbuncle.pathing", "Preferring to path on %s");
        add("ars_nouveau.summoning", "Summoning");
        add("ars_nouveau.item_transport", "Item Transport");
        add("ars_nouveau.filtering", "Filtering");
        add("ars_nouveau.filtering_with", "Filtering with: %s");
        add("ars_nouveau.filter_set", "Filter set.");
        add("ars_nouveau.pathing", "Pathing");
        add("block.ars_nouveau.archwood_chest", "Archwood Chest");
        add("block.ars_nouveau.spell_prism", "Spell Prism");
        add("ars_nouveau.page.spell_prism", "When a projectile spell hits this block, it is redirected the direction the block is facing. Spell Prisms will send a signal to nearby Observers if a spell is redirected.");
        add("ars_nouveau.weald_walker.home", "Guarding: %s");
        add("ars_nouveau.nothing", "Nothing");
        add("ars_nouveau.weald_walker", "Weald Walker");
        add("entity.ars_nouveau.cascading_weald_walker", "Cascading Weald Walker");
        add("entity.ars_nouveau.flourishing_weald_walker", "Flourishing Weald Walker");
        add("entity.ars_nouveau.blazing_weald_walker", "Blazing Weald Walker");
        add("entity.ars_nouveau.vexing_weald_walker", "Vexing Weald Walker");
        add("ars_nouveau.page1.weald_walker", "Weald Walkers are living Archwood Trees that guard their homes against hostile monsters. A Weald Walker can be created from the Ritual of Awakening. When summoned, the Weald Walker will roam randomly unless given a home position. To give the Weald Walker a home, use the dominion wand on the Weald Walker, and then the block you wish it to guard.");
        add("ars_nouveau.page2.weald_walker", "Casts Flare at nearby enemies, careful not to ignite any blocks in the process.");
        add("ars_nouveau.page3.weald_walker", "Casts Freeze and Cold Snap at nearby enemies.");
        add("ars_nouveau.page4.weald_walker", "Casts an amplified Harm with a Snare effect at nearby enemies.");
        add("ars_nouveau.page5.weald_walker", "Casts Hex and an amplified Wither at nearby enemies.");
        add("ars_nouveau.page1.weald_waddler", "If a Weald Walker dies, it will be turned into a Weald Waddler. Weald Waddlers will slowly grow back into Weald Walkers, and can be sped up by giving them bonemeal. A Weald Waddler cannot fight or protect itself until it has grown back to a Walker.");
        add("ars_nouveau.source", "Source: %s");
        add("ars_nouveau.crush_recipe", "Crush Glyph");
        add("ars_nouveau.enchanting_apparatus", "Enchanting Apparatus");
        add("ars_nouveau.armor_upgrade", "Magic Armor Upgrade");
        add("ars_nouveau.page.apparatus_crafting", "Apparatus Crafting");
        add("ars_nouveau.page1.apparatus_crafting", "The Enchanting Apparatus is used for crafting special machines, curios, and equipment used to progress in Ars Nouveau. Crafting with the Enchanting Apparatus requires up to eight Arcane Pedestals, an Arcane Core, and the Enchanting Apparatus block. Once you have setup your apparatus, you should craft your first Magebloom Seed.");
        add("ars_nouveau.page.better_casting", "Better Casting");
        add("ars_nouveau.page1.better_casting", "Your mana pool may be expanded with special mage armors, enchantments, learning new glyphs, or by drinking potions. Once you have acquired a Magebloom Seed, you may craft Novice Robes which will expand your casting abilities significantly. These robes will self-repair using your mana pool, have a high enchantability, and provide decent armor.");
        add("ars_nouveau.page.new_glyphs", "New Glyphs");
        add("ars_nouveau.page1.new_glyphs", "Accessing new spells will require a small amount of setup, resources, and base building. New spells can be learned by obtaining Glyphs. Glyphs are created using the Scribe's Table with Experience and items. Once you have obtained a glyph, simply use it to memorize the glyph. See the section on the Scribes Table for more information.");
        add("ars_nouveau.page.source", "Source");
        add("ars_nouveau.page1.source", "Source is a special resource that must be gathered using devices in the world. Source is used for powering devices like the Imbuement Chamber and Enchanting Apparatus. To begin gathering Source, you will need a Source Jar and a Sourcelink.");
        add("ars_nouveau.page.spell_casting", "Spell Casting");
        add("ars_nouveau.page1.spell_casting", "To begin spell casting, you will need to first obtain a Spellbook. A spellbook will allow you to create, store, and cast spells using Mana. A higher tier spell book will provide additional spell slots, allowing you to craft more complex spells. $(br) To craft your first spell, you must first select the $(bold)Form$() that the spell will take on. A $(bold)Form$() glyph must always be the first glyph in a spell recipe.");
        add("ars_nouveau.page2.spell_casting", "Next, add any number of $(bold)Effects$() to the chain. Effects refer to $(italic)what$() the spell will do and they will resolve in the order they are placed in the book at the target or location the spell hits. An $(bold)Augment$() can be used to modify the way an Effect or Form behaves. $(bold)Augments$() may be placed after an Effect or Form. An Augment will only apply to the glyph to the $(bold)left$() of it. Multiple augments may also be applied on the same Effect or Form by chaining Augments together.");
        add("ars_nouveau.page3.spell_casting", "If you would like to set a spell to a different tab, select the tab from the right side and repeat the above process. Several keybindings are provided for using the spellbook. $(br)Open Spellbook: $(k:ars_nouveau.open_book) $(br)Quick Select: $(k:ars_nouveau.selection_hud) $(br)Next Spell: $(k:ars_nouveau.next_slot) $(br)Previous Spell: $(k:ars_nouveau.previous_slot)");
        add("ars_nouveau.page.spell_mana", "Spell Mana");
        add("ars_nouveau.page1.spell_mana", "Spell Mana is used to cast spells with a $(thing)Spellbook$(). The maximum amount of mana, and the speed at which it regenerates, may be increased by wearing special $(item)Mage Armor$() or by applying the $(item)Mana Boost$() or $(item)Mana Regen$() enchantments on your gear. Additionally, you will gain bonus mana and regeneration for each glyph unlocked in your spellbook.");
        add("ars_nouveau.page2.spell_mana", "Adding glyphs to your spell book will also increase your maximum amount of mana and mana regeneration. This bonus also scales with the tier of your spell book.");
        add("ars_nouveau.page.starting_automation", "Starting Automation");
        add("ars_nouveau.page1.starting_automation", "Spells may be used in Automation using Spell Turrets. Use these to create auto harvesters, tree farms, quarries, cake farms, glass factories, and more! For item transport, autocrafting, or resource generation, see the variety of magical entities that may be summoned using Charms.");
        add("ars_nouveau.page.trinkets", "Trinkets");
        add("ars_nouveau.page1.trinkets", "Items and curios can expand your casting and can provide unique buffs. For more casting, you may want to craft a Ring of Discount or an Amulet of Mana Regen. For travel, see the Belt of Levitation, or improve your mining efficiency with the Jar of Voiding.");
        add("ars_nouveau.page.upgrades", "Upgrades");
        add("ars_nouveau.page1.upgrades", "Tier 2 and 3 glyphs will require an Apprentice and Archmage spell book respectively. Higher tier books will allow you to cast higher tier spells, use them in automation, and provide additional mana and mana regeneration as a bonus. Once you are able to upgrade your book, upgrading your armor to the next tier of robes will also grant you another boost in casting.");
        add("ars_nouveau.page.world_generation", "World Generation");
        add("ars_nouveau.page1.world_generation", "Several resources can spawn in the world, each with their own magical properties. Archwood trees come in several decorative variants and may be used to craft Casting Wands. Source Berries, found in Taigas, are essential for crafting Mana Regeneration potions.");
        add("ars_nouveau.page.archwood", "Archwood Trees");
        add("ars_nouveau.page1.archwood", "Archwood Trees have a small chance to spawn in any biome, and come in four types. Rarely, you may stumble upon an Archwood Forest, a biome full of magical creatures, naturally spawning lights, and Archwood trees. Can be used as decoration, rituals, or for crafting wands.");
        add("ars_nouveau.page1.decorative", "Purely decorative blocks. To see the full list, place Arcane Stone in a Stonecutter.");
        add("ars_nouveau.wilden", "Wilden");
        add("ars_nouveau.page.decorative", "Decorative Blocks");
        add("ars_nouveau.page1.magelight_torch", "Decorative lights. To ignite, cast Light on the sconce. The color of the flame corresponds with your spell color. The Magelight Torch on a wall can change the direction of its flames by interacting. Use Touch or Projectile Sensitive to target the sconce.");
        add("ars_nouveau.page1.source_berry", "A Sourceberry Bush can be found in Taiga and Archwood Forest biomes, and produces Sourceberries. A Sourceberry can be used to craft a Potion of Mana Regeneration or consumed as food. Starbuncles will automatically harvest fully grown Source Berry Bushes, making them useful for early automation of the Agronomic Sourcelink. Sourceberry foods will also grant Mana Regeneration.");
        add("ars_nouveau.page.wilden", "Wilden");
        add("ars_nouveau.page.weald_walker", "Weald Walkers");
        add("ars_nouveau.spell_schools", "Spell Schools");
        add("ars_nouveau.casting_cost", "Casting Cost");
        add("ars_nouveau.tier", "Tier %s");
        add("ars_nouveau.page.agronomic_sourcelink", "The Agronomic Sourcelink generates source from crop and tree growth within 15 blocks. Bonus source is generated for magical plants such as Mageblooms, Source Berry Bushes, and Archwood Saplings. Source will be output from the Sourcelink to nearby jars within 5 blocks. Note: Bonemealing crops will not grant Source.");
        add("ars_nouveau.page.source_jar", "Source Jars store source gathered from nearby Sourcelinks. Source is used in glyphs and rituals by powering devices like the Imbuement Chamber and Enchanting Apparatus. Source may be moved using a bucket, or the jar can be picked up and moved. To use Source in a jar, simply place the jar near your desired device. Source Jars will provide a signal to Redstone Comparators based on their fill level.");
        add("ars_nouveau.page1.volcanic_sourcelink", "The Volcanic Sourcelink generates Source by consuming burnable items. Archwood logs will generate bonus Source, with Blazing Archwood generating the most. As the Volcanic Sourcelink produces Source, it also produces $(item)heat$(), used for spawning Lava Lilies and converting stone into lava. The Volcanic Sourcelink automatically outputs to nearby jars, starting with the one closest to it.");
        add("ars_nouveau.page2.volcanic_sourcelink", "Nearby Blazing Archwood items will be burned up in exchange for a chunk of Source and a moderate amount of $(item)heat$(). The Volcanic Sourcelink will also take items from surrounding pedestals.");
        add("ars_nouveau.page3.volcanic_sourcelink", "The Volcanic Sourcelink will occasionally convert Stone into Magma Blocks, and Magma Blocks into Lava, given that these blocks exist beneath it in its 3x3 area. This conversion is dependent on the amount of $(item)heat$() it has produced over time. The Volcanic Sourcelink will also spawn a Lava Lily adjacent to it given that there is nothing covering the lava. Lava Lilys may be harvested and used for decoration.");
        add("ars_nouveau.page4.volcanic_sourcelink", "The color of a Lava Lily changes if it is placed above lava, magma, or other blocks.");
        add("ars_nouveau.active_generation", "Active Generation");
        add("ars_nouveau.heat", "Heat");
        add("ars_nouveau.page.alchemical_sourcelink", "Generates source by consuming potions from adjacent potion jars. The amount of source varies per potion and is dependent on the complexity of the potion. Bonus source is given for the length and level of the potion with multipliers for each effect a potion contains. Utilizing Wixies and Potion Melders is recommended for creating highly complex potions.");
        add("ars_nouveau.page.vitalic_sourcelink", "Generates a moderate amount of source from nearby mob death and animal breeding. Additionally, the Vitalic Sourcelink will generate passive Source from nearby baby animals and will accelerate their growth.");
        add("ars_nouveau.page.mycelial_sourcelink", "Generates a moderate amount of source from nearby food, generating more for more nourishing food. Source Berry food is worth far more than other mundane foods. Additionally, the Mycelial Sourcelink will convert Grass or Dirt in the 3x3 below it into Mycelium and will grow mushrooms around it given that the space is empty. The Sourcelink will also pull items from nearby pedestals.");
        add("block.ars_nouveau.relay", "Source Relay");
        add("block.ars_nouveau.relay_splitter", "Source Relay: Splitter");
        add("block.ars_nouveau.whirlisprig_flower", "Whirlisprig Blossom");
        add("ars_nouveau.page.relay", "Enables the transport of source between Source Jars and other Source Relays. To pull source from jars, use the Dominion Wand on the jar, and then on the relay. To send between relays or from a relay to a jar, use the wand on the relay and then the target you wish to send source to. Relays may only reach up to 30 blocks away. To clear connections, sneak while using the Dominion Wand on the relay.");
        add("ars_nouveau.page.relay_splitter", "Operates similar to the Source Relay, but will support taking from and transferring to multiple jars at once. The splitter has a much larger through-put than the Source Relay, and will split this throughput amongst all of its jars. See the instructions on the Source Relay for use.");
        add("ars_nouveau.page1.enchanting_apparatus", "The Enchanting Apparatus utilizes pedestals and Source for crafting. To use the Enchanting Apparatus, place any number of Arcane Pedestals within 3 blocks with their items. Once you have filled the pedestals, use the middle item on the Enchanting Apparatus block. The Enchanting Apparatus requires an Arcane Core beneath it in order to work.");
        add("ars_nouveau.page1.imbuement_chamber", "Imbues certain items with Source to create new items. The primary way to obtain Source Gems, amethyst and lapis may be used to create Source Gems. The Imbuement Chamber will passively accumulate source for recipes, or will draw from Source Jars 2 block away. Some recipes require additional items placed in pedestals within 1 block of the Imbuement Chamber, such as Essences. Items in pedestals will not be consumed.");
        add("ars_nouveau.page.potion_melder", "Converts three doses of a potion from two Potion Jars and outputs a potion with the combined effects. Use the Dominion Wand from a Potion Jar to Melder to link a jar for consumption. Link two input potion jars to the melder. Then, use the wand on the Melder and then to a third jar to set the output. The Potion Melder requires source per mix.");
        add("ars_nouveau.page.warp_portal", "Warp Portals");
        add("ars_nouveau.page1.warp_portal", "Warp portals, like warp scrolls, provide a one-way teleport to any location, provided it is in the same dimension. To construct a Warp Portal, build a frame from Sourcestone or its variants in the shape of a rectangle and provide a full Source Jar nearby. Then, throw a warp scroll with a written location into the frame. Given there is enough source nearby, the portal will be created.");
        add("ars_nouveau.page2.warp_portal", "Portals can be built horizontal or vertical, from 1x1 to 21x21 in size. Warping does not cost any source after creation. Using a Dominion Wand on the portal will change the texture of the portal.");
        add("ars_nouveau.page3.warp_portal", "Warp Portal");
        add("ars_nouveau.page4.warp_portal", "A magical portal that can send players, mobs, spells, and items to any location in the same dimension.");
        add("ars_nouveau.page.ritual_brazier", "A brazier that may be used as decoration or for performing rituals. To light the brazier for decoration, cast a Light spell on the brazier. The color of the brazier corresponds with the color of the spell. Applying a redstone signal will disable a running ritual. For information on performing rituals, see the dedicated section on rituals.");
        add("ars_nouveau.page1.basic_spell_turret", "Turrets can be used to cast spells when given a redstone signal, functioning like a dispenser. Turrets will accept spells that use Touch and Projectile. Spells may be set using an inscribed piece of Spell Parchment. In order to cast spells, turrets will draw source from nearby Source Jars. Turrets may use Item Pickup and Place Block as long as an inventory is placed adjacent to this block.");
        add("ars_nouveau.page2.basic_spell_turret", "Enchanted Spell Turrets cast spells at half the source cost compared to basic spell turrets.");
        add("ars_nouveau.page3.basic_spell_turret", "Timer Spell Turrets will automatically fire on a timer. Defaulted to 1 second, the time may be increased by right-clicking the block. Punching will decrease the time. Sneaking will allow you to configure it in 10 second intervals. To prevent further changes, lock and unlock the turret using the dominion wand. Setting the turret to 0 seconds or providing a redstone signal will disable it. Casts Projectile, Touch, and Redstone for free.");
        add("ars_nouveau.page4.basic_spell_turret", "Turrets can provide compact and efficient automation. Examples include: configurable redstone clocks, one block tree or crop farms, rapid smelting with fortune, or mob farms with looting.");
        add("ars_nouveau.page1.bookwyrm_charm", "Bookwyrm Charms can be used on a Storage Lectern to increase the number of accessible inventories. Augment a Ritual of Awakening with Book and Quills in order to obtain charms. Bookwyrms can be dyed using white, black, blue, green, red, or purple dye.");
        add("ars_nouveau.page2.bookwyrm_charm", "In the event that they die or are dispelled, they will drop their charm.");
        add("ars_nouveau.page.dominion_wand", "A tool for configuring Source Relays and automation entities. To set a transfer path, use the wand on the object that you would like to take source from, and then use it on the block you would like to send source to. For example: Source Jar to Source Relay, Source Relay to Source Relay, or Source Relay to Source Jar. To clear connections, sneak and use this wand on a relay.");
        add("ars_nouveau.page1.drygmy_charm", "Drygmys are often found following and tending to animals around it. They can be found anywhere, though somewhat rarely. Drygmys can be given a home in the world, and will produce items from nearby monsters and animals as if they were slain, without harming them. A wild drygmy may be befriended by throwing a Wilden Horn near it! You may dye a Drygmy Cyan, Orange, or Brown.");
        add("ars_nouveau.page2.drygmy_charm", "A Drygmy can also produce experience gems!");
        add("ars_nouveau.page3.drygmy_charm", "To summon a Drygmy, use a Drymy Charm on a block of Mossy Cobblestone. After a short time, the cobblestone will transform into a Drygmy Henge and summon your Drgymy! To summon additional drygmys, use more charms on the henge. Casting dispel or killing the Drygmy will return your charm.");
        add("ars_nouveau.page4.drygmy_charm", "A Drygmy considers its home to be 10 blocks in every direction from its home. The drygmy will use this area to produce items from any entities nearby. Your drgymy's efficiency is dependent on its happiness. This may be increased for each entity nearby, with a bonus for each unique type in its home. Nearby Containment Jars will also count as an entity.");
        add("ars_nouveau.page5.drygmy_charm", "Each Drygmy working around a henge contributes progress. Once maximum progress has been reached, the henge will generate items and experience gems and deposit them into adjacent chests. Each time this occurs, the henge will require Source to recharge. The number of drops and experience gems is equal to the Drygmy happiness and experience value of the entities. To get started, place a chest and jar of Source next to the Henge.");
        add("ars_nouveau.happiness", "Happiness");
        add("ars_nouveau.production", "Production");
        add("ars_nouveau.important", "Important");
        add("ars_nouveau.page1.starbuncle_charm", "Starbuncles naturally appear in wooded areas in search of golden nuggets. While Starbuncles are normally afraid of humans, they will allow someone to approach if they are holding a gold nugget. When a Starbuncle has picked up a golden nugget, it will vanish from this world and leave behind Starbuncle Shards.");
        add("ars_nouveau.page2.starbuncle_charm", "While wild Starbuncles cannot be tamed, their shards may be used to summon a Starbuncle.");
        add("ars_nouveau.page3.starbuncle_charm", "To summon a Starbuncle, use a Starbuncle charm on the ground. Summoned Starbuncles will pickup nearby items and can move items between inventories such as chests. Starbuncles will harvest fully grown Source Berry bushes around it. A Starbuncle will drop its charm when Dispelled or when killed. You may dye them any color.");
        add("ars_nouveau.page4.starbuncle_charm", "To bind a Starbuncle to place items into a chest, use the dominion wand on the Starbuncle and then the inventory. To take items from an inventory, use the wand on the inventory and then the Starbuncle. Starbuncles will move items between as many inventories as you desire. Looking at a Starbuncle will tell you how many chests are being taken from, and input to. Using the Dominion Wand on a Starbuncle while sneaking will reset them.");
        add("ars_nouveau.page5.starbuncle_charm", "You may dictate where items go and may be picked up by using Item Scrolls or Item Frames. A Starbuncle may be given an Item Scroll: Allow or Deny, and will only pickup and move items respecting that filter. Alternatively, you may place an Item Frame on the inventory a Starbuncle is interacting with. You may either place an Item Scroll or a single item directly on the frame. Starbuncle interacting with that inventory will respect item framed filters.");
        add("ars_nouveau.page6.starbuncle_charm", "Using a block on a Starbuncle will set them to prefer that block for pathing between areas, as long as it is on the way. They will also naturally prefer grass paths.");
        add("ars_nouveau.page7.starbuncle_charm", "Starbuncles may be bound to a Magebloom Bed using the Dominion Wand and will rest on the bed when there are no other tasks to be done. Useful for keeping them out of the way, or returning them to a spot where items drop. Providing a redstone signal to the bed will disable starbuncles and go back to their beds.");
        add("ars_nouveau.starbuncle_bed", "Resting");
        add("ars_nouveau.page1.whirlisprig_charm", "Whirlisprigs are curious nature sprites that are exclusively found in forested areas. Summoned Whirlisprigs can be given a home in the world, and will begin producing natural materials including wood, crops, seeds, and flowers that exist around them. Wild Whirlisprigs can be befriended and will drop Whirlisprig Shards if a tree is grown near them.");
        add("ars_nouveau.page2.whirlisprig_charm", "Whirlisprigs will follow animals, players, and monsters! They will also grow grass around them every once and a while.");
        add("ars_nouveau.page3.whirlisprig_charm", "To summon a Whirlisprig, use a Whirlisprig charm on any flower. Whirlisprigs consider their home to be 10 blocks in any direction from the flower. Whirlisprigs require source nearby to operate, and will only generate items if there is a chest placed next to the flower. You can get your charm back by using Dispel on a Whirlisprig. They may be given orange, yellow, white, or green dye.");
        add("ars_nouveau.page4.whirlisprig_charm", "Summoned Whirlisprigs must be happy in order to produce materials, and their mood is determined by the number and diversity of natural materials in their home. You may use blocks on the Whirlisprig to gain additional info if a Whirlisprig would enjoy that block in their home. Interacting with the Whirlisprig with an empty hand will give you additional info on the Whirlisprig's happiness.");
        add("ars_nouveau.page5.whirlisprig_charm", "Note: It can take several minutes for a Whirlisprig to update its mood after placing a block. Whirlisprigs value diversity, and too much of one block will no longer count.");
        add("ars_nouveau.page6.whirlisprig_charm", "Drop rates are determined by happiness, diversity, and the proportions of blocks in a Whirlisprig home. For example, to generate a lot of logs, grow more trees. To gain more seeds and crop harvests, plant more crops.");
        add("ars_nouveau.page1.wixie_charm", "A Wixie can automatically craft items for you at the expense of source. To obtain a Wixie Shard, cast Dispel on a Witch while it is half health or less. Once you have obtained a Wixie Charm, use it on a Cauldron to summon your Wixie. A Wixie can be dyed Red, White, Black, Blue, or Green.");
        add("ars_nouveau.page2.wixie_charm", "To select an item for crafting, use your item or block on the Wixie Cauldron.");
        add("ars_nouveau.page3.wixie_charm", "The Wixie will select the recipe for crafting based on the inventories nearby, you need not specify the exact materials for the recipe. For example, if you want to craft Sticks, the Wixie will mix and match planks from nearby chests in order to fulfill the recipe. Each craft requires a small amount of source and will be drained from nearby Source Jars. A redstone signal on the cauldron will stop crafting.");
        add("ars_nouveau.page4.wixie_charm", "Wixies can craft multiple items at once by placing pedestals adjacent to the cauldron. Wixie's will attempt to craft items in the pedestal, rotating round robin. Powering the pedestal will disable the wixie from crafting its item.");
        add("ars_nouveau.item_crafting_setting", "Multi-Item Crafting");
        add("ars_nouveau.item_crafting", "Item Crafting");
        add("ars_nouveau.potion_crafting", "Potion Crafting");
        add("ars_nouveau.page.summon_focus", "A special casting focus. Grants summons from spells additional duration, strength, speed, and deals damage to enemies that kill them. Additionally, casting spells that target you like Self and Orbit will cast a copy of the spell on your nearby summons.");
        add("ars_nouveau.page1.potion_flask", "A flask that stores 8 charges of a potion. To fill the flask, use the flask on a Potion Jar, or craft the flask in a Crafting Table with another potion. You may empty the flask by using the flask on a Potion Jar while sneaking.");
        add("ars_nouveau.page2.potion_flask", "An enchanted flask that extends the time of effects by 50%%");
        add("ars_nouveau.page3.potion_flask", "An enchanted flask that increases the power of effects by 1, but reduces their time in half.");
        add("ars_nouveau.page.warp_scroll", "A scroll that may be used a single time to teleport to a recorded location. However, teleporting across dimensions is not possible. Can be used to warp other entities if an inscribed scroll is held in the offhand and the holder casts Blink on an entity.");
        add("ars_nouveau.page.armor", "Magical Armor");
        add("ars_nouveau.page.reactive_enchantment", "Reactive");
        add("ars_nouveau.page.spell_books", "Spell Books");
        add("ars_nouveau.page1.spell_books", "Accessing higher tier spells will require a better spell book. While a novice spell book only has access to Tier 1 spells, the Apprentice and Archmage spell books will unlock tiers two and three. Upgrading your spell book will transfer all of the spells that you have learned into your new book. Books may be dyed by crafting them with a piece of dye.");
        add("ars_nouveau.page.summoning_familiars", "Summoning Familiars");
        add("ars_nouveau.page1.summoning_familiars", "To begin summoning familiars, you will need to obtain a Bound Script of the entity you wish to befriend. These can be obtained by performing the Ritual of Binding near a relevant entity. See the full list of eligible entities in the Familiars section. Once you have obtained a Bound Script, use it to learn the familiar.");
        add("ars_nouveau.page2.summoning_familiars", "Once you have obtained a bound script, you may access your list of familiars from your Spellbook crafting menu in the Familiars section. Selecting a Familiar will summon it in the world and give you Familiar Sickness, preventing you from summoning another one for a short time. To obtain your first familiar, perform the Ritual of Binding near a Starbuncle. Familiars are bound to the player and cannot be transferred between books.");
        add("ars_nouveau.page3.summoning_familiars", "Typically only one familiar may be out at a time, and summoning another familiar will remove others bound to you. You may dismiss your own familiar by casting Dispel on it. In exchange for empowering the owner, familiars will reserve a portion of max mana from their owner for as long as they persist in the world.");
        add("ars_nouveau.page.performing_rituals", "Performing Rituals");
        add("ars_nouveau.page1.performing_rituals", "Performing a ritual requires a Ritual Brazier, and a tablet. Once you have obtained a tablet and brazier, place your brazier in the world and use a tablet on it. The brazier will ignite, and is awaiting activation. In this state, you may throw in any additional items as a way to augment the ritual. If you wish to augment a ritual, simply toss the item on top of the brazier.");
        add("ars_nouveau.page2.performing_rituals", "To activate your ritual, interact with the brazier with an empty hand. Once activated, your ritual can no longer be augmented and has been consumed permanently. If a ritual requires source to operate, the brazier will pull from source jars within 6 blocks. Information related to rituals and their requirements can be found in their respective entries.");
        add("ars_nouveau.automation", "Automation");
        add("ars_nouveau.automation_desc", "Magical Automation");
        add("ars_nouveau.enchanting", "Enchanting");
        add("ars_nouveau.enchanting_desc", "Once you have acquired a jar of Source and an Enchanting Apparatus, you may begin enchanting items. For more information, see the section on the Enchanting Apparatus.");
        add("ars_nouveau.equipment", "Magical Equipment");
        add("ars_nouveau.equipment_desc", "Magical Equipment");
        add("ars_nouveau.familiars", "Familiars");
        add("ars_nouveau.familiars_desc", "Familiars may be summoned to provide passive buffs for spell casting, passive buffs, and more.");
        add("ars_nouveau.getting_started", "Getting Started");
        add("ars_nouveau.getting_started_desc", "An introduction to Ars Nouveau. It is recommended to follow each section in order.");
        add("ars_nouveau.tier_1_spells", "Tier 1 Glyphs");
        add("ars_nouveau.tier_1_spells_desc", "Glyphs that may be cast using a Novice Spellbook.");
        add("ars_nouveau.tier_2_spells", "Tier 2 Glyphs");
        add("ars_nouveau.tier_2_spells_desc", "Glyphs that may be cast using a Mage's Spellbook.");
        add("ars_nouveau.tier_3_spells", "Tier 3 Glyphs");
        add("ars_nouveau.tier_3_spells_desc", "Glyphs that may be cast using a Archmage's Spellbook.");
        add("ars_nouveau.machines", "Machines");
        add("ars_nouveau.machines_desc", "Magical Machines");
        add("ars_nouveau.resources", "Resources and Decoration");
        add("ars_nouveau.resources_desc", "Resources found in the world.");
        add("ars_nouveau.rituals", "Rituals");
        add("ars_nouveau.rituals_desc", "Rituals are more powerful versions of spells, and come in semi-permanent or single use forms. To get started with Rituals, you will need a Ritual Brazier and a tablet of the ritual you would like to perform.");
        add("ars_nouveau.category.source", "Source");
        add("ars_nouveau.source_desc", "Source can be used to power rituals, summons, and machines.");
        add("ars_nouveau.page.how_to_enchant", "How to Enchant");
        add("ars_nouveau.page1.how_to_enchant", "The Enchanting Apparatus may add new enchantments or upgrade existing ones by using Source and items. To begin, select a level 1 enchantment and add its items to the pedestals. Place a jar of Source nearby, and use the item you want to enchant on the apparatus. The apparatus may only apply enchantments that are valid to the item you have given it.");
        add("ars_nouveau.page2.how_to_enchant", "To apply a level 2 or higher enchantment, the item must already have the previous level. For example, to apply Smite 3, the item must already have Smite 2.");
        add("ars_nouveau.mod_news", "Mod News");
        add("ars_nouveau.mod_news_desc", "The latest releases and news");
        add("ars_nouveau.page.mod_news", "Join the Community!");
        add("ars_nouveau.store", "Support Ars Nouveau through our Redbubble store! Get the latest summon-themed merchandise including stickers, mugs, and more!");
        add("ars_nouveau.community", "Join the Ars Nouveau community! Get ideas for spells, help with the mod, report bugs and issues, or request new features!");
        add("ars_nouveau.page1.reactive_enchantment", "Items with Reactive have a chance to cast spells when swung. The spell on the Spell Parchment determines the spell that will be inscribed on the item.");
        add("ars_nouveau.page2.reactive_enchantment", "Like other enchantments, Reactive levels can only be applied to an item with the previous level of enchantment. Reactive 2 requires Reactive 1, etc.");
        add("ars_nouveau.page3.reactive_enchantment", "The spell inscribed for Reactive can be changed by placing the item in the apparatus with a new inscribed spell parchment.");
        add("ars_nouveau.discord_text", "Join Discord!");
        add("ars_nouveau.store_text", "Shop Redbubble!");
        add("ars_nouveau.page.obtaining_gems", "Obtaining Source Gems");
        add("ars_nouveau.page1.obtaining_gems", "To obtain Source Gems, you must first build an Imbuement Chamber. An Imbuement Chamber imbues items inside it with Source, and will convert them to a new item. To obtain a source gem, place an Amethyst or Lapis inside your Imbuement Chamber and wait. Imbuement Chambers will consume source from nearby Source Jars to speed up any crafting. A Dowsing Rod can be used for finding Budding Amethyst early.");
        add("ars_nouveau.reagent", "Reagent:");
        add("ars_nouveau.level", "Level");
        add("ars_nouveau.any_item", "ANY ITEM");
        add("item.ars_nouveau.abjuration_essence", "Abjuration Essence");
        add("item.ars_nouveau.conjuration_essence", "Conjuration Essence");
        add("item.ars_nouveau.air_essence", "Air Essence");
        add("item.ars_nouveau.earth_essence", "Earth Essence");
        add("item.ars_nouveau.manipulation_essence", "Manipulation Essence");
        add("item.ars_nouveau.water_essence", "Water Essence");
        add("item.ars_nouveau.fire_essence", "Fire Essence");
        add("item.ars_nouveau.dowsing_rod", "Dowsing Rod");
        add("effect.ars_nouveau.magic_find", "Magic Find");
        add("tooltip.ars_nouveau.essences", "Magical Essences created in an Imbuement Chamber.");
        add("ars_nouveau.page.dowsing_rod", "A Dowsing Rod provides the user a short duration of Scrying for Budding Amethyst and Magic Find, which will cause magical creatures to glow within 75 blocks of you. The Dowsing Rod has a limited number of uses.");
        add("ars_nouveau.apparatus.norecipe", "No recipe found. Pedestals must be within 3 blocks.");
        add("ars_nouveau.imbuement.norecipe", "No recipe found. If pedestals are required, they must be placed within the 1 block cube around the chamber.");
        add("ars_nouveau.spell_book_gui.select", "Select");
        add("ars_nouveau.levels_required", "Levels required: %s");
        add("ars_nouveau.crafting", "Crafting: %s");
        add("ars_nouveau.all_glyphs", "All Glyphs");
        add("ars_nouveau.not_enough_exp", "Not enough EXP for this glyph.");
        add("ars_nouveau.exp", "EXP levels required: %s");
        add("ars_nouveau.scribing", "Scribing Spells");
        add("ars_nouveau.home_set", "Home set.");
        add("ars_nouveau.gathering_at", "Gathering at: %s");
        add("entity.ars_nouveau.amethyst_golem", "Amethyst Golem");
        add("tooltip.ars_nouveau.amethyst_charm", "Obtained by performing the Ritual of Awakening near Budding Amethyst");
        add("item.ars_nouveau.amethyst_golem_charm", "Amethyst Golem Charm");
        add("ars_nouveau.page1.amethyst_golem_charm", "Amethyst Golems will harvest, grow, and collect Amethyst near its home. To obtain an Amethyst Golem, perform the Ritual of Awakening near Budding Amethyst to obtain the Amethyst Golem Charm.");
        add("ars_nouveau.page2.amethyst_golem_charm", "");
        add("ars_nouveau.page3.amethyst_golem_charm", "Summon the Amethyst Golem by using a charm on a block. Before an Amethyst Golem will perform tasks, they must first have a home. Set their home by using the Dominion Wand on the golem, and then on a block. The golem's home is considered to be 10 blocks in any direction from the set position.");
        add("ars_nouveau.amethyst_farming", "Farming Amethyst");
        add("ars_nouveau.page4.amethyst_golem_charm", "Once a home has been set, the golem will begin performing tasks over time. They will convert Amethyst Blocks into Budding Amethyst, harvest Amethyst Clusters, speed up Budding Amethyst growth, and pick up and store Amethyst Shards.");
        add("ars_nouveau.amethyst_storage", "Storing Amethyst");
        add("ars_nouveau.page5.amethyst_golem_charm", "If a golem's home has been set to an inventory, golems will pick up and store Amethyst Shards in their bounded inventory block. If their home is not an inventory, they will simply ignore items on the ground.");
        add("ars_nouveau.recorded_codex", "You record your known glyphs to the codex.");
        add("ars_nouveau.updated_codex", "You have updated the codex with %s glyphs");
        add("ars_nouveau.consumed_codex", "You consume to codex to learn %s glyphs.");
        add("ars_nouveau.codex_no_use", "This codex would not teach you anything new.");
        add("ars_nouveau.codex_up_to_date", "This codex is already up to date.");
        add("ars_nouveau.codex_not_enough_exp", "Not enough levels to record glyphs. %s levels needed.");
        add("ars_nouveau.recorded_by", "Created by %s");
        add("ars_nouveau.contains_glyphs", "Contains %s glyphs.");
        add("ars_nouveau.codex_tooltip", "Use to record your glyphs.");
        add("item.ars_nouveau.annotated_codex", "Annotated Codex");
        add("ars_nouveau.page.annotated_codex", "The Annoted Codex allows players to share their knowledge of glyphs with other players. To record your known glyphs, simply use the codex. Recording glyphs requires EXP for each glyph known, and the EXP will be consumed upon using the item. Using the item again will update the list of known glyphs. Other players may use the book to learn the glyphs, consuming the codex in the process.");
        add("ars_nouveau.ritual.no_start", "Start the current ritual or break the block to remove it.");
        add("ars_nouveau.lights_on", "You have turned dynamic lights on. This can cause lag for users with weaker CPUs, low RAM allocation, and unexpected results with 'performance' mods like Optifine. Run this command or change the ars_nouveau-client config to disable this.");
        add("ars_nouveau.lights_off", "You have turned dynamic lights off.");
        add("ars_nouveau.page.relay_collector", "Operates similar to the Source Relay, but will automatically take from jars it is not linked to within 5 blocks. See the instructions on the Source Relay for use.");
        add("block.ars_nouveau.relay_collector", "Source Relay: Collector");
        add("ars_nouveau.page2.relay", "A redstone signal will disable the relay.");
        add("ars_nouveau.sounds.pitch", "Pitch: ");
        add("ars_nouveau.sounds.volume", "Volume: ");
        add("ars_nouveau.gui.sounds", "Sounds");
        add("ars_nouveau.sounds.title", "Spell Sound");
        add("ars_nouveau.sound.empty", "No Sound");
        add("ars_nouveau.earth_essence.tooltip", "Can be used on Dirt to turn it into Grass.");
        add("ars_nouveau.fire_essence.tooltip", "Can be used as a fuel source.");
        add("tooltip.ars_nouveau.glyph_known", "You have unlocked this glyph.");
        add("tooltip.ars_nouveau.glyph_unknown", "You have not unlocked this glyph.");
        add("ars_nouveau.sounds.test", "Test");
        add("ars_nouveau.gui.settings", "Settings and Rewards");
        add("ars_nouveau.settings.title", "Settings");
        add("ars_nouveau.dynamic_lights.button_on", "Dynamic lights are turned on.  This can cause lag for users with weaker CPUs, low RAM allocation, and unexpected results with 'performance' mods like Optifine.");
        add("ars_nouveau.dynamic_lights.button_off", "Dynamic lights are turned off.");
        add("block.ars_nouveau.orange_sbed", "Orange Magebloom Bed");
        add("block.ars_nouveau.blue_sbed", "Blue Magebloom Bed");
        add("block.ars_nouveau.green_sbed", "Green Magebloom Bed");
        add("block.ars_nouveau.purple_sbed", "Purple Magebloom Bed");
        add("block.ars_nouveau.red_sbed", "Red Magebloom Bed");
        add("block.ars_nouveau.yellow_sbed", "Yellow Magebloom Bed");
        add("ars_nouveau.starbuncle.set_bed", "Set bed.");
        add("ars_nouveau.summon_bed", "Magebloom Bed");
        add("ars_nouveau.page1.summon_bed", "A decorative bed. Starbuncles can be bound to a bed using the Dominion Wand, and they will rest on the bed when there are no other tasks.");
        add("block.ars_nouveau.scryers_oculus", "Scryer's Oculus");
        add("block.ars_nouveau.scryers_crystal", "Scry Crystal");
        add("item.ars_nouveau.scryer_scroll", "Scryer's Scroll");
        add("ars_nouveau.scryers_oculus.no_pos", "No position set on scroll.");
        add("ars_nouveau.scryers_oculus.no_scrolls", "No scrolls found nearby. Place a linked Scryer's Scroll on a nearby pedestal.");
        add("ars_nouveau.scryer_scroll.bound", "Bound to %s.");
        add("tooltip.ars_nouveau.scryer_scroll", "Use on a Scryer's Crystal to bind the location to this scroll.");
        add("tooltip.ars_nouveau.dowsing_rod", "Grants Magic Find and Scrying on use, causing magical creatures to glow and Amethyst to be revealed through blocks. Can be used on Imbuement Chamber and Enchanting Apparatus to highlight linked pedestals.");
        add("ars_nouveau.camera.move", "%1$s%2$s%3$s%4$s - Move");
        add("ars_nouveau.camera.exit", "%s - Exit");
        add("ars_nouveau.tooltip.scryers_oculus", "If you stare into the eye, the Starbuncle stares back at you.");
        add("ars_nouveau.page.scryers_crystal", "Can be used to look through as if you were standing there. Right click to enter the camera, or bind the camera to a Scryer's Scroll by using Blank Parchment on the block. A Scryer's Scroll will let you remotely access the block via a Scryer's Oculus. ");
        add("ars_nouveau.page.scryer_scroll", "Stores the location of a Scryer's Crystal. To create one, use a Blank Parchment on a Scry Crystal. You can remotely access the stored position by placing this item on a pedestal near a Scryer's Oculus. Naming this item will allow you to easily recognize it in the Scryer's Oculus interface.");
        add("ars_nouveau.page.scryers_oculus", "Allows you to remotely access Scry Crystals. To use, place Scryer's Scrolls on nearby pedestals and interact with the Oculus to select which Scry Crystal you would like to access. Scry Crystals must be chunk loaded.");
        add("ars_nouveau.scryer_scroll.craft", "Created by using a Blank Parchment on a Scry Crystal.");
        add("item.ars_nouveau.starbuncle_shades", "Starbuncle Shades");
        add("tooltip.starbuncle_shades", "Using these on a Starbuncle will increase their coolness, but disable their ability to pickup items off the ground or pick Sourceberries.");
        add("ars_nouveau.page.starbuncle_shades", "Using these on a Starbuncle will disable their ability to pick up items off the ground or pick Sourceberries. Wanding the starbuncle will drop the glasses.");
        add("entity.ars_nouveau.ally_vex", "Summoned Vex");
        add("ars_nouveau.scryers_eye.no_scrolls", "Place a Scryer's Scroll on a nearby pedestal.");
        add("ars_nouveau.camera.not_loaded", "The block has been removed or is not chunk loaded.");
        add("ars_nouveau.page.support_mod", "Support Ars Nouveau!");
        add("ars_nouveau.patreon", "Join the Ars Nouveau patreon and get a special Discord role, contribute a custom Tome, receive merchandise, summon a Lily dog, and more!");
        add("ars_nouveau.patreon_text", "Patreon");
        add("entity.ars_nouveau.summon_skeleton", "Summoned Skeleton");
        add("item.ars_nouveau.shapers_focus", "Focus of Block Shaping");
        add("ars_nouveau.shapers_focus.tooltip", "Can be used to create a block.");
        add("ars_nouveau.page1.shapers_focus", "A focus that modifies effects that move, create, or modify blocks. Blocks that you move with effects like Launch, Gravity, Pull, Knockback, etc. will now deal damage to entities they hit. Damage is increased by Spell Damage, block hardness, and the speed of the block. Additionally, effects that target or create blocks will duplicate the rest of the spell targeting the new block or moving block.");
        add("ars_nouveau.shapers_focus.blocks", "Block Targeting");
        add("ars_nouveau.page2.shapers_focus", "Modifying or creating a block will duplicate the rest of your spell onto that new block. For example, Freeze -> Break will freeze the block, and cast break onto that block. Without the focus, break would only be applied to the block that was hit originally. Effects that will duplicate this target include glyphs such as Conjure Mageblock, Freeze, Break, Exchange, Place Block, and more. Using AOE on these effects will duplicate the spell onto every block.");
        add("ars_nouveau.page3.shapers_focus", "Effects that move blocks will duplicate the rest of the spell onto those moving blocks. To see this in action, try using Conjure Mageblock -> Launch -> Delay -> Knockback to send a block flying in the direction you are looking. This targeting system applies to all moved blocks. Using AOE on block moving effects will let you manipulate many blocks at once.");
        add("ars_nouveau.shapers_focus.entities", "Entity Targeting");
        add("ars_nouveau.shapers_focus.examples", "Spell Examples");
        add("ars_nouveau.page4.shapers_focus", "$(bold)Throw Ice:$() Conjure Water -> Freeze -> Launch -> Delay -> Knockback. $(bold)Damage and ignite hit targets:$() Conjure Mageblock -> Launch -> Ignite -> Delay -> Knockback. $(bold)Ignite TNT:$() Place Block (TNT) -> Ignite. $(bold)Throw Exploding Terrain:$() Launch -> Delay -> Knockback -> Delay -> Explosion. $(bold)Throw many blocks:$() Launch -> AOE x2 -> Delay -> Knockback. $(bold)Pull blocks:$() Pull -> AOE x2 -> Delay -> Duration Down -> Launch -> Delay -> Knockback. $(bold)Harvest Sand:$() Crush (on stone) -> Aoe -> Break");
        add("tooltip.ars_nouveau.shapers_focus", "Duplicates spells that modify or move blocks. Can be used to create damaging moving blocks.");
        add("ars_nouveau.tablet_of", "Tablet of %s");
        add("ars_nouveau.bound_script", "Bound Script: %s");
        add("block.ars_nouveau.sourcestone", "Sourcestone");
        add("block.ars_nouveau.sourcestone_mosaic", "Sourcestone: Mosaic");
        add("block.ars_nouveau.sourcestone_basketweave", "Sourcestone: Basketweave");
        add("block.ars_nouveau.sourcestone_alternating", "Sourcestone: Alternating");
        add("block.ars_nouveau.sourcestone_large_bricks", "Sourcestone: Large Bricks");
        add("block.ars_nouveau.sourcestone_small_bricks", "Sourcestone: Small Bricks");
        add("block.ars_nouveau.smooth_sourcestone", "Smooth Sourcestone");
        add("block.ars_nouveau.smooth_sourcestone_mosaic", "Smooth Sourcestone: Mosaic");
        add("block.ars_nouveau.smooth_sourcestone_basketweave", "Smooth Sourcestone: Basketweave");
        add("block.ars_nouveau.smooth_sourcestone_alternating", "Smooth Sourcestone: Alternating");
        add("block.ars_nouveau.smooth_sourcestone_large_bricks", "Smooth Sourcestone: Large Bricks");
        add("block.ars_nouveau.smooth_sourcestone_small_bricks", "Smooth Sourcestone: Small Bricks");
        add("block.ars_nouveau.gilded_sourcestone_mosaic", "Gilded Sourcestone: Mosaic");
        add("block.ars_nouveau.gilded_sourcestone_basketweave", "Gilded Sourcestone: Basketweave");
        add("block.ars_nouveau.gilded_sourcestone_alternating", "Gilded Sourcestone: Alternating");
        add("block.ars_nouveau.gilded_sourcestone_large_bricks", "Gilded Sourcestone: Large Bricks");
        add("block.ars_nouveau.gilded_sourcestone_small_bricks", "Gilded Sourcestone: Small Bricks");
        add("block.ars_nouveau.smooth_gilded_sourcestone_mosaic", "Smooth Gilded Sourcestone: Mosaic");
        add("block.ars_nouveau.smooth_gilded_sourcestone_basketweave", "Smooth Gilded Sourcestone: Basketweave");
        add("block.ars_nouveau.smooth_gilded_sourcestone_alternating", "Smooth Gilded Sourcestone: Alternating");
        add("block.ars_nouveau.smooth_gilded_sourcestone_large_bricks", "Smooth Gilded Sourcestone: Large Bricks");
        add("block.ars_nouveau.smooth_gilded_sourcestone_small_bricks", "Smooth Gilded Sourcestone: Small Bricks");
        add("tooltip.item_scroll", "Use with an item in the offhand to add to the scroll, or scribe on the Scribes table.");
        add("item.ars_nouveau.mendosteen_pod", "Mendosteen");
        add("item.ars_nouveau.frostaya_pod", "Frostaya");
        add("item.ars_nouveau.bombegranate_pod", "Bombegranate");
        add("item.ars_nouveau.bastion_pod", "Bastion Fruit");
        add("item.ars_nouveau.alchemists_crown", "Alchemist's Crown");
        add("block.ars_nouveau.potion_diffuser", "Potion Diffuser");
        add("block.ars_nouveau.bastion_pod", "Bastion Fruit");
        add("block.ars_nouveau.bombegranate_pod", "Bombegranate");
        add("block.ars_nouveau.frostaya_pod", "Frostaya");
        add("block.ars_nouveau.intangible_air", "Intangible Air");
        add("block.ars_nouveau.mendosteen_pod", "Mendosteen");
        add("block.ars_nouveau.redstone_air", "Redstone Air");
        add("entity.ars_nouveau.dummy", "Dummy");
        add("entity.ars_nouveau.enchanted_falling_block", "Enchanted Falling Block");
        add("entity.ars_nouveau.enchanted_mage_block", "Enchanted Falling Block");
        add("entity.ars_nouveau.enchanted_head_block", "Enchanted Falling Block");
        add("entity.ars_nouveau.familiar_jabberwog", "Familiar Jabberwog");
        add("entity.ars_nouveau.fangs", "Fangs");
        add("entity.ars_nouveau.ritual", "Ritual");
        add("ars_nouveau.melder.from_capped", "Melders can only meld two jars. Clear the melder by using the Dominion Wand while sneaking to remove all jars.");
        add("ars_nouveau.melder.to_set", "Melder will send combined potions to this jar.");
        add("ars_nouveau.melder.from_set", "%s of 2 melding jars set.");
        add("ars_nouveau.melder.no_to_pos", "Wand the Melder to your desired Potion Jar.");
        add("ars_nouveau.melder.needs_potion", "Linked jars need potion");
        add("ars_nouveau.melder.destination_invalid", "Destination cannot accept the mixed potion.");
        add("arsnouveau.debug.log_created", "Log file created: %s");
        add("ars_nouveau.page.archwood_forest", "Archwood Forest");
        add("ars_nouveau.page1.archwood_forest", "The Archwood Forest is a somewhat rare biome filled with magical lights and archwood trees. It contains an increased amount of gold. Additionally, magical creatures such as Starbuncles, Whirlisprigs, Archwood Treants, and Drygmys have a much higher chance of spawning. Terrablender is required to be installed to generate this biome.");
        add("ars_nouveau.melder.too_far", "Jars must be within 3 blocks.");
        add("ars_nouveau.starbuncle.storing_potions", "Storing potions at %s locations");
        add("ars_nouveau.starbuncle.taking_potions", "Taking potions from %s locations");
        add("ars_nouveau.starbuncle.potion_to", "Starbuncle will send potions to this jar.");
        add("ars_nouveau.starbuncle.potion_from", "Starbuncle will take potions from this jar.");
        add("ars_nouveau.dominion_wand.cleared", "Dominion wand cleared.");
        add("ars_nouveau.starbuncle.potion_behavior_set", "Starbuncle will now transport potions!");
        add("key.ars_nouveau.qc1", "Quick Cast Slot 01");
        add("key.ars_nouveau.qc2", "Quick Cast Slot 02");
        add("key.ars_nouveau.qc3", "Quick Cast Slot 03");
        add("key.ars_nouveau.qc4", "Quick Cast Slot 04");
        add("key.ars_nouveau.qc5", "Quick Cast Slot 05");
        add("key.ars_nouveau.qc6", "Quick Cast Slot 06");
        add("key.ars_nouveau.qc7", "Quick Cast Slot 07");
        add("key.ars_nouveau.qc8", "Quick Cast Slot 08");
        add("key.ars_nouveau.qc9", "Quick Cast Slot 09");
        add("key.ars_nouveau.qc10", "Quick Cast Slot 10");
        add("item.minecraft.splash_potion.effect.recovery_potion_strong", "Splash Potion of Recovery");
        add("item.minecraft.splash_potion.effect.recovery_potion", "Splash Potion of Recovery");
        add("item.minecraft.splash_potion.effect.recovery_potion_long", "Splash Potion of Recovery");
        add("item.minecraft.potion.effect.recovery_potion_strong", "Potion of Recovery");
        add("item.minecraft.potion.effect.recovery_potion", "Potion of Recovery");
        add("item.minecraft.potion.effect.recovery_potion_long", "Potion of Recovery");
        add("item.minecraft.lingering_potion.effect.recovery_potion_strong", "Lingering Potion of Recovery");
        add("item.minecraft.lingering_potion.effect.recovery_potion", "Lingering Potion of Recovery");
        add("item.minecraft.lingering_potion.effect.recovery_potion_long", "Lingering Potion of Recovery");
        add("item.minecraft.tipped_arrow.effect.recovery_potion_strong", "Arrow of Recovery");
        add("item.minecraft.tipped_arrow.effect.recovery_potion", "Arrow of Recovery");
        add("item.minecraft.tipped_arrow.effect.recovery_potion_long", "Arrow of Recovery");
        add("item.minecraft.splash_potion.effect.blasting_potion_strong", "Splash Potion of Blasting");
        add("item.minecraft.splash_potion.effect.blasting_potion", "Splash Potion of Blasting");
        add("item.minecraft.splash_potion.effect.blasting_potion_long", "Splash Potion of Blasting");
        add("item.minecraft.potion.effect.blasting_potion_strong", "Potion of Blasting");
        add("item.minecraft.potion.effect.blasting_potion", "Potion of Blasting");
        add("item.minecraft.potion.effect.blasting_potion_long", "Potion of Blasting");
        add("item.minecraft.lingering_potion.effect.blasting_potion_strong", "Lingering Potion of Blasting");
        add("item.minecraft.lingering_potion.effect.blasting_potion", "Lingering Potion of Blasting");
        add("item.minecraft.lingering_potion.effect.blasting_potion_long", "Lingering Potion of Blasting");
        add("item.minecraft.tipped_arrow.effect.blasting_potion_strong", "Arrow of Blasting");
        add("item.minecraft.tipped_arrow.effect.blasting_potion", "Arrow of Blasting");
        add("item.minecraft.tipped_arrow.effect.blasting_potion_long", "Arrow of Blasting");
        add("item.minecraft.splash_potion.effect.freezing_potion_strong", "Splash Potion of Freezing");
        add("item.minecraft.splash_potion.effect.freezing_potion", "Splash Potion of Freezing");
        add("item.minecraft.splash_potion.effect.freezing_potion_long", "Splash Potion of Freezing");
        add("item.minecraft.potion.effect.freezing_potion_strong", "Potion of Freezing");
        add("item.minecraft.potion.effect.freezing_potion", "Potion of Freezing");
        add("item.minecraft.potion.effect.freezing_potion_long", "Potion of Freezing");
        add("item.minecraft.lingering_potion.effect.freezing_potion_strong", "Lingering Potion of Freezing");
        add("item.minecraft.lingering_potion.effect.freezing_potion", "Lingering Potion of Freezing");
        add("item.minecraft.lingering_potion.effect.freezing_potion_long", "Lingering Potion of Freezing");
        add("item.minecraft.tipped_arrow.effect.freezing_potion_strong", "Arrow of Freezing");
        add("item.minecraft.tipped_arrow.effect.freezing_potion", "Arrow of Freezing");
        add("item.minecraft.tipped_arrow.effect.freezing_potion_long", "Arrow of Freezing");
        add("item.minecraft.splash_potion.effect.shielding_potion_strong", "Splash Potion of Shielding");
        add("item.minecraft.splash_potion.effect.shielding_potion", "Splash Potion of Shielding");
        add("item.minecraft.splash_potion.effect.shielding_potion_long", "Splash Potion of Shielding");
        add("item.minecraft.potion.effect.shielding_potion_strong", "Potion of Shielding");
        add("item.minecraft.potion.effect.shielding_potion", "Potion of Shielding");
        add("item.minecraft.potion.effect.shielding_potion_long", "Potion of Shielding");
        add("item.minecraft.lingering_potion.effect.shielding_potion_strong", "Lingering Potion of Shielding");
        add("item.minecraft.lingering_potion.effect.shielding_potion", "Lingering Potion of Shielding");
        add("item.minecraft.lingering_potion.effect.shielding_potion_long", "Lingering Potion of Shielding");
        add("item.minecraft.tipped_arrow.effect.shielding_potion_strong", "Arrow of Shielding");
        add("item.minecraft.tipped_arrow.effect.shielding_potion", "Arrow of Shielding");
        add("item.minecraft.tipped_arrow.effect.shielding_potion_long", "Arrow of Shielding");
        add("effect.ars_nouveau.recovery", "Recovery");
        add("effect.ars_nouveau.blasting", "Blasting");
        add("effect.ars_nouveau.freezing", "Freezing");
        add("effect.ars_nouveau.shielding", "Shielding");
        add("tooltip.ars_nouveau.alchemists_crown", "");
        add("item.ars_nouveau.wixie_hat", "Wixie Hat");
        add("tooltip.ars_nouveau.wixie_hat", "Give to a Starbuncle to make them transport potions.");
        add("ars_nouveau.starbuncle.default_behavior", "Starbuncle will now transport items!");
        add("ars_nouveau.potion_diffuser.set_pos", "Diffuser will spread this potion to nearby entities.");
        add("ars_nouveau.potion_diffuser.bind_to_jar", "You must bind the diffuser to a Potion Jar to use it.");
        add("ars_nouveau.potion_diffuser.no_pos", "Bind a Potion Jar to the diffuser using the Dominion Wand.");
        add("ars_nouveau.potion_diffuser.off", "Diffuser is off.");
        add("key.ars_nouveau.head_curio_hotkey", "Head Curio Menu");
        add("ars_nouveau.alchemists_crown.no_flasks", "No flasks or potions equipped.");
        add("ars_nouveau.page.alchemists_crown", "Allows the wearer to consume potions and flasks instantly from their inventory.");
        add("ars_nouveau.tooltip.alchemists_crown", "Press %s to open the potion radial menu.");
        add("ars_nouveau.page.wixie_hat", "Allows starbuncles to transport potions. Once wearing a Wixie Hat, use the Dominion Wand to connect them between Potion Jars.");
        add("ars_nouveau.page.potion_diffuser", "Consumes a potion and applies it to nearby entities, greatly extending the use of the potion. To use, bind a Potion Jar to the diffuser using the Dominion Wand. Every 10 minutes the diffuser will consume a single potion and apply it every few seconds.");
        add("ars_nouveau.page.bombegrante", "A fruit that packs an explosive punch. Can be brewed into a Potion of Blasting, causing the target to explode when the duration ends.");
        add("ars_nouveau.page.mendosteen", "A fruit that can be brewed into a Potion of Recovery, increases the amount of healing received from all sources.");
        add("ars_nouveau.page.frostaya", "A fruit that can be brewed into a Potion of Freezing, freezing the target over time.");
        add("ars_nouveau.page.bastion_fruit", "A fruit that can be brewed into a Potion of Defence, reducing the amount of damage taken.");
        add("ars_nouveau.wixie_familiar.applied", "Wixie applies %s");
        add("ars_nouveau.flask_cannon.no_potion", "No potions in inventory.");
        add("item.ars_nouveau.lingering_flask_cannon", "Lingering Flask Cannon");
        add("item.ars_nouveau.splash_flask_cannon", "Splash Flask Cannon");
        add("ars_nouveau.page.flask_cannons", "Flask Cannons");
        add("ars_nouveau.page1.flask_cannons", "Flask Cannons can consume potions from bottles and flasks from the players inventory and convert the potion into a Splash or Lingering potion. To select the potion to be thrown, use the Radial Menu to select your flask or potion and use the launcher.");
        add("ars_nouveau.imbuement.crafting_started", "Crafting %s. Add source nearby to increase craft speed.");
        add("ars_nouveau.crafting_progress", "Crafting Progress: %s");
        add("ars_nouveau.scribes_table.throw_items", "Toss remaining items onto the table.");
        add("ars_nouveau.scribes_table.started_crafting", "Toss items as they appear above to complete crafting.");
        add("ars_nouveau.gui.discord", "Join the Discord for spells, updates, and support!");
        add("entity.ars_nouveau.an_lightning", "Lightning");
        add("entity.ars_nouveau.flying_item", "Flying Item");
        add("entity.ars_nouveau.follow_proj", "Projectile");
        add("entity.ars_nouveau.linger", "Linger");
        add("entity.ars_nouveau.orbit", "Orbit");
        add("entity.ars_nouveau.scryer_camera", "Scryer Camera");
        add("entity.ars_nouveau.spell_arrow", "Spell Arrow");
        add("entity.ars_nouveau.spell_proj", "Spell Projectile");
        add("ars_nouveau.armor", "Armor and Perks");
        add("ars_nouveau.page.armor_upgrading", "Armor Upgrading");
        add("ars_nouveau.armor_tiers", "Armor Tiers");
        add("ars_nouveau.armor_desc", "Threads can be slotted into magical armor to provide additional effects. Armor can be upgraded to new tiers, unlocking additional and more powerful thread slots.");
        add("ars_nouveau.page1.armor_upgrading", "Magical armor can be upgraded with Threads to provide additional effects. Each type of armor has a different number of slots, and those slots vary in size. Larger slots will increase the power of threads, and some threads require a slot of a certain size or larger. To apply threads, see the section on the Alteration Table.");
        add("ars_nouveau.page2.armor_upgrading", "Armor also has three tiers, and these tiers may be increased using the Enchanting Apparatus and the upgrade recipes found in this section. Each tier will increase the amount of mana regen the armor grants, and increases the number and size of the slots of the armor.");
        add("block.ars_nouveau.alteration_table", "Alteration Table");
        add("ars_nouveau.page.alteration_table", "Alteration Table");
        add("ars_nouveau.page1.alteration_table", "Used to inscribe Threads onto magical armors. To use the table, place armor onto the stand of the table. The tablet will display the available Thread Slots on the armor. To add or remove a Thread, use the thread on the tablet of the table. Removing the armor will apply the threads to the armor. To remove a thread, place the armor on the table and interact with the display with an empty hand.");
        add("item.ars_nouveau.blank_thread", "Blank Thread");
        add("tooltip.ars_nouveau.blank_thread", "Used to craft threads that may be used to empower your magical armor.");
        add("ars_nouveau.perk.invalid_for_slot", "This perk requires a level %s or higher slot.");
        add("ars_nouveau.perk.warding", "Warding");
        add("ars_nouveau.perk.mana_regen", "Mana Regen");
        add("ars_nouveau.perk.percent_max_mana", "Max Mana");
        add("ars_nouveau.perk.flat_max_mana", "Max Mana");
        add("ars_nouveau.perk.spell_damage", "Spell Power");
        add("ars_nouveau.perk.saturation", "Bonus Saturation");
        add("ars_nouveau.perk.wixie", "Potion Duration");
        add("ars_nouveau.perk.jump_height", "Jump Power");
        add("ars_nouveau.page.threads", "Each type of armor has its own unique set of Thread Slots. Upgrading the armor to a new tier will unlock and add additional slots to the armor. The Sorcerors set provides the least amount of defence while providing the most powerful slots, while the Battlemage's set provides defence but much weaker slots. For recipes on upgrading your armor to the next tier, see the section in the Armor and Perks category.");
        add("ars_nouveau.threads", "Thread Slots");
        add("ars_nouveau.thread_layout", "Thread Tiers");
        add("ars_nouveau.page.applying_perks", "Applying Threads");
        add("ars_nouveau.page1.applying_perks", "Threads may be applied to armor using the Alteration Apparatus. Each piece of armor has a unique set of Thread Slots with their own variety of levels. Some Threads may require a Thread Slot of a minimum level, but many threads simply increase in power based on the slot they are given.");
        add("ars_nouveau.page2.applying_perks", "Threads only apply a single time on an entire armor set, and they do not stack. For more information on applying threads, see the Alteration Table.");
        add("ars_nouveau.perk.not_perk", "Use a thread to apply it onto the selected armor.");
        add("ars_nouveau.perk.set_armor", "Place armor onto the table.");
        add("ars_nouveau.perk.max_perks", "This armor has reached its maximum number of perks.");
        add("ars_nouveau.page.layout_desc", "Each set of armor has its own unique set of Thread Slots.");
        add("ars_nouveau.armor_upgrade.book_desc", "Accepts Tier %s Armor");
        add("ars_nouveau.spell_write.book_desc", "Accepts Reactive Items");
        add("ars_nouveau.perks.duplicated", "You have equipped armor that contains a perk you already have. You will only receive the effect of the perk once.");
        add("ars_nouveau.totem_perk.trigger", "Thread of Undying will reactive the next time you sleep.");
        add("ars_nouveau.totem_perk.active", "Thread of Undying is now active.");
        add("ars_nouveau.sound.fire_family", "Fire Family");
        add("ars_nouveau.sound.default_family", "Default");
        add("ars_nouveau.sound.tempestry_family", "Tempestry Family");
        add("ars_nouveau.sound.gaia_family", "Gaia Family");
        add("block.ars_nouveau.mob_jar", "Containment Jar");
        add("ars_nouveau.page.mob_jar", "Containment Jar");
        add("ars_nouveau.page1.mob_jar", "Allows you to capture and store mobs for transportation or decoration. To capture a mob, you must perform a Ritual of Containment. See the Ritual of Containment for more info. To release a mob, cast Dispel on the jar and the mob will be released above the jar. Note Blocks placed above a jar will play an ambient sound of the mob inside.");
        add("ars_nouveau.page2.mob_jar", "Many entities can be interacted with inside the jar and will continue to simulate while inside the jar. Some examples include: chickens will lay eggs, sheep can be sheared, cows can be milked, and some mobs like the Blaze will turn the jar into a light source. Experiment with a variety of mobs to create aesthetic and functional farms. Drygmys will also treat the jar as if it were a normal entity in the area.");
        add("ars_nouveau.title.mob_jar", "Functionality");
        add("ars_nouveau.advancement.title.root", "Ars Nouveau");
        add("ars_nouveau.advancement.desc.root", "Acquire a Worn Notebook");
        add("ars_nouveau.adv.title.ritual_brazier", "Brazen");
        add("ars_nouveau.adv.desc.ritual_brazier", "Acquire a Ritual Brazier");
        add("ars_nouveau.adv.title.familiar", "This Seems Familiar...");
        add("ars_nouveau.adv.desc.familiar", "Bind a magical creature into a Familiar");
        add("ars_nouveau.adv.title.amethyst_golem_charm", "Purple Amethyst Eater");
        add("ars_nouveau.adv.desc.amethyst_golem_charm", "Acquire an Amethyst Golem Charm");
        add("ars_nouveau.adv.title.novice_spell_book", "Unbreaking X");
        add("ars_nouveau.adv.desc.novice_spell_book", "Acquire a Novice Spell Book");
        add("ars_nouveau.adv.title.apprentice_spell_book", "Mage's Spell Book");
        add("ars_nouveau.adv.desc.apprentice_spell_book", "Acquire a Mage's Spell Book");
        add("ars_nouveau.adv.title.archmage_spell_book", "Archmage Spell Book");
        add("ars_nouveau.adv.desc.archmage_spell_book", "Acquire an Archmage Spell Book");
        add("ars_nouveau.adv.title.shapers_focus", "Throw Another Rock!");
        add("ars_nouveau.adv.desc.shapers_focus", "Acquire a Shaper's Focus");
        add("ars_nouveau.adv.title.imbuement_chamber", "Imbued");
        add("ars_nouveau.adv.desc.imbuement_chamber", "Acquire an Imbuement Chamber");
        add("ars_nouveau.adv.title.eat_bombegranate", "To Die For");
        add("ars_nouveau.adv.desc.eat_bombegranate", "Eat a Bombegranate");
        add("ars_nouveau.adv.title.poof_mob", "Where did it go?");
        add("ars_nouveau.adv.desc.poof_mob", "Make a \"Trade\" with a Magical Creature");
        add("ars_nouveau.adv.title.enchanting_apparatus", "Magic Mod Mechanic");
        add("ars_nouveau.adv.desc.enchanting_apparatus", "Acquire an Enchanting Apparatus");
        add("ars_nouveau.adv.title.starby_charm", "The Cutest Hopper");
        add("ars_nouveau.adv.desc.starby_charm", "Acquire a Starbuncle Charm");
        add("ars_nouveau.adv.title.wixie_charm", "Free the Inner Child");
        add("ars_nouveau.adv.desc.wixie_charm", "Acquire a Wixie Charm");
        add("ars_nouveau.adv.title.whirlisprig_charm", "Whirli");
        add("ars_nouveau.adv.desc.whirlisprig_charm", "Acquire a Whirlisprig Charm");
        add("ars_nouveau.adv.title.magebloom_crop", "Magebloom");
        add("ars_nouveau.adv.desc.magebloom_crop", "Acquire a Magebloom Seed");
        add("ars_nouveau.adv.title.basic_spell_turret", "It's a Magic Mod, I Swear!");
        add("ars_nouveau.adv.desc.basic_spell_turret", "Acquire a Basic Spell Turret");
        add("ars_nouveau.adv.title.spell_prism", "Prismatic Redirection");
        add("ars_nouveau.adv.desc.spell_prism", "Acquire a Spell Prism");
        add("ars_nouveau.adv.title.scryers_oculus", "Eye Spy");
        add("ars_nouveau.adv.desc.scryers_oculus", "Acquire a Scryer's Oculus");
        add("ars_nouveau.adv.title.potion_jar", "Potion Storage");
        add("ars_nouveau.adv.desc.potion_jar", "Acquire a Potion Jar");
        add("ars_nouveau.adv.title.alteration_table", "Armor Alteration");
        add("ars_nouveau.adv.desc.alteration_table", "Acquire an Alteration Table");
        add("ars_nouveau.adv.desc.blank_thread", "Acquire a Blank Thread");
        add("ars_nouveau.adv.title.blank_thread", "Empty Canvas");
        add("ars_nouveau.adv.title.potion_melder", "Meld'em, Mash'em, Stick'em in a Cauldron");
        add("ars_nouveau.adv.desc.potion_melder", "Acquire a Potion Melder");
        add("ars_nouveau.adv.title.potion_diffuser", "Do you smell that?");
        add("ars_nouveau.adv.desc.potion_diffuser", "Acquire a Potion Diffuser");
        add("ars_nouveau.adv.title.potion_flask", "Stackable Potions");
        add("ars_nouveau.adv.desc.potion_flask", "Acquire a Potion Flask");
        add("ars_nouveau.adv.title.wilden_tribute", "Wilden Tribute");
        add("ars_nouveau.adv.desc.wilden_tribute", "Acquire a Wilden Tribute");
        add("ars_nouveau.adv.title.summon_focus", "Summoning Focus");
        add("ars_nouveau.adv.desc.summon_focus", "Acquire a Summoning Focus");
        add("ars_nouveau.adv.title.wixie_hat", "Potion Transport");
        add("ars_nouveau.adv.desc.wixie_hat", "Acquire a Wixie Hat");
        add("ars_nouveau.adv.title.starbuncle_shades", "One Cool Starbuncle");
        add("ars_nouveau.adv.desc.starbuncle_shades", "Acquire Starbuncle Shades");
        add("ars_nouveau.adv.title.wilden_explosion", "Wait, it can fly?");
        add("ars_nouveau.adv.desc.wilden_explosion", "Witness an explosive divebomb");
        add("ars_nouveau.adv.title.prismatic", "Thinking with Prisms");
        add("ars_nouveau.adv.desc.prismatic", "Redirect a Spell using a Prism four or more times");
        add("ars_nouveau.adv.title.create_portal", "Thinking with...wrong game");
        add("ars_nouveau.adv.desc.create_portal", "Create a Warp Portal");
        add("ars_nouveau.adv.title.warp_scroll", "Warped");
        add("ars_nouveau.adv.desc.warp_scroll", "Acquire a Warp Scroll");
        add("ars_nouveau.adv.title.drygmy_charm", "Moose Dance");
        add("ars_nouveau.adv.desc.drygmy_charm", "Acquire a Drygmy Charm");
        add("ars_nouveau.adv.title.source_jar", "Not a Fluid!");
        add("ars_nouveau.adv.desc.source_jar", "Acquire a Source Jar");
        add("ars_nouveau.adv.title.mob_jar", "Tiny Home");
        add("ars_nouveau.adv.desc.mob_jar", "Acquire a Containment Jar");
        add("ars_nouveau.adv.title.shrunk_starbuncle", "Honey I Shrunk the Starbuncle");
        add("ars_nouveau.adv.desc.shrunk_starbuncle", "Put a Starbuncle in a Containment Jar");
        add("block.ars_nouveau.void_prism", "Void Prism");
        add("ars_nouveau.page.void_prism", "Destroys any spell projectiles that pass through it.");
        add("item.ars_nouveau.music_disc_aria_biblio", "Music Disc");
        add("item.ars_nouveau.music_disc_aria_biblio.desc", "Firel - Aria Biblio");
        add("item.ars_nouveau.starby_gift", "Starbuncle Gift");
        add("ars_nouveau.present.give", "Give this to a friend and they will get bonus items, or open it for yourself!");
        add("ars_nouveau.present.from", "A gift from %s");
        add("entity.ars_nouveau.gift_starby", "Starbuncle");
        add("block.ars_nouveau.falseweave", "Falseweave");
        add("block.ars_nouveau.ghostweave", "Ghostweave");
        add("block.ars_nouveau.mirrorweave", "Mirrorweave");
        add("block.ars_nouveau.magebloom_block", "Magebloom Block");
        add("ars_nouveau.page.illusion_blocks", "Illusion Blocks");
        add("ars_nouveau.page1.illusion_blocks", "Mirrorweave can replicate the appearance of any block that is used on it. These blocks will take on the same collisions and light as their replicated block. Sense Magic will reveal the illusion. All illusion blocks can also be used as frames for portals. Casting light on an illusion block will allow it to emit light.");
        add("ars_nouveau.page2.illusion_blocks", "Falseweave has the same properties as Mirrorweave, but can be passed through as if it were air. Sense Magic will cause the block to become invisible, revealing any hidden paths.");
        add("ars_nouveau.page3.illusion_blocks", "Ghostweave has the same properties as Mirrorweave, but can be turned into an invisible wall by casting Invisbility on it. Casting Dispel will reveal the block again. Sense Magic will cause the block to appear solid again.");
        add("item.ars_nouveau.spell_crossbow", "Enchanter's Crossbow");
        add("ars_nouveau.page1.spell_crossbow", "A crossbow that can be inscribed with a spell. The mana cost of the spell will be deducted when the bow is loaded if mana is present. Enchanter's Crossbows may use special augment arrows to empower their spells.");
        add("ars_nouveau.tooltip.from_blank", "Created by scribing a Blank Parchment in the scribes table.");
        add("ars_nouveau.manipulation_essence.tooltip", "Can be scribed onto a Spell Parchment or caster tool to permanently hide the spell.");
        add("ars_nouveau.spell_hidden", "Spell is now hidden.");
        add("entity.minecraft.villager.ars_nouveau.shady_wizard", "Shady Wizard");
        add("entity.minecraft.villager.shady_wizard", "Shady Wizard");
        add("death.attack.an_enchantedBlock", "%1$s was crushed by %2$s magic blocks");
        add("death.attack.freeze.item", "%1$s was frozen to death by %2$s using %3$");
        add("block.ars_nouveau.magelight_torch", "Magelight Torch");
        add("block.ars_nouveau.arcane_platform", "Arcane Platform");
        add("ars_nouveau.arcane_platform.tooltip", "Can be placed in any direction and can be used in place of a pedestal.");
        add("ars_nouveau.brazier_relay.connected", "Brazier connected.");
        add("block.ars_nouveau.brazier_relay", "Ritual Brazier Relay");
        add("ars_nouveau.page.brazier_relay", "Allows the users to bind a Ritual Brazier ritual to a new location. Multiple rituals can be connected to the same brazier relay. To connect, use the Dominion Wand on your Ritual Brazier, then the relay. Source is consumed at the original braziers location. Can be bound within 15 blocks.");
        add("item.ars_nouveau.stable_warp_scroll", "Stabilized Warp Scroll");
        add("overworld.minecraft.name", "Overworld");
        add("the_nether.minecraft.name", "The Nether");
        add("the_end.minecraft.name", "The End");
        add("ars_nouveau.page.stable_warp_scroll", "Creates a temporary Warp Portal when used on a block. This scroll is not consumed on use and can teleport between dimensions. Using a Stabilized Warp Scroll to create a Warp Portal will create a cross dimension warp portal, but consume the scroll. This scroll may only be bound to a location a single time.");
        add("ars_nouveau.adv.title.catch_lightning", "Lightning in a Bottle");
        add("ars_nouveau.adv.desc.catch_lightning", "Catch a lightning bolt in a containment jar.");
        add("ars_nouveau.adv.title.time_in_a_bottle", "Time in a Bottle");
        add("ars_nouveau.adv.desc.time_in_a_bottle", "Put a clock in a containment jar");
        add("ars_nouveau.light_message", "Ars Nouveau adds built in dynamic lights. Enable with `/ars-light on`. This won't appear again!");
        add("ars_nouveau.warp_scroll.already_recorded", "This scroll is already bound to a location.");
        add("ars_nouveau.page4.illusion_blocks", "Skyweave will display the skybox of the dimension it is placed in. To toggle the skybox and show the facade, cast Dispel on it. The facade may be set to another block like Mirrorweave.");
        add("block.ars_nouveau.sky_block", "Skyweave");
        add("ars_nouveau.scry_caster.not_crystal", "The bound crystal is no longer present.");
        add("ars_nouveau.scry_caster.no_pos", "No position set. Use this on a Scry Crystal or hold a Scryer's Scroll in the offhand.");
        add("ars_nouveau.scry_caster.invalid_behavior", "Invalid spell bound. Rebind a new valid spell.");
        add("entity.ars_nouveau.animated_block", "Animated Block");
        add("entity.ars_nouveau.animated_head", "Animated Head");

        add("item.ars_nouveau.enchanters_eye", "Enchanter's Eye");
        add("ars_nouveau.page.enchanters_eye", "A caster tool that can cast inscribed spells remotely through a Scry Crystal. Use the eye on a Scry Crystal to bind the location, or hold a bound Scry Parchment in the offhand. Spells will be cast through the eye similar to a Spell Turret, but you are considered the caster for all effects. Useful for remote teleportation or item movement.");
        add("ars_nouveau.warp_scroll.disabled_warp_portal", "Permanent warp portals are currently disabled");
        add("ars_nouveau.lectern_out_of_range", "The lectern is out of range.");
        add("tooltip.ars_nouveau.items_missing", "Items Missing");
        add("narrator.ars_nouveau.search", "Search");
        add("tooltip.ars_nouveau.amount", "Total: %s");
        add("tooltip.ars_nouveau.sorting_1", "Sorting Alphabetically");
        add("tooltip.ars_nouveau.sorting_0", "Sorting by Amount");
        add("ars_nouveau.storage.from_set", "Inventory added.");
        add("ars_nouveau.storage.too_many", "Maximum number of inventories reached. Add more Bookwyrms to increase the limit.");
        add("ars_nouveau.storage.num_connected", "%s connected inventories");
        add("ars_nouveau.storage_lectern", "Storage Lectern");
        add("tooltip.ars_nouveau.search_0", "Non-synced Search");
        add("tooltip.ars_nouveau.search_1", "Synced Search");
        add("ars_nouveau.invalid_lectern", "Invalid lectern connected.");
        add("ars_nouveau.storage.lectern_chained", "Linked to x: %s y: %s z: %s");
        add("ars_nouveau.storage.num_bookwyrms", "%s Bookwyrms");
        add("ars_nouveau.storage.removed", "Inventory removed.");
        add("ars_nouveau.storage.not_lectern", "Connect to another Lectern to connect the views.");
        add("ars_nouveau.storage.lectern_too_far", "Lectern must be within 30 blocks.");
        add("ars_nouveau.storage.inv_too_far", "Inventory must be within 30 blocks.");
        add("ars_nouveau.storage.no_tile", "Not a valid inventory.");
        add("block.ars_nouveau.storage_lectern", "Storage Lectern");
        add("ars_nouveau.page1.storage_lectern", "The Storage Lectern can used to view, manage, and craft from multiple connected inventories. The number of inventories that may be connected is determined by the number of Bookwyrms bound to the lectern. You can add more Bookwyrms to the lectern by using a Bookwyrm Charm. Use the Dominion Wand from an inventory to the lectern in order to bind or remove access. Inventories can be connected 30 blocks away.");
        add("ars_nouveau.storage", "Advanced Usage");
        add("ars_nouveau.page2.storage", "Items can be automatically inserted into the lectern by placing them into an unbound inventory that is adjacent to the lectern. You may also link a lectern to the 'main' lectern in order to extend the view and access of the original lectern, these lecterns can be chained together within 30 blocks indefinitely. Once a lectern is linked to another lectern, it will no longer be able to connect to inventories or accept bookwyrms.");
        add("ars_nouveau.tooltip.bookwyrm", "Obtained by augmenting a Ritual of Awakening with Book and Quills.");
        add("ars_nouveau.item_detector.count", "Emit at %s");
        add("block.ars_nouveau.item_detector", "Display Case");
        add("ars_nouveau.item_detector.item", "%s");
        add("ars_nouveau.item_detector.powered", "Powered: %s");
        add("ars_nouveau.item_detector.connected", "Detecting items at x: %s y: %s z: %s");
        add("ars_nouveau.page1.item_detector", "A Display Case can be configured to output a redstone signal when a certain level of inventory is reached. To set the item for tracking, use an item on the case. Interact with the block to increase the count, and punch to decrease. To link to an inventory, Dominion Wand an inventory to the display case. Wanding while sneaking will invert if the signal outputs below or greater than the set count.");
        add("ars_nouveau.item_detector.inverted", "Signal Inverted: %s");
        add("block.ars_nouveau.repository", "Repository");
        add("ars_nouveau.removed_familiars", "Dispelled Familiars");
        add("key.ars_nouveau.familiar_toggle", "Summon/Dispel Familiar");
        add("ars_nouveau.spell_book_gui.dispel", "Dispel");
        add("tooltip.ars_nouveau.master_tab", "All Items");
        add("ars_nouveau.page1.repository", "A repository can store a double chests worth of items. When named, it will display the name as a tooltip, and preserve it when dropped as an item. Useful for creating named inventory tabs with the Storage Lectern.");
        add("ars_nouveau.storage_tabs", "Storage Tabs");
        add("ars_nouveau.page3.storage", "Linked inventories that are named will create a tab in the Storage Lectern, allowing you to view and manipulate all inventories that share that name. Unlike normal chests, Repositories will preserve their name when dropped. The Name Effect can also name inventories placed in the world.");
        add("ars_nouveau.page2.item_detector", "If a Filter Scroll is given to the Display Case, it will count all items that match the filter.");
        add("config.jade.plugin_ars_nouveau.mob_jar", "Mob Jar");
        add("mob_jar.villager","Can be traded with in a jar, periodically resetting its trades.");
        add("mob_jar.piglin", "Can be traded with by throwing gold ingots at the jar.");
        add("mob_jar.ender_dragon", "Use a bottle to obtain Dragon's Breath.");
        add("mob_jar.sheep", "Can be sheared. Will eat Grass beneath the jar if available.");
        add("mob_jar.chicken", "Will occasionally lay eggs.");
        add("mob_jar.cow", "Can be milked.");
        add("mob_jar.mooshroom", "Can use a bowl to obtain mushroom stew. Can be sheared into a normal cow.");
        add("mob_jar.pufferfish", "Will inflate when mobs are nearby. While inflated, the jar produces a redstone signal.");
        add("mob_jar.frog", "Will eat nearby slimes.");
        add("mob_jar.panda", "Baby pandas will occasionally sneeze, creating Slimeballs. Sick Pandas will sneeze more often.");
        add("mob_jar.allay.title", "Allay Behavior");
        add("mob_jar.allay", "A jarred Allay can pickup and deposit items within 5 blocks of the jar. Giving an Allay an item will cause it to only pickup that item. Giving an Allay an Item Scroll will pickup any item that matches the scroll. Items will be deposited into inventories placed adjacent to the jar. Allays will also respect any filters placed on the adjacent inventories.");
        add("ars_nouveau.cauldron.num_bounded", "%s bounded inventories");
        add("ars_nouveau.wixie_cauldron.bound", "Inventory bound.");
        add("ars_nouveau.wixie_cauldron.removed", "Inventory removed.");
        add("ars_nouveau.wixie_cauldron.cleared", "Bound inventories cleared.");
        add("ars_nouveau.binding_inventories", "Binding Inventories");
        add("ars_nouveau.page7.wixie_charm", "You can select specific inventories for the wixie by using a dominion wand on an inventory, and then the cauldron. If any inventories are selected, only these inventories can be used and the Wixie will no longer pull from all nearby inventories by default.");
        add("tooltip.ars_nouveau.direction_0", "Sorting Descending");
        add("tooltip.ars_nouveau.direction_1", "Sorting Ascending");
        add("tooltip.ars_nouveau.clear_grid", "Clear");
        add("tooltip.ars_nouveau.open_recipe", "Recipe Book");
        add("ars_nouveau.color_gui.rainbow", "Rainbow");
        add("ars_nouveau.adopter", "Adopted by %s");
        add("entity.ars_nouveau.lily", "Lily");
        add("ars_nouveau.lily", "Patrons may summon Lily, a faithful tail wagging companion.");
        add("ars_nouveau.settings.summon_lily", "Summon Lily");
        add("ars_nouveau.settings.unsummon_lily", "Unsummon Lily");
        add("ars_nouveau.rewards.enabled", "Ars Nouveau supporter rewards enabled, thank you! Rewards can be accessed in the Settings page of the spell book.");
        add("mob_jar.dummy", "A player dummy in a jar will attract nearby mobs.");
        add("ars_nouveau.turret.tooltip", "Can be rotated to face any direction. Use a dominion wand on the turret, and then on the target block.");
        add("ars_nouveau.scribes_table.auto_take_disabled", "Auto Take Disabled");
        add("ars_nouveau.alert.turret_needs_form", "Spell must have a form.");
        add("item.ars_nouveau.music_disc_thistle_the_sound_of_glass", "Music Disc");
        add("item.ars_nouveau.music_disc_thistle_the_sound_of_glass.desc", "Thistle - The Sound of Glass");
        add("item.ars_nouveau.music_disc_firel_the_wild_hunt", "Music Disc");
        add("item.ars_nouveau.music_disc_firel_the_wild_hunt.desc", "Firel - The Wild Hunt");
        for(String s : LibBlockNames.DECORATIVE_SOURCESTONE){
            String key = "block.ars_nouveau." + s;
            String val = data.get(key);
            add(key + "_slab", val + " Slab");
            add(key + "_stairs", val + " Stairs");
        }
    }

    @Override
    public void add(Item key, String name) {
        super.add(key, name);
    }

    @Override
    public void add(String key, String value) {
        super.add(key, value);
        data.put(key, value);
    }
}
