package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;

public class LightTile extends ModdedTile {

    public ParticleColor color = ParticleColor.defaultParticleColor();

    public LightTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.LIGHT_TILE, pos, state);
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.color = ParticleColor.deserialize(nbt.getCompound("color"));
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("color", color.serialize());
    }
}
