package com.hollingsworth.arsnouveau.api.spell;

import net.minecraft.network.chat.TranslatableComponent;

import java.util.HashSet;
import java.util.Set;

/**
 * A school that spell parts belong to.
 * NOTE: A spell being in a sub-school is also considered part of the parent school.
 */
public class SpellSchool {
    private final String id;
    private Set<SpellSchool> subSchools = new HashSet<>();
    private Set<AbstractSpellPart> spellParts = new HashSet<>();

    public SpellSchool(String id){
        this.id = id;
    }

    public boolean isPartOfSchool(AbstractSpellPart part){
        if(getSpellParts().contains(part))
            return true;
        for(SpellSchool spellSchool : getSubSchools()){
            if(spellSchool.getSpellParts().contains(part))
                return true;
        }
        return false;
    }

    public boolean addSpellPart(AbstractSpellPart spellPart){
        return getSpellParts().add(spellPart);
    }

    public TranslatableComponent getTextComponent(){
        return new TranslatableComponent("ars_nouveau.school." + getId());
    }

    public String getId() {
        return id;
    }

    public Set<SpellSchool> getSubSchools() {
        return subSchools;
    }

    public void setSubSchools(Set<SpellSchool> subSchools) {
        this.subSchools = subSchools;
    }

    public SpellSchool withSubSchool(SpellSchool spellSchool){
        this.getSubSchools().add(spellSchool);
        return this;
    }

    public Set<AbstractSpellPart> getSpellParts() {
        return spellParts;
    }

    public void setSpellParts(Set<AbstractSpellPart> spellParts) {
        this.spellParts = spellParts;
    }
}
