/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.ANExplosion;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;

public class EffectExplosion
extends AbstractEffect {
    public static EffectExplosion INSTANCE = new EffectExplosion();
    public ForgeConfigSpec.DoubleValue BASE;
    public ForgeConfigSpec.DoubleValue AOE_BONUS;
    public ForgeConfigSpec.DoubleValue AMP_DAMAGE;

    private EffectExplosion() {
        super("explosion", "Explosion");
    }

    @Override
    public void onResolve(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        Vec3 vec = this.safelyGetHitPos(rayTraceResult);
        double intensity = (Double)this.BASE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier() + (Double)this.AOE_BONUS.get() * (double)spellStats.getBuffCount(AugmentAOE.INSTANCE);
        int dampen = spellStats.getBuffCount(AugmentDampen.INSTANCE);
        Explosion.BlockInteraction mode = dampen > 0 ? Explosion.BlockInteraction.NONE : Explosion.BlockInteraction.DESTROY;
        mode = spellStats.hasBuff(AugmentExtract.INSTANCE) ? Explosion.BlockInteraction.BREAK : mode;
        this.explode(world, (Entity)shooter, null, null, vec.f_82479_, vec.f_82480_, vec.f_82481_, (float)(intensity -= 0.5 * (double)dampen), false, mode, spellStats.getAmpMultiplier());
    }

    public Explosion explode(Level world, @Nullable Entity e, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator context, double x, double y, double z, float radius, boolean p_230546_11_, Explosion.BlockInteraction p_230546_12_, double amp) {
        ANExplosion explosion = new ANExplosion(world, e, source, context, x, y, z, radius, p_230546_11_, p_230546_12_, amp);
        explosion.baseDamage = (Double)this.DAMAGE.get();
        explosion.ampDamageScalar = (Double)this.AMP_DAMAGE.get();
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return explosion;
        }
        explosion.m_46061_();
        explosion.m_46075_(false);
        if (p_230546_12_ == Explosion.BlockInteraction.NONE) {
            explosion.m_46080_();
        }
        for (Player serverplayerentity : world.m_6907_()) {
            if (!(serverplayerentity.m_20275_(x, y, z) < 4096.0)) continue;
            ((ServerPlayer)serverplayerentity).f_8906_.m_141995_((Packet)new ClientboundExplodePacket(x, y, z, radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverplayerentity)));
        }
        return explosion;
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addAmpConfig(builder, 0.5);
        this.BASE = builder.comment("Explosion base intensity").defineInRange("base", 0.75, 0.0, 100.0);
        this.AOE_BONUS = builder.comment("AOE intensity bonus").defineInRange("aoe_bonus", 1.5, 0.0, 100.0);
        this.addDamageConfig(builder, 6.0);
        this.AMP_DAMAGE = builder.comment("Additional damage per amplify").defineInRange("amp_damage", 2.5, 0.0, 2.147483647E9);
    }

    @Override
    public int getDefaultManaCost() {
        return 200;
    }

    @Override
    public SpellTier getTier() {
        return SpellTier.TWO;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentAOE.INSTANCE, AugmentExtract.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Causes an explosion at the location. Amplify increases the damage and size by a small amount, while AOE will increase the size of the explosion by a large amount, but not damage.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_FIRE);
    }
}

