/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectCrush
extends AbstractEffect {
    public static EffectCrush INSTANCE = new EffectCrush();

    private EffectCrush() {
        super("crush", "Crush");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        List recipes = world.m_7465_().m_44013_(RecipeRegistry.CRUSH_TYPE);
        CrushRecipe lastHit = null;
        for (BlockPos p : SpellUtil.calcAOEBlocks(shooter, rayTraceResult.m_82425_(), rayTraceResult, spellStats.getBuffCount(AugmentAOE.INSTANCE), spellStats.getBuffCount(AugmentPierce.INSTANCE))) {
            BlockState state = world.m_8055_(p);
            Item item = state.m_60734_().m_5456_();
            if (lastHit == null || !lastHit.matches(item.m_7968_(), world)) {
                lastHit = null;
                for (CrushRecipe recipe : recipes) {
                    if (!recipe.matches(item.m_7968_(), world)) continue;
                    lastHit = recipe;
                    break;
                }
            }
            if (lastHit == null) continue;
            List<ItemStack> outputs = lastHit.getRolledOutputs(world.f_46441_);
            boolean placedBlock = false;
            for (ItemStack i : outputs) {
                if (!placedBlock && i.m_41720_() instanceof BlockItem) {
                    world.m_46597_(p, ((BlockItem)i.m_41720_()).m_40614_().m_49966_());
                    i.m_41774_(1);
                    placedBlock = true;
                }
                if (i.m_41619_()) continue;
                world.m_7967_((Entity)new ItemEntity(world, (double)p.m_123341_() + 0.5, (double)p.m_123342_(), (double)p.m_123343_() + 0.5, i));
            }
            if (placedBlock) continue;
            world.m_46597_(p, Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        this.dealDamage(world, shooter, (float)((rayTraceResult.m_82443_().m_6069_() ? (Double)this.DAMAGE.get() * 3.0 : (Double)this.DAMAGE.get()) + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier()), spellStats, rayTraceResult.m_82443_(), DamageSource.f_19311_);
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 3.0);
        this.addAmpConfig(builder, 1.0);
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentFortune.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Turns stone into gravel, and gravel into sand. Will also crush flowers into bonus dye. For full recipe support, see JEI. Will also harm entities and deals bonus damage to entities that are swimming.";
    }

    @Override
    public int getDefaultManaCost() {
        return 30;
    }

    @Override
    public SpellTier getTier() {
        return SpellTier.TWO;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_EARTH);
    }
}

