/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.common.mixin.ExpInvokerMixin;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RitualDisintegration
extends AbstractRitual {
    @Override
    public void onStart() {
        super.onStart();
        if (this.tile == null) {
            return;
        }
    }

    @Override
    protected void tick() {
        Level world = this.getWorld();
        if (world.f_46443_) {
            BlockPos pos = this.getPos();
            for (int i = 0; i < 100; ++i) {
                Vec3 particlePos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.5, 0.0, 0.5);
                particlePos = particlePos.m_82549_(ParticleUtil.pointInSphere().m_82542_(5.0, 5.0, 5.0));
                world.m_7106_(ParticleLineData.createData(this.getCenterColor()), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
            }
        }
        if (!world.f_46443_ && world.m_46467_() % 60L == 0L) {
            boolean didWorkOnce = false;
            List entityList = world.m_6443_(LivingEntity.class, new AABB(this.getPos()).m_82400_(5.0), m -> (m.getClassification(false).equals((Object)MobCategory.MONSTER) || m.m_6095_().m_20609_(EntityTags.DISINTEGRATION_WHITELIST)) && !(m instanceof Player));
            for (LivingEntity m2 : entityList) {
                int numLesser;
                int numGreater;
                int exp;
                if (m2.m_6095_().m_20609_(EntityTags.DISINTEGRATION_BLACKLIST)) continue;
                m2.m_142687_(Entity.RemovalReason.DISCARDED);
                if (!m2.m_146910_()) continue;
                ExpInvokerMixin invoker = (ExpInvokerMixin)m2;
                ParticleUtil.spawnPoof((ServerLevel)world, m2.m_142538_());
                if (!invoker.an_shouldDropExperience() || (exp = invoker.an_getExperienceReward((Player)ANFakePlayer.getPlayer((ServerLevel)this.getWorld())) * 2) <= 0) continue;
                if ((exp -= (numGreater = exp / 12) * 12) - (numLesser = exp / 3) * 3 > 0) {
                    ++numLesser;
                }
                world.m_7967_((Entity)new ItemEntity(world, (double)m2.m_142538_().m_123341_(), (double)m2.m_142538_().m_123342_(), (double)m2.m_142538_().m_123343_(), new ItemStack((ItemLike)ItemsRegistry.GREATER_EXPERIENCE_GEM, numGreater)));
                world.m_7967_((Entity)new ItemEntity(world, (double)m2.m_142538_().m_123341_(), (double)m2.m_142538_().m_123342_(), (double)m2.m_142538_().m_123343_(), new ItemStack((ItemLike)ItemsRegistry.EXPERIENCE_GEM, numLesser)));
                didWorkOnce = true;
            }
            if (didWorkOnce) {
                this.setNeedsMana(true);
            }
        }
    }

    @Override
    public int getManaCost() {
        return 300;
    }

    @Override
    public String getLangName() {
        return "Disintegration";
    }

    @Override
    public String getLangDescription() {
        return "Destroys nearby monsters and converts them into Experience Gems worth twice as much experience. Monsters destroyed this way will not drop items. This ritual consumes source each time a monster is destroyed.";
    }

    @Override
    public ParticleColor getCenterColor() {
        return ParticleColor.makeRandomColor(220, 20, 20, this.rand);
    }

    @Override
    public String getID() {
        return "disintegration";
    }
}

