/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem;

import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class HarvestClusterGoal
extends Goal {
    public AmethystGolem golem;
    public Supplier<Boolean> canUse;
    int tickTime;
    boolean isDone;
    List<BlockPos> harvestableList = new ArrayList<BlockPos>();

    public HarvestClusterGoal(AmethystGolem golem, Supplier<Boolean> canUse) {
        this.golem = golem;
        this.canUse = canUse;
    }

    public void m_8037_() {
        super.m_8037_();
        --this.tickTime;
        this.golem.m_21573_().m_26573_();
        if (this.tickTime % 40 == 0) {
            this.tryDropAmethyst();
        }
        if (this.tickTime <= 0 || this.harvestableList.isEmpty()) {
            this.isDone = true;
            this.golem.setStomping(false);
            this.golem.harvestCooldown = 1200;
        }
    }

    public void tryDropAmethyst() {
        ArrayList<BlockPos> harvested = new ArrayList<BlockPos>();
        for (BlockPos p : this.harvestableList) {
            if (!this.hasCluster(p)) continue;
            harvested.add(p);
            this.harvest(p);
            break;
        }
        for (BlockPos p : harvested) {
            this.harvestableList.remove(p);
        }
    }

    public void harvest(BlockPos p) {
        for (Direction d : Direction.values()) {
            if (this.golem.f_19853_.m_8055_(p.m_142300_(d)).m_60734_() != Blocks.f_152492_) continue;
            this.golem.f_19853_.m_7731_(p.m_142300_(d), Blocks.f_50016_.m_49966_(), 3);
            this.golem.f_19853_.m_7967_((Entity)new ItemEntity(this.golem.f_19853_, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, new ItemStack((ItemLike)Items.f_151049_, 4)));
        }
    }

    public boolean hasCluster(BlockPos p) {
        for (Direction d : Direction.values()) {
            if (this.golem.f_19853_.m_8055_(p.m_142300_(d)).m_60734_() != Blocks.f_152492_) continue;
            return true;
        }
        return false;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.golem.setStomping(true);
        this.golem.m_21573_().m_26573_();
        this.isDone = false;
        this.harvestableList = new ArrayList<BlockPos>(this.golem.buddingBlocks);
        Collections.shuffle(this.harvestableList);
        this.tickTime = 130;
    }

    public void m_8041_() {
        this.golem.setStomping(false);
    }

    public boolean m_8045_() {
        return !this.isDone;
    }

    public boolean m_8036_() {
        return this.canUse.get() != false && !this.golem.buddingBlocks.isEmpty();
    }
}

