/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.DiveAttackGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.FlyHelper;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.LeapGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wilden.WildenMeleeAttack;
import com.hollingsworth.arsnouveau.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WildenStalker
extends Monster
implements IAnimatable,
IAnimationListener {
    int leapCooldown;
    public Vec3 orbitOffset = Vec3.f_82478_;
    public BlockPos orbitPosition = BlockPos.f_121853_;
    public static final EntityDataAccessor<Boolean> isFlying = SynchedEntityData.m_135353_(WildenStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int timeFlying;
    AnimationController flyController;
    AnimationController groundController;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public WildenStalker(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyHelper(this);
    }

    public WildenStalker(Level worldIn) {
        this(ModEntities.WILDEN_STALKER, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new LeapGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DiveAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(5, (Goal)new WildenMeleeAttack((PathfinderMob)this, 1.3, true, Animations.ATTACK.ordinal(), () -> !this.isFlying()));
        this.f_21345_.m_25352_(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (((Boolean)Config.STALKER_ATTACK_ANIMALS.get()).booleanValue()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, entity -> !(entity instanceof SummonWolf) || !((SummonWolf)entity).isWildenSummon));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.leapCooldown > 0) {
                --this.leapCooldown;
            }
            if (this.isFlying() && this.m_20096_()) {
                this.setFlying(false);
            }
            this.timeFlying = this.isFlying() ? ++this.timeFlying : 0;
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && entityIn instanceof LivingEntity && this.f_19853_.m_46791_() == Difficulty.HARD) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 0));
        }
        return super.m_7327_(entityIn);
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return 0;
    }

    public int getLeapCooldown() {
        return this.leapCooldown;
    }

    public void setLeapCooldown(int leapCooldown) {
        this.leapCooldown = leapCooldown;
    }

    protected int m_6552_(Player player) {
        return 8;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    public void startAnimation(int arg) {
        try {
            if (arg == Animations.DIVE.ordinal()) {
                this.flyController.markNeedsReload();
                this.flyController.setAnimation(new AnimationBuilder().addAnimation("dive", Boolean.valueOf(true)));
            }
            if (arg == Animations.FLY.ordinal()) {
                this.flyController.markNeedsReload();
                this.flyController.setAnimation(new AnimationBuilder().addAnimation("flying", Boolean.valueOf(true)));
            }
            if (arg == Animations.ATTACK.ordinal()) {
                if (this.groundController.getCurrentAnimation() != null && this.groundController.getCurrentAnimation().animationName.equals("attack")) {
                    return;
                }
                this.groundController.markNeedsReload();
                this.groundController.setAnimation(new AnimationBuilder().addAnimation("attack", Boolean.valueOf(false)).addAnimation("idle"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <E extends Entity> PlayState flyPredicate(AnimationEvent event) {
        return this.isFlying() ? PlayState.CONTINUE : PlayState.STOP;
    }

    private <E extends Entity> PlayState groundPredicate(AnimationEvent e) {
        return this.isFlying() ? PlayState.STOP : PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        this.flyController = new AnimationController((IAnimatable)this, "flyController", 1.0f, this::flyPredicate);
        animationData.addAnimationController(this.flyController);
        this.groundController = new AnimationController((IAnimatable)this, "groundController", 1.0f, this::groundPredicate);
        animationData.addAnimationController(this.groundController);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (!this.isFlying()) {
            super.m_7840_(y, onGroundIn, state, pos);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (!this.isFlying()) {
            super.m_7023_(travelVector);
            return;
        }
        if (this.m_20069_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            BlockPos ground = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            float f = 0.91f;
            if (this.f_19861_) {
                f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.f_19861_) {
                f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            this.m_19920_(this.f_19861_ ? 0.1f * f1 : 0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
        this.m_21043_((LivingEntity)this, false);
    }

    public static AttributeSupplier.Builder getModdedAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.7).m_22268_(Attributes.f_22281_, 2.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(isFlying, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(isFlying);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(isFlying, (Object)flying);
    }

    public static enum Animations {
        ATTACK,
        DIVE,
        FLY;

    }
}

