/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib3.core.easing.EasingManager;
import software.bernie.geckolib3.core.easing.EasingType;

public class EntityFlyingItem
extends ColoredProjectile {
    public static final EntityDataAccessor<BlockPos> to = SynchedEntityData.m_135353_(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<BlockPos> from = SynchedEntityData.m_135353_(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Boolean> SPAWN_TOUCH = SynchedEntityData.m_135353_(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int age;
    int maxAge;
    public static final EntityDataAccessor<ItemStack> HELD_ITEM = SynchedEntityData.m_135353_(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Float> OFFSET = SynchedEntityData.m_135353_(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> DIDOFFSET = SynchedEntityData.m_135353_(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    boolean wentUp;

    public EntityFlyingItem(Level worldIn, Vec3 from, Vec3 to) {
        this(ModEntities.ENTITY_FLYING_ITEM, worldIn);
        this.f_19804_.m_135381_(EntityFollowProjectile.to, (Object)new BlockPos(to));
        this.f_19804_.m_135381_(EntityFollowProjectile.from, (Object)new BlockPos(from));
        this.maxAge = (int)Math.floor(from.m_82546_(to).m_82553_() * 5.0);
        this.m_6034_(from.f_82479_ + 0.5, from.f_82480_, from.f_82481_ + 0.5);
        this.f_19804_.m_135381_(RED, (Object)255);
        this.f_19804_.m_135381_(GREEN, (Object)25);
        this.f_19804_.m_135381_(BLUE, (Object)180);
    }

    public EntityFlyingItem(Level worldIn, BlockPos from, BlockPos to) {
        this(worldIn, new Vec3((double)from.m_123341_(), (double)from.m_123342_(), (double)from.m_123343_()), new Vec3((double)to.m_123341_(), (double)to.m_123342_(), (double)to.m_123343_()));
    }

    public EntityFlyingItem(Level worldIn, BlockPos from, BlockPos to, int r, int g, int b) {
        this(worldIn, new Vec3((double)from.m_123341_(), (double)from.m_123342_(), (double)from.m_123343_()), new Vec3((double)to.m_123341_(), (double)to.m_123342_(), (double)to.m_123343_()));
        this.f_19804_.m_135381_(RED, (Object)r);
        this.f_19804_.m_135381_(GREEN, (Object)g);
        this.f_19804_.m_135381_(BLUE, (Object)b);
    }

    public EntityFlyingItem(EntityType<EntityFlyingItem> entityAOEProjectileEntityType, Level world) {
        super(entityAOEProjectileEntityType, world);
    }

    public void setStack(ItemStack stack) {
        this.f_19804_.m_135381_(HELD_ITEM, (Object)stack.m_41777_());
    }

    public static float lerp(double percentCompleted, double startValue, double endValue, EasingType type) {
        if (percentCompleted >= 1.0) {
            return (float)endValue;
        }
        percentCompleted = EasingManager.ease((double)percentCompleted, (EasingType)type, null);
        return (float)EntityFlyingItem.lerpInternal(percentCompleted, startValue, endValue);
    }

    public static double lerpInternal(double pct, double start, double end) {
        return start + pct * (end - start);
    }

    public double normalize(double value, double min, double max) {
        return 1.0 - (value - min) / (max - min);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.age;
        if (this.age > 400) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        Vec3 vec3d2 = this.m_20184_();
        BlockPos start = (BlockPos)this.f_19804_.m_135370_(from);
        BlockPos end = (BlockPos)this.f_19804_.m_135370_(to);
        if (BlockUtil.distanceFrom(this.m_142538_(), end) < 1.0 || this.age > 1000 || BlockUtil.distanceFrom(this.m_142538_(), end) > 16.0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            if (this.f_19853_.f_46443_ && ((Boolean)this.f_19804_.m_135370_(SPAWN_TOUCH)).booleanValue()) {
                ParticleUtil.spawnTouch((ClientLevel)this.f_19853_, end, new ParticleColor((Integer)this.f_19804_.m_135370_(RED), (Integer)this.f_19804_.m_135370_(GREEN), (Integer)this.f_19804_.m_135370_(BLUE)));
            }
            return;
        }
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        double time = 1.0 - this.normalize(this.age, 0.0, 80.0);
        EasingType type = EasingType.NONE;
        double startY = start.m_123342_();
        double endY = (double)end.m_123342_() + this.getDistanceAdjustment(start, end);
        double lerpX = EntityFlyingItem.lerp(time, (double)start.m_123341_() + 0.5, (double)end.m_123341_() + 0.5, type);
        double lerpY = EntityFlyingItem.lerp(time, EntityFlyingItem.lerp(time, startY, endY, type), EntityFlyingItem.lerp(time, endY, startY, type), type);
        double lerpZ = EntityFlyingItem.lerp(time, (double)start.m_123343_() + 0.5, (double)end.m_123343_() + 0.5, type);
        BlockPos adjustedPos = new BlockPos(posX, (double)end.m_123342_(), posZ);
        if (BlockUtil.distanceFrom(adjustedPos, end) <= 0.5) {
            posY = this.m_20186_() - 0.05;
            this.m_6034_(lerpX, posY, lerpZ);
        } else {
            this.m_6034_(lerpX, lerpY, lerpZ);
        }
        if (this.f_19853_.f_46443_ && this.age > 1) {
            double deltaX = this.m_20185_() - this.f_19790_;
            double deltaY = this.m_20186_() - this.f_19791_;
            double deltaZ = this.m_20189_() - this.f_19792_;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
            int counter = 0;
            for (double i = 0.0; i < dist; i += 1.0) {
                double coeff = i / dist;
                if ((counter += this.f_19853_.f_46441_.nextInt(3)) % (Minecraft.m_91087_().f_91066_.f_92073_.m_92198_() == 0 ? 1 : 2 * Minecraft.m_91087_().f_91066_.f_92073_.m_92198_()) != 0) continue;
                this.f_19853_.m_7106_(GlowParticleData.createData(new ParticleColor((Integer)this.f_19804_.m_135370_(RED), (Integer)this.f_19804_.m_135370_(GREEN), (Integer)this.f_19804_.m_135370_(BLUE))), (double)((float)(this.f_19854_ + deltaX * coeff)), (double)((float)(this.f_19855_ + deltaY * coeff)), (double)((float)(this.f_19856_ + deltaZ * coeff)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)));
            }
        }
    }

    public EntityFlyingItem withNoTouch() {
        this.f_19804_.m_135381_(SPAWN_TOUCH, (Object)false);
        return this;
    }

    public void setDistanceAdjust(float offset) {
        this.f_19804_.m_135381_(OFFSET, (Object)Float.valueOf(offset));
        this.f_19804_.m_135381_(DIDOFFSET, (Object)true);
    }

    private double getDistanceAdjustment(BlockPos start, BlockPos end) {
        if (((Boolean)this.f_19804_.m_135370_(DIDOFFSET)).booleanValue()) {
            return ((Float)this.f_19804_.m_135370_(OFFSET)).floatValue();
        }
        double distance = BlockUtil.distanceFrom(start, end);
        if (distance <= 1.5) {
            return 2.5;
        }
        return 3.0;
    }

    @Override
    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        if (compound.m_128441_("item")) {
            this.f_19804_.m_135381_(HELD_ITEM, (Object)ItemStack.m_41712_((CompoundTag)compound.m_128469_("item")));
        }
        this.age = compound.m_128451_("age");
        this.f_19804_.m_135381_(DIDOFFSET, (Object)compound.m_128471_("didoffset"));
        this.f_19804_.m_135381_(OFFSET, (Object)Float.valueOf(compound.m_128457_("offset")));
        this.f_19804_.m_135381_(EntityFollowProjectile.from, (Object)NBTUtil.getBlockPos(compound, "from"));
        this.f_19804_.m_135381_(EntityFollowProjectile.to, (Object)NBTUtil.getBlockPos(compound, "to"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getStack() != null) {
            CompoundTag tag = new CompoundTag();
            this.getStack().m_41739_(tag);
            compound.m_128365_("item", (Tag)tag);
        }
        compound.m_128405_("age", this.age);
        compound.m_128379_("didoffset", ((Boolean)this.f_19804_.m_135370_(DIDOFFSET)).booleanValue());
        compound.m_128350_("offset", ((Float)this.f_19804_.m_135370_(OFFSET)).floatValue());
        if (from != null) {
            NBTUtil.storeBlockPos(compound, "from", (BlockPos)this.f_19804_.m_135370_(EntityFollowProjectile.from));
        }
        if (to != null) {
            NBTUtil.storeBlockPos(compound, "to", (BlockPos)this.f_19804_.m_135370_(EntityFollowProjectile.to));
        }
    }

    public ItemStack getStack() {
        return (ItemStack)this.f_19804_.m_135370_(HELD_ITEM);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HELD_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DIDOFFSET, (Object)false);
        this.f_19804_.m_135372_(to, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(from, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(SPAWN_TOUCH, (Object)true);
    }

    public EntityType<?> m_6095_() {
        return ModEntities.ENTITY_FLYING_ITEM;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityFlyingItem(PlayMessages.SpawnEntity packet, Level world) {
        super(ModEntities.ENTITY_FLYING_ITEM, world);
    }
}

