/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.IPlaceBlockResponder;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.ISpellCasterProvider;
import com.hollingsworth.arsnouveau.api.spell.TurretSpellCaster;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class BasicSpellTurretTile
extends ModdedTile
implements IPickupResponder,
IPlaceBlockResponder,
ITooltipProvider,
IAnimatable,
IAnimationListener,
ITickable,
ISpellCasterProvider {
    boolean playRecoil;
    public TurretSpellCaster spellCaster = new TurretSpellCaster(new CompoundTag());
    AnimationController castController;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public BasicSpellTurretTile(BlockEntityType<?> p_i48289_1_, BlockPos pos, BlockState state) {
        super(p_i48289_1_, pos, state);
    }

    public BasicSpellTurretTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.BASIC_SPELL_TURRET_TILE, pos, state);
    }

    public int getManaCost() {
        return this.spellCaster.getSpell().getCastingCost();
    }

    @Override
    @Nonnull
    public ItemStack onPickup(ItemStack stack) {
        return BlockUtil.insertItemAdjacent(this.f_58857_, this.f_58858_, stack);
    }

    @Override
    public ItemStack onPlaceBlock() {
        return BlockUtil.getItemAdjacent(this.f_58857_, this.f_58858_, stack -> stack.m_41720_() instanceof BlockItem);
    }

    @Override
    public List<IItemHandler> getInventory() {
        return BlockUtil.getAdjacentInventories(this.f_58857_, this.f_58858_);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.spellCaster.serializeOnTag(tag);
    }

    public void m_142466_(CompoundTag tag) {
        this.spellCaster = new TurretSpellCaster(tag);
        super.m_142466_(tag);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        tooltip.add((Component)new TextComponent(new TranslatableComponent("ars_nouveau.spell_turret.casting").getString() + this.spellCaster.getSpell().getDisplayString()));
    }

    public PlayState walkPredicate(AnimationEvent event) {
        if (this.playRecoil) {
            event.getController().clearAnimationCache();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("recoil", Boolean.valueOf(false)));
            this.playRecoil = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        this.castController = new AnimationController((IAnimatable)this, "castController", 0.0f, this::walkPredicate);
        data.addAnimationController(this.castController);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void startAnimation(int arg) {
        this.playRecoil = true;
    }

    public boolean update() {
        if (this.f_58858_ != null && this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
            return true;
        }
        return false;
    }

    @Override
    public ISpellCaster getSpellCaster() {
        return this.spellCaster;
    }

    @Override
    public ISpellCaster getSpellCaster(CompoundTag tag) {
        return this.spellCaster;
    }
}

