/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOpenGlyphCraft;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class ScribesBlock
extends TickableModBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_NORTH_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0, (double)16.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.m_49796_((double)16.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.m_49796_((double)16.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_NORTH_EAST});
    protected static final VoxelShape SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_WEST, LEG_SOUTH_EAST});
    protected static final VoxelShape WEST_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_SOUTH_WEST});
    protected static final VoxelShape EAST_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_EAST, LEG_SOUTH_EAST});
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public ScribesBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_60955_(), "scribes_table");
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public PushReaction m_5537_(BlockState p_149656_1_) {
        return PushReaction.BLOCK;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (world.f_46443_ || handIn != InteractionHand.MAIN_HAND || !(world.m_7702_(pos) instanceof ScribesTile)) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(handIn).m_41720_() instanceof SpellBook && !player.m_6144_()) {
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PacketOpenGlyphCraft(pos));
            return InteractionResult.SUCCESS;
        }
        ScribesTile tile = (ScribesTile)world.m_7702_(pos);
        if (state.m_61143_(PART) != BedPart.HEAD) {
            BlockEntity tileEntity = world.m_7702_(pos.m_142300_(ScribesBlock.getConnectedDirection(state)));
            ScribesTile scribesTile = tile = tileEntity instanceof ScribesTile ? (ScribesTile)tileEntity : null;
            if (tile == null) {
                return InteractionResult.PASS;
            }
        }
        if (!player.m_6144_()) {
            if (tile.consumeStack(player.m_21120_(handIn))) {
                return InteractionResult.SUCCESS;
            }
            if (tile.stack != null && player.m_21120_(handIn).m_41619_()) {
                item = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), tile.stack);
                world.m_7967_((Entity)item);
                tile.stack = null;
            } else if (!player.m_150109_().m_36056_().m_41619_()) {
                if (tile.stack != null) {
                    item = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), tile.stack);
                    world.m_7967_((Entity)item);
                }
                tile.stack = player.m_150109_().m_7407_(player.m_150109_().f_35977_, 1);
            }
            BlockState updateState = world.m_8055_(tile.m_58899_());
            world.m_7260_(tile.m_58899_(), updateState, updateState, 2);
        }
        if (player.m_6144_()) {
            ItemStack stack = tile.stack;
            if (stack == null || stack.m_41619_()) {
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41720_() instanceof IScribeable) {
                ((IScribeable)stack.m_41720_()).onScribe(world, pos, player, handIn, stack);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof ScribesTile) {
            ScribesTile tile = (ScribesTile)blockEntity;
            if (tile.stack != null) {
                worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), tile.stack));
                tile.refundConsumed();
            }
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (!world.f_46443_) {
            BlockPos blockpos = pos.m_142300_((Direction)state.m_61143_((Property)FACING));
            world.m_7731_(blockpos, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
            world.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_196258_1_) {
        Direction direction = p_196258_1_.m_8125_();
        BlockPos blockpos = p_196258_1_.m_8083_();
        BlockPos blockpos1 = blockpos.m_142300_(direction);
        return p_196258_1_.m_43725_().m_8055_(blockpos1).m_60629_(p_196258_1_) ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction) : null;
    }

    public BlockState tearDown(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        BlockEntity entity;
        if (!world.m_5776_() && (entity = world.m_7702_(pos)) instanceof ScribesTile) {
            ScribesTile tile = (ScribesTile)entity;
            if (((ScribesTile)entity).stack != null) {
                world.m_7967_((Entity)new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ((ScribesTile)entity).stack));
                tile.refundConsumed();
            }
        }
        return Blocks.f_50016_.m_49966_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        if (direction == ScribesBlock.getNeighbourDirection((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)FACING))) {
            return state2.m_60713_((Block)this) && state2.m_61143_(PART) != state.m_61143_(PART) ? state : this.tearDown(state, direction, state2, world, pos, pos2);
        }
        return super.m_7417_(state, direction, state2, world, pos, pos2);
    }

    private static Direction getNeighbourDirection(BedPart p_208070_0_, Direction p_208070_1_) {
        return p_208070_0_ == BedPart.FOOT ? p_208070_1_ : p_208070_1_.m_122424_();
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (!(event.getWorld().m_7702_(event.getPos()) instanceof ScribesTile)) {
            return;
        }
        Level world = event.getWorld();
        if (world.m_8055_(pos = event.getPos()).m_60734_() instanceof ScribesBlock) {
            BlockRegistry.SCRIBES_BLOCK.m_6227_(world.m_8055_(pos), world, pos, event.getPlayer(), event.getHand(), null);
            event.setCanceled(true);
        }
    }

    public static Direction getConnectedDirection(BlockState p_226862_0_) {
        Direction direction = (Direction)p_226862_0_.m_61143_((Property)FACING);
        return p_226862_0_.m_61143_(PART) == BedPart.HEAD ? direction.m_122424_() : direction;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        Direction direction = ScribesBlock.getConnectedDirection(p_220053_1_).m_122424_();
        switch (direction) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ScribesTile(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

