/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.keybindings;

import com.hollingsworth.arsnouveau.api.item.ISpellHotkeyListener;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.client.gui.RadialMenu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.keybindings.ModKeyBindings;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketHotkeyPressed;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateCaster;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class KeyHandler {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();

    public static void checkKeysPressed(int key) {
        Item item;
        if (key == ModKeyBindings.OPEN_RADIAL_HUD.getKey().m_84873_() && KeyHandler.MINECRAFT.f_91080_ instanceof GuiRadialMenu) {
            KeyHandler.MINECRAFT.f_91074_.m_6915_();
            return;
        }
        LocalPlayer player = KeyHandler.MINECRAFT.f_91074_;
        InteractionHand hand = StackUtil.getHeldCasterTool((Player)player);
        if (hand == null) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ISpellHotkeyListener)) {
            return;
        }
        ISpellHotkeyListener hotkeyListener = (ISpellHotkeyListener)item;
        if (key == ModKeyBindings.NEXT_SLOT.getKey().m_84873_()) {
            KeyHandler.sendHotkeyPacket(PacketHotkeyPressed.Key.NEXT);
            return;
        }
        if (key == ModKeyBindings.PREVIOUS_SLOT.getKey().m_84873_()) {
            KeyHandler.sendHotkeyPacket(PacketHotkeyPressed.Key.PREVIOUS);
            return;
        }
        if (key == ModKeyBindings.OPEN_RADIAL_HUD.getKey().m_84873_() && KeyHandler.MINECRAFT.f_91080_ == null) {
            hotkeyListener.onRadialKeyPressed(stack, (Player)player);
            return;
        }
        if (key == ModKeyBindings.OPEN_BOOK.getKey().m_84873_()) {
            if (KeyHandler.MINECRAFT.f_91080_ instanceof GuiSpellBook && !((GuiSpellBook)KeyHandler.MINECRAFT.f_91080_).spell_name.m_93696_()) {
                KeyHandler.MINECRAFT.f_91074_.m_6915_();
                return;
            }
            if (KeyHandler.MINECRAFT.f_91080_ == null) {
                hotkeyListener.onOpenBookMenuKeyPressed(stack, (Player)player);
            }
        }
    }

    @SubscribeEvent
    public static void mouseEvent(InputEvent.MouseInputEvent event) {
        if (KeyHandler.MINECRAFT.f_91074_ == null || KeyHandler.MINECRAFT.f_91080_ != null || event.getAction() != 1) {
            return;
        }
        KeyHandler.checkKeysPressed(event.getButton());
    }

    @SubscribeEvent
    public static void keyEvent(InputEvent.KeyInputEvent event) {
        if (KeyHandler.MINECRAFT.f_91074_ == null || KeyHandler.MINECRAFT.f_91080_ != null || event.getAction() != 1) {
            return;
        }
        KeyHandler.checkKeysPressed(event.getKey());
    }

    public static void sendUpdatePacket(ItemStack stack, int newMode) {
        ISpellCaster caster = CasterUtil.getCaster(stack);
        String recipe = caster.getSpell(newMode).serialize();
        String name = caster.getSpellName(newMode);
        Networking.INSTANCE.sendToServer((Object)new PacketUpdateCaster(recipe, newMode, name));
    }

    public static void sendHotkeyPacket(PacketHotkeyPressed.Key key) {
        Networking.INSTANCE.sendToServer((Object)new PacketHotkeyPressed(key));
    }
}

