/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.util.SpellPartConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class AbstractSpellPart
implements Comparable<AbstractSpellPart> {
    private String id;
    public String name;
    public List<SpellSchool> spellSchools = new CopyOnWriteArrayList<SpellSchool>();
    public Set<AbstractAugment> compatibleAugments = ConcurrentHashMap.newKeySet();
    @Nullable
    public ForgeConfigSpec CONFIG;
    @Nullable
    public ForgeConfigSpec.IntValue COST;
    @Nullable
    public ForgeConfigSpec.BooleanValue ENABLED;
    @Nullable
    public ForgeConfigSpec.BooleanValue STARTER_SPELL;
    @Nullable
    public ForgeConfigSpec.IntValue PER_SPELL_LIMIT;
    public SpellPartConfigUtil.AugmentLimits augmentLimits;

    public String getId() {
        return this.id;
    }

    public String getIcon() {
        return this.id + ".png";
    }

    protected AbstractSpellPart(String id, String name) {
        this.id = id;
        this.name = name;
        for (SpellSchool spellSchool : this.getSchools()) {
            spellSchool.addSpellPart(this);
            this.spellSchools.add(spellSchool);
        }
        this.compatibleAugments.addAll(this.getCompatibleAugments());
    }

    public abstract int getDefaultManaCost();

    public int getConfigCost() {
        return this.COST == null ? this.getDefaultManaCost() : ((Integer)this.COST.get()).intValue();
    }

    public String getName() {
        return this.name;
    }

    public SpellTier getTier() {
        return SpellTier.ONE;
    }

    @Deprecated
    @Nonnull
    public abstract Set<AbstractAugment> getCompatibleAugments();

    protected Set<AbstractAugment> augmentSetOf(AbstractAugment ... augments) {
        return this.setOf(augments);
    }

    @Deprecated
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[0]);
    }

    protected <T> Set<T> setOf(T ... list) {
        return Set.of(list);
    }

    @Override
    public int compareTo(AbstractSpellPart o) {
        return this.getTier().value - o.getTier().value;
    }

    public TranslatableComponent getBookDescLang() {
        return new TranslatableComponent("ars_nouveau.glyph_desc." + this.getId());
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("General settings").push("general");
        this.ENABLED = builder.comment("Is Enabled?").define("enabled", true);
        this.COST = builder.comment("Cost").defineInRange("cost", this.getDefaultManaCost(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.STARTER_SPELL = builder.comment("Is Starter Glyph?").define("starter", this.defaultedStarterGlyph());
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
    }

    public int getAugmentLimit(String augmentTag) {
        if (this.augmentLimits == null) {
            return Integer.MAX_VALUE;
        }
        return this.augmentLimits.getAugmentLimit(augmentTag);
    }

    protected void buildAugmentLimitsConfig(ForgeConfigSpec.Builder builder, Map<String, Integer> defaults) {
        this.augmentLimits = SpellPartConfigUtil.buildAugmentLimitsConfig(builder, defaults);
    }

    protected Map<String, Integer> getDefaultAugmentLimits() {
        return new HashMap<String, Integer>();
    }

    public boolean defaultedStarterGlyph() {
        return false;
    }

    public String getItemID() {
        return "glyph_" + this.getId();
    }

    public String getBookDescription() {
        return "";
    }

    public String getLocalizationKey() {
        return "ars_nouveau.glyph_name." + this.id;
    }

    public String getLocaleName() {
        return new TranslatableComponent(this.getLocalizationKey()).getString();
    }
}

