/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api;

import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.recipe.PotionIngredient;
import com.hollingsworth.arsnouveau.api.recipe.VanillaPotionRecipe;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.IScryer;
import com.hollingsworth.arsnouveau.api.sound.SpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.spell.validation.StandardSpellValidator;
import com.hollingsworth.arsnouveau.setup.Config;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;

public class ArsNouveauAPI {
    private ConcurrentHashMap<String, AbstractSpellPart> spellpartMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AbstractRitual> ritualMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AbstractFamiliarHolder> familiarHolderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Glyph> glyphItemMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, FamiliarScript> familiarScriptMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, RitualTablet> ritualParchmentMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, IScryer> scryerMap = new ConcurrentHashMap();
    private Set<RecipeType<? extends IEnchantingRecipe>> enchantingRecipeTypes = ConcurrentHashMap.newKeySet();
    private ConcurrentHashMap<ResourceLocation, SpellSound> spellSoundsRegistry = new ConcurrentHashMap();
    private ISpellValidator craftingSpellValidator;
    private ISpellValidator castingSpellValidator;
    private List<IEnchantingRecipe> enchantingApparatusRecipes = new ArrayList<IEnchantingRecipe>();
    public List<VanillaPotionRecipe> vanillaPotionRecipes = new ArrayList<VanillaPotionRecipe>();
    private List<BrewingRecipe> brewingRecipes = new ArrayList<BrewingRecipe>();
    private static final ArsNouveauAPI ARS_NOUVEAU_API = new ArsNouveauAPI();

    public List<AbstractSpellPart> getDefaultStartingSpells() {
        return this.spellpartMap.values().stream().filter(Config::isStarterEnabled).collect(Collectors.toList());
    }

    public Item getGlyphItem(String glyphName) {
        for (Item i : ItemsRegistry.RegistrationHandler.ITEMS) {
            if (!i.getRegistryName().equals((Object)new ResourceLocation("ars_nouveau", this.getSpellRegistryName(glyphName)))) continue;
            return i;
        }
        return null;
    }

    public Item getGlyphItem(AbstractSpellPart spell) {
        return this.getGlyphItem(spell.getId());
    }

    public Item getFamiliarItem(String id) {
        return this.familiarScriptMap.get(id);
    }

    public AbstractSpellPart registerSpell(String id, AbstractSpellPart part) {
        this.glyphItemMap.put(id, new Glyph(this.getSpellRegistryName(id), part));
        return this.spellpartMap.put(id, part);
    }

    public AbstractSpellPart registerSpell(AbstractSpellPart part) {
        return this.registerSpell(part.getId(), part);
    }

    public AbstractRitual registerRitual(String id, AbstractRitual ritual) {
        this.ritualParchmentMap.put(id, new RitualTablet(this.getRitualRegistryName(id), ritual));
        return this.ritualMap.put(id, ritual);
    }

    public AbstractFamiliarHolder registerFamiliar(AbstractFamiliarHolder familiar) {
        this.familiarScriptMap.put(familiar.id, new FamiliarScript(familiar));
        return this.familiarHolderMap.put(familiar.id, familiar);
    }

    @Nullable
    public AbstractRitual getRitual(String id) {
        if (!this.ritualMap.containsKey(id)) {
            return null;
        }
        try {
            return (AbstractRitual)this.ritualMap.get(id).getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSpellRegistryName(String id) {
        return "glyph_" + id.toLowerCase();
    }

    public String getRitualRegistryName(String id) {
        return "ritual_" + id.toLowerCase();
    }

    public Map<String, AbstractSpellPart> getSpellpartMap() {
        return this.spellpartMap;
    }

    public Map<String, Glyph> getGlyphItemMap() {
        return this.glyphItemMap;
    }

    public Map<String, AbstractRitual> getRitualMap() {
        return this.ritualMap;
    }

    public Map<String, RitualTablet> getRitualItemMap() {
        return this.ritualParchmentMap;
    }

    public Map<String, AbstractFamiliarHolder> getFamiliarHolderMap() {
        return this.familiarHolderMap;
    }

    public Map<String, FamiliarScript> getFamiliarScriptMap() {
        return this.familiarScriptMap;
    }

    public Set<RecipeType<? extends IEnchantingRecipe>> getEnchantingRecipeTypes() {
        return this.enchantingRecipeTypes;
    }

    public List<IEnchantingRecipe> getEnchantingApparatusRecipes(Level world) {
        ArrayList<IEnchantingRecipe> recipes = new ArrayList<IEnchantingRecipe>(this.enchantingApparatusRecipes);
        RecipeManager manager = world.m_7465_();
        ArrayList recipesByType = new ArrayList();
        for (RecipeType<? extends IEnchantingRecipe> type : this.enchantingRecipeTypes) {
            recipesByType.addAll(manager.m_44013_(type));
        }
        recipes.addAll(recipesByType);
        return recipes;
    }

    public List<BrewingRecipe> getAllPotionRecipes() {
        if (this.brewingRecipes.isEmpty()) {
            BrewingRecipeRegistry.getRecipes().forEach(ib -> {
                if (ib instanceof BrewingRecipe) {
                    BrewingRecipe brewingRecipe = (BrewingRecipe)ib;
                    this.brewingRecipes.add(brewingRecipe);
                }
            });
            this.vanillaPotionRecipes.forEach(vanillaPotionRecipe -> {
                BrewingRecipe recipe = new BrewingRecipe((Ingredient)PotionIngredient.fromPotion(vanillaPotionRecipe.potionIn), Ingredient.m_43929_((ItemLike[])new ItemLike[]{vanillaPotionRecipe.reagent}), PotionIngredient.fromPotion(vanillaPotionRecipe.potionOut).getStack());
                this.brewingRecipes.add(recipe);
            });
        }
        return this.brewingRecipes;
    }

    public ISpellValidator getSpellCraftingSpellValidator() {
        if (this.craftingSpellValidator == null) {
            this.craftingSpellValidator = new StandardSpellValidator(false);
        }
        return this.craftingSpellValidator;
    }

    public ISpellValidator getSpellCastingSpellValidator() {
        if (this.castingSpellValidator == null) {
            this.castingSpellValidator = new StandardSpellValidator(true);
        }
        return this.castingSpellValidator;
    }

    @Nullable
    public IScryer getScryer(String id) {
        return this.scryerMap.get(id);
    }

    public boolean registerScryer(IScryer scryer) {
        this.scryerMap.put(scryer.getID(), scryer);
        return true;
    }

    public ConcurrentHashMap<ResourceLocation, SpellSound> getSpellSoundsRegistry() {
        return this.spellSoundsRegistry;
    }

    public SpellSound registerSpellSound(SpellSound sound) {
        return this.spellSoundsRegistry.put(sound.getId(), sound);
    }

    private ArsNouveauAPI() {
    }

    public static ArsNouveauAPI getInstance() {
        return ARS_NOUVEAU_API;
    }
}

