/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class EffectPickup
extends AbstractEffect {
    public static EffectPickup INSTANCE = new EffectPickup();

    private EffectPickup() {
        super("pickup", "Item Pickup");
    }

    @Override
    public void onResolve(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockPos pos = new BlockPos(rayTraceResult.m_82450_());
        int expansion = 2 + spellStats.getBuffCount(AugmentAOE.INSTANCE);
        List entityList = world.m_45976_(ItemEntity.class, new AABB(pos.m_142385_(expansion).m_142390_(expansion).m_6630_(expansion), pos.m_142386_(expansion).m_142383_(expansion).m_6625_(expansion)));
        for (ItemEntity i : entityList) {
            if (this.isRealPlayer(shooter) && spellContext.castingTile == null) {
                ItemStack stack = i.m_32055_();
                Player player = (Player)shooter;
                VoidJar.tryVoiding(player, stack);
                if (player.m_36356_(stack)) continue;
                i.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                continue;
            }
            if (shooter instanceof IPickupResponder) {
                i.m_32045_(((IPickupResponder)shooter).onPickup(i.m_32055_()));
                continue;
            }
            if (!(spellContext.castingTile instanceof IPickupResponder)) continue;
            i.m_32045_(((IPickupResponder)spellContext.castingTile).onPickup(i.m_32055_()));
        }
    }

    @Override
    public boolean wouldSucceed(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        return true;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Picks up nearby items in a medium radius where this spell is activated. The range may be expanded with AOE.";
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.f_42155_;
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

