/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MageBlockTile;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;

public class EffectPhantomBlock
extends AbstractEffect {
    public static EffectPhantomBlock INSTANCE = new EffectPhantomBlock();

    private EffectPhantomBlock() {
        super("phantom_block", "Conjure Mageblock");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
        for (BlockPos pos : SpellUtil.calcAOEBlocks(shooter, rayTraceResult.m_82425_(), rayTraceResult, spellStats)) {
            BlockState state;
            BlockPos blockPos = pos = rayTraceResult.m_82436_() ? pos : pos.m_142300_(rayTraceResult.m_82434_());
            if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), world, pos) || !(state = world.m_8055_(pos)).m_60767_().m_76336_() || !world.m_45752_(BlockRegistry.MAGE_BLOCK.m_49966_(), pos, CollisionContext.m_82750_((Entity)fakePlayer))) continue;
            world.m_46597_(pos, BlockRegistry.MAGE_BLOCK.m_49966_());
            if (!(world.m_7702_(pos) instanceof MageBlockTile)) continue;
            MageBlockTile tile = (MageBlockTile)world.m_7702_(pos);
            tile.color = spellContext.colors.toParticleColor();
            tile.lengthModifier = spellStats.getDurationMultiplier();
            tile.isPermanent = spellStats.hasBuff(AugmentAmplify.INSTANCE);
            world.m_7260_(pos, world.m_8055_(pos), world.m_8055_(pos), 2);
        }
    }

    @Override
    public int getDefaultManaCost() {
        return 5;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.f_41904_;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentAmplify.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Creates a temporary block that will disappear after a short time. Amplify will cause the block to be permanent. ";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.CONJURATION);
    }
}

