/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EffectHarvest
extends AbstractEffect {
    public static EffectHarvest INSTANCE = new EffectHarvest();

    private EffectHarvest() {
        super("harvest", "Harvest");
    }

    public void harvestNetherwart(BlockPos pos, BlockState state, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if ((Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) != 3) {
            return;
        }
        this.processAndSpawnDrops(pos, state, world, shooter, spellStats, spellContext);
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(0)));
    }

    public void processAndSpawnDrops(BlockPos pos, BlockState state, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        List cropDrops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos));
        if (spellStats.hasBuff(AugmentFortune.INSTANCE)) {
            cropDrops = state.m_60724_(LootUtil.getFortuneContext((ServerLevel)world, pos, shooter, spellStats.getBuffCount(AugmentFortune.INSTANCE)));
        }
        for (ItemStack i : cropDrops) {
            if (!(i.m_41720_() instanceof BlockItem) || ((BlockItem)i.m_41720_()).m_40614_() != state.m_60734_()) continue;
            i.m_41774_(1);
            break;
        }
        cropDrops.forEach(d -> {
            if (d.m_41619_() || d.m_41720_() == BlockRegistry.MAGE_BLOOM_CROP.m_5456_()) {
                return;
            }
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), d));
        });
    }

    @Override
    public void onResolveBlock(BlockHitResult ray, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        for (BlockPos blockpos : SpellUtil.calcAOEBlocks(shooter, ray.m_82425_(), ray, spellStats)) {
            CropBlock cropsBlock;
            BlockState state = world.m_8055_(blockpos);
            if (state.m_60734_() instanceof FarmBlock || world.m_8055_(blockpos.m_7494_()).m_60734_() instanceof CropBlock || world.m_8055_(blockpos.m_7494_()).m_60734_() instanceof NetherWartBlock) {
                blockpos = blockpos.m_7494_();
                state = world.m_8055_(blockpos);
            }
            if (state.m_60734_() instanceof NetherWartBlock) {
                this.harvestNetherwart(blockpos, state, world, shooter, spellStats, spellContext);
                return;
            }
            if (!(state.m_60734_() instanceof CropBlock) || !(cropsBlock = (CropBlock)world.m_8055_(blockpos).m_60734_()).m_52307_(state) || !(world instanceof ServerLevel)) continue;
            this.processAndSpawnDrops(blockpos, state, world, shooter, spellStats, spellContext);
            world.m_46597_(blockpos, cropsBlock.m_52289_(1));
        }
    }

    @Override
    public boolean wouldSucceed(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (!(rayTraceResult instanceof BlockHitResult)) {
            return false;
        }
        BlockPos pos = ((BlockHitResult)rayTraceResult).m_82425_();
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof FarmBlock || world.m_8055_(pos.m_7494_()).m_60734_() instanceof CropBlock || world.m_8055_(pos.m_7494_()).m_60734_() instanceof NetherWartBlock) {
            pos = pos.m_7494_();
            state = world.m_8055_(pos);
        }
        if (state.m_60734_() instanceof NetherWartBlock && (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) == 3) {
            return true;
        }
        if (!(state.m_60734_() instanceof CropBlock)) {
            return false;
        }
        CropBlock cropsBlock = (CropBlock)world.m_8055_(pos).m_60734_();
        return cropsBlock.m_52307_(state) && world instanceof ServerLevel;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.f_42387_;
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentFortune.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "When used on grown crops, this spell will obtain the fully grown product without destroying the plant.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_EARTH);
    }
}

