/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.BlockHitResult;

public class EffectEvaporate
extends AbstractEffect {
    public static EffectEvaporate INSTANCE = new EffectEvaporate();

    private EffectEvaporate() {
        super("evaporate", "Evaporate");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveBlock(rayTraceResult, world, shooter, spellStats, spellContext);
        BlockPos pos = rayTraceResult.m_82425_();
        for (BlockPos p : SpellUtil.calcAOEBlocks(shooter, pos, rayTraceResult, spellStats.getBuffCount(AugmentAOE.INSTANCE), spellStats.getBuffCount(AugmentPierce.INSTANCE))) {
            this.evaporate(world, p);
            for (Direction d : Direction.values()) {
                this.evaporate(world, p.m_142300_(d));
            }
        }
    }

    public void evaporate(Level world, BlockPos p) {
        if (!world.m_6425_(p).m_76178_() && world.m_8055_(p).m_60734_() instanceof LiquidBlock) {
            world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    @Override
    public String getBookDescription() {
        return "Deletes fluids in an area. Can be expanded with AOE.";
    }

    @Override
    public int getDefaultManaCost() {
        return 50;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.f_41902_;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(AugmentAOE.INSTANCE);
    }
}

