/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class EffectCraft
extends AbstractEffect {
    public static EffectCraft INSTANCE = new EffectCraft();
    private static final Component CONTAINER_NAME = new TranslatableComponent("container.crafting");

    private EffectCraft() {
        super("craft", "Craft");
    }

    @Override
    public void onResolve(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (shooter instanceof Player) {
            Player playerEntity = (Player)shooter;
            if (this.isRealPlayer(shooter)) {
                playerEntity.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, player) -> new CustomWorkbench(id, inventory, ContainerLevelAccess.m_39289_((Level)player.m_20193_(), (BlockPos)player.m_142538_())), CONTAINER_NAME));
            }
        }
    }

    @Override
    public int getDefaultManaCost() {
        return 50;
    }

    @Override
    public Item getCraftingReagent() {
        return Items.f_41960_;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Opens the crafting menu.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    public static class CustomWorkbench
    extends CraftingMenu {
        public CustomWorkbench(int id, Inventory playerInventory) {
            super(id, playerInventory);
        }

        public CustomWorkbench(int id, Inventory playerInventory, ContainerLevelAccess p_i50090_3_) {
            super(id, playerInventory, p_i50090_3_);
        }

        public boolean m_6875_(Player playerIn) {
            return true;
        }
    }
}

